/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.codegenerator.constructorfield.edit;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.SpecialStr;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.Expr;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.NameTokType;
import org.python.pydev.parser.jython.ast.argumentsType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.refactoring.ast.adapters.FunctionDefAdapter;
import org.python.pydev.refactoring.ast.adapters.IClassDefAdapter;
import org.python.pydev.refactoring.ast.adapters.INodeAdapter;
import org.python.pydev.refactoring.codegenerator.constructorfield.request.ConstructorFieldRequest;
import org.python.pydev.refactoring.core.edit.AbstractInsertEdit;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorMethodEdit
extends AbstractInsertEdit {
    private static final String KW_ARG = "kwArg";
    private static final String VAR_ARG = "varArg";
    private int offsetStrategy;
    private List<INodeAdapter> attributes;
    private IClassDefAdapter classAdapter;

    public ConstructorMethodEdit(ConstructorFieldRequest req) {
        super(req);
        this.classAdapter = req.getClassAdapter();
        this.attributes = req.getAttributeAdapters();
        this.offsetStrategy = req.getOffsetStrategy();
    }

    @Override
    protected SimpleNode getEditNode() {
        List<IClassDefAdapter> bases = this.classAdapter.getBaseClasses();
        ArrayList<stmtType> body = new ArrayList<stmtType>();
        argumentsType args = this.extractArguments(bases);
        this.constructorCalls(bases, body);
        this.initAttributes(body);
        return new FunctionDef((NameTokType)new NameTok("__init__", 2), args, body.toArray(new stmtType[0]), null);
    }

    private void initAttributes(List<stmtType> body) {
        for (INodeAdapter adapter : this.attributes) {
            Assign initParam = this.initAttribute(adapter);
            body.add((stmtType)initParam);
        }
    }

    private void constructorCalls(List<IClassDefAdapter> bases, List<stmtType> body) {
        for (IClassDefAdapter base : bases) {
            Expr init = this.extractConstructorInit(base);
            if (init == null) continue;
            body.add((stmtType)init);
        }
    }

    private Assign initAttribute(INodeAdapter adapter) {
        Attribute target = new Attribute((exprType)new Name("self", 1), (NameTokType)new NameTok(adapter.getName(), 8), 2);
        Assign initParam = new Assign(new exprType[]{target}, (exprType)new Name(this.nodeHelper.getPublicAttr(adapter.getName()), 1));
        return initParam;
    }

    private Expr extractConstructorInit(IClassDefAdapter base) {
        FunctionDefAdapter init = base.getFirstInit();
        if (init != null && !init.getArguments().hasOnlySelf()) {
            Attribute classInit = new Attribute((exprType)new Name(this.moduleAdapter.getBaseContextName(this.classAdapter, base.getName()), 1), (NameTokType)new NameTok("__init__", 8), 1);
            List<exprType> constructorParameters = init.getArguments().getSelfFilteredArgs();
            Name selfArg = new Name("self", 1);
            if (constructorParameters.size() > 0 || init.getArguments().hasVarArg() || init.getArguments().hasKwArg()) {
                selfArg.getSpecialsAfter().add(new SpecialStr(",", 0, 0));
            }
            constructorParameters.add(0, (exprType)selfArg);
            exprType[] argExp = constructorParameters.toArray(new exprType[0]);
            Name varArg = null;
            Name kwArg = null;
            if (init.getArguments().hasVarArg()) {
                varArg = new Name(VAR_ARG, 1);
            }
            if (init.getArguments().hasKwArg()) {
                kwArg = new Name(KW_ARG, 1);
            }
            Call initCall = new Call((exprType)classInit, argExp, null, (exprType)varArg, (exprType)kwArg);
            return new Expr((exprType)initCall);
        }
        return null;
    }

    private argumentsType extractArguments(List<IClassDefAdapter> bases) {
        NameTok varArg = null;
        NameTok kwArg = null;
        TreeSet<String> argsNames = new TreeSet<String>();
        for (IClassDefAdapter baseClass : bases) {
            FunctionDefAdapter init = baseClass.getFirstInit();
            if (init == null) continue;
            if (!init.getArguments().hasOnlySelf()) {
                argsNames.addAll(init.getArguments().getSelfFilteredArgNames());
            }
            if (varArg == null && init.getArguments().hasVarArg()) {
                varArg = new NameTok(VAR_ARG, 5);
            }
            if (kwArg != null || !init.getArguments().hasKwArg()) continue;
            kwArg = new NameTok(KW_ARG, 6);
        }
        this.addOwnArguments(argsNames);
        exprType[] argsExpr = this.generateExprArray(argsNames);
        return new argumentsType(argsExpr, varArg, kwArg, null);
    }

    private exprType[] generateExprArray(SortedSet<String> argsNames) {
        ArrayList<Name> argsExprList = new ArrayList<Name>();
        Name selfArg = new Name("self", 6);
        argsExprList.add(selfArg);
        for (String parameter : argsNames) {
            argsExprList.add(new Name(parameter.trim(), 6));
        }
        exprType[] argsExpr = argsExprList.toArray(new exprType[0]);
        return argsExpr;
    }

    private void addOwnArguments(SortedSet<String> argsNames) {
        for (INodeAdapter adapter : this.attributes) {
            argsNames.add(this.nodeHelper.getPublicAttr(adapter.getName()));
        }
    }

    @Override
    public int getOffsetStrategy() {
        return this.offsetStrategy;
    }
}

