/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ast.printer;

import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.SpecialStr;
import org.python.pydev.parser.jython.ast.Num;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.refactoring.ast.printer.CallDepth;
import org.python.pydev.refactoring.ast.printer.SyntaxHelper;
import org.python.pydev.refactoring.ast.visitors.NodeHelper;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourcePrinter {
    private boolean disabledIfPrinting;
    private final SyntaxHelper syntaxHelper;
    private boolean ignoreComments;
    private final NodeHelper nodeHelper;
    private final PrintWriter output;
    private final CallDepth callDepth;
    private String newLineDelim;

    public SourcePrinter(PrintWriter output, String newLineDelim) {
        this(output, new SyntaxHelper(newLineDelim), new CallDepth(), false);
        this.newLineDelim = newLineDelim;
    }

    public SourcePrinter(PrintWriter output, SyntaxHelper formatHelper, CallDepth callDepth, boolean ignoreComments) {
        this.output = output;
        this.syntaxHelper = formatHelper;
        this.callDepth = callDepth;
        this.ignoreComments = ignoreComments;
        this.disabledIfPrinting = false;
        this.nodeHelper = new NodeHelper(this.newLineDelim);
    }

    protected List<commentType> extractComments(List<Object> specials) {
        if (specials == null) {
            return null;
        }
        ArrayList<commentType> comments = new ArrayList<commentType>();
        for (Object node : specials) {
            if (!(node instanceof commentType)) continue;
            commentType comment = (commentType)node;
            comments.add(comment);
        }
        return comments;
    }

    protected List<commentType> extractComments(List<Object> specials, SimpleNode firstBodyNode, boolean before) {
        if (specials == null) {
            return null;
        }
        ArrayList<commentType> comments = new ArrayList<commentType>();
        for (commentType comment : this.extractComments(specials)) {
            if (firstBodyNode == null) continue;
            if (before) {
                if (comment.beginLine >= firstBodyNode.beginLine) continue;
                comments.add(comment);
                continue;
            }
            if (comment.beginLine < firstBodyNode.beginLine) continue;
            comments.add(comment);
        }
        return comments;
    }

    public void flushStream() {
        this.output.flush();
    }

    public int getStartLine(SimpleNode n) {
        return this.nodeHelper.getStartLine(n);
    }

    public int getStartOffset(SimpleNode n) {
        return this.nodeHelper.getStartOffset(n);
    }

    public SyntaxHelper getSyntaxhelper() {
        return this.syntaxHelper;
    }

    public boolean hasCommentsAfter(SimpleNode node) {
        if (node == null) {
            return false;
        }
        if (node.specialsAfter == null) {
            return false;
        }
        List<commentType> comments = this.extractComments(node.specialsAfter);
        return comments != null && comments.size() > 0;
    }

    public void indent() {
        this.syntaxHelper.indent();
    }

    public boolean isCommentBefore(SimpleNode node, commentType comment) {
        return this.getStartLine((SimpleNode)comment) < this.getStartLine(node);
    }

    public boolean isDisabledIfPrinting() {
        return this.disabledIfPrinting;
    }

    private boolean isIgnoreComments(SimpleNode node) {
        return this.ignoreComments || node == null;
    }

    public boolean isPrettyPrint(SimpleNode node) {
        return this.nodeHelper.isFunctionOrClassDef(node) || this.isPrettyPrintControlStatement(node);
    }

    public boolean isPrettyPrintControlStatement(SimpleNode node) {
        return this.nodeHelper.isControlStatement(node) && !this.isDisabledIfPrinting();
    }

    public boolean isSameLine(SimpleNode node1, SimpleNode node2) {
        return this.getStartLine(node1) == this.getStartLine(node2);
    }

    public void outdent() {
        this.syntaxHelper.outdent();
    }

    public void prettyPrintAfter(SimpleNode node, SimpleNode lastNode) {
        if (!this.inCall() && this.isPrettyPrint(node) && this.isPrettyPrint(lastNode)) {
            this.printNewlineAndIndentation();
        }
    }

    public void print(BigInteger i) {
        this.output.print(i);
    }

    public void print(char c) {
        this.output.print(c);
    }

    public void print(double d) {
        this.output.print(d);
    }

    public void print(int i) {
        this.output.print(i);
    }

    public void print(long l) {
        this.output.print(l);
    }

    public void print(Object o) {
        this.output.print(String.valueOf(o));
    }

    public void print(String s) {
        this.output.print(s);
    }

    public void printAfterDict() {
        this.print(this.syntaxHelper.afterDict());
    }

    public void printAfterList() {
        this.print(this.syntaxHelper.afterList());
    }

    public void printAfterTuple() {
        this.print(this.syntaxHelper.afterTuple());
    }

    public void printAssignmentOperator(boolean spaceBefore, boolean spaceAfter) {
        if (spaceBefore) {
            this.printSpace();
        }
        this.print(this.syntaxHelper.getOperatorAssignment());
        if (spaceAfter) {
            this.printSpace();
        }
    }

    public void printAttributeSeparator() {
        this.print(this.syntaxHelper.getAttributeSeparator());
    }

    public void printBeforeAndAfterCmpOp() {
        this.printSpace();
    }

    public void printBeforeComment() {
        this.print(this.syntaxHelper.afterStatement());
    }

    public void printBeforeDecorator() {
        this.print(this.syntaxHelper.getAtSymbol());
    }

    public void printBeforeDict() {
        this.print(this.syntaxHelper.beforeDict());
    }

    public void printBeforeKwArg() {
        this.print(this.syntaxHelper.getStar(2));
    }

    public void printBeforeList() {
        this.print(this.syntaxHelper.beforeList());
    }

    public void printBeforeTuple() {
        this.print(this.syntaxHelper.beforeTuple());
    }

    public void printBeforeVarArg() {
        this.print(this.syntaxHelper.getStar(1));
    }

    public void printBinOp(int opType, boolean spaceBefore, boolean spaceAfter) {
        String op;
        switch (opType) {
            case 1: {
                op = this.syntaxHelper.getOperatorAdd();
                break;
            }
            case 11: {
                op = this.syntaxHelper.getOperatorBitAnd();
                break;
            }
            case 9: {
                op = this.syntaxHelper.getOperatorBitOr();
                break;
            }
            case 10: {
                op = this.syntaxHelper.getOperatorBitXor();
                break;
            }
            case 4: {
                op = this.syntaxHelper.getOperatorDiv();
                break;
            }
            case 12: {
                op = this.syntaxHelper.getOperatorFloorDiv();
                break;
            }
            case 7: {
                op = this.syntaxHelper.getOperatorShiftLeft();
                break;
            }
            case 5: {
                op = this.syntaxHelper.getOperatorMod();
                break;
            }
            case 3: {
                op = this.syntaxHelper.getOperatorMult();
                break;
            }
            case 6: {
                op = this.syntaxHelper.getOperatorPow();
                break;
            }
            case 8: {
                op = this.syntaxHelper.getOperatorShiftRight();
                break;
            }
            case 2: {
                op = this.syntaxHelper.getOperatorSub();
                break;
            }
            default: {
                op = "<undef_binop>";
            }
        }
        if (spaceBefore) {
            this.printSpace();
        }
        this.print(op);
        if (spaceAfter) {
            this.printSpace();
        }
    }

    public void printBoolOp(int op) {
        this.printSpace();
        switch (op) {
            case 1: {
                this.print(this.syntaxHelper.getOperatorBoolAnd());
                break;
            }
            case 2: {
                this.print(this.syntaxHelper.getOperatorBoolOr());
                break;
            }
            default: {
                this.print("<undef_boolop>");
            }
        }
        this.printSpace();
    }

    public void printClassDef() {
        this.printStatement("class");
    }

    protected void printComment(SimpleNode node, List<commentType> comments) {
        if (comments == null) {
            return;
        }
        boolean wasOnSameLine = false;
        for (commentType comment : comments) {
            String commentText = comment.id.trim();
            if (this.isSameLine(node, (SimpleNode)comment)) {
                this.printBeforeComment();
                wasOnSameLine = true;
            } else {
                this.printNewlineAndIndentation();
            }
            this.print(commentText);
            if (!this.isCommentBefore(node, comment) || wasOnSameLine) continue;
            this.printNewlineAndIndentation();
        }
    }

    public void printCommentAfter(SimpleNode node) {
        if (!this.isIgnoreComments(node) && !this.nodeHelper.isControlStatement(node)) {
            this.printComment(node, this.extractComments(node.specialsAfter));
        }
    }

    public void printCommentBeforeBody(SimpleNode node, SimpleNode firstBodyNode) {
        if (!this.isIgnoreComments(node)) {
            this.printComment(node, this.extractComments(node.specialsAfter, firstBodyNode, true));
        }
    }

    public void printCommentAfterBody(SimpleNode node, SimpleNode firstBodyNode) {
        if (!this.isIgnoreComments(node)) {
            this.printComment(node, this.extractComments(node.specialsAfter, firstBodyNode, false));
        }
    }

    public void printCommentBefore(SimpleNode node) {
        if (!this.isIgnoreComments(node)) {
            this.printComment(node, this.extractComments(node.specialsBefore));
        }
    }

    public void printCompOp(int opType) {
        switch (opType) {
            case 1: {
                this.print(this.syntaxHelper.getOperatorEqual());
                break;
            }
            case 5: {
                this.print(this.syntaxHelper.getOperatorGt());
                break;
            }
            case 6: {
                this.print(this.syntaxHelper.getOperatorGtEqual());
                break;
            }
            case 9: {
                this.print(this.syntaxHelper.getOperatorIn());
                break;
            }
            case 7: {
                this.print(this.syntaxHelper.getOperatorIs());
                break;
            }
            case 8: {
                this.print(this.syntaxHelper.getOperatorIsNot());
                break;
            }
            case 3: {
                this.print(this.syntaxHelper.getOperatorLt());
                break;
            }
            case 4: {
                this.print(this.syntaxHelper.getOperatorLtEqual());
                break;
            }
            case 2: {
                this.print(this.syntaxHelper.getOperatorNotEqual());
                break;
            }
            case 10: {
                this.print(this.syntaxHelper.getOperatorNotIn());
                break;
            }
            default: {
                this.print("<undef_compop>");
            }
        }
    }

    public void printContinue() {
        this.printStatement("continue", false, false);
    }

    public void printDestinationOperator(boolean withSpaceBefore, boolean withSpaceAfter) {
        if (withSpaceBefore) {
            this.printSpace();
        }
        this.print(this.syntaxHelper.getOperatorDestination());
        if (withSpaceAfter) {
            this.printSpace();
        }
    }

    public void printDictBeforeValue() {
        this.printFunctionMarker();
        this.printSpace();
    }

    public void printDoubleDot() {
        this.print(this.syntaxHelper.getDoubleDot());
    }

    public void printDoubleDotAndNewline() {
        this.printDoubleDot();
        this.printNewlineAndIndentation();
    }

    protected void printDoubleQuote() {
        this.print(this.syntaxHelper.getDoubleQuote());
    }

    public void printEllipsis() {
        this.print(this.syntaxHelper.getEllipsis());
    }

    public void printFunctionDef() {
        this.printStatement("def");
    }

    public void printFunctionMarker() {
        this.printDoubleDot();
    }

    public void printFunctionMarkerWithSpace() {
        this.printFunctionMarker();
        this.printSpace();
    }

    public void printListSeparator() {
        this.print(this.syntaxHelper.getListSeparator());
    }

    public void printListSeparator(String separatorStr) {
        if (separatorStr == null) {
            this.printListSeparator();
        } else {
            this.print(separatorStr);
        }
    }

    public void printNewlineAndIndentation() {
        this.print(this.syntaxHelper.getNewLine());
        this.print(this.syntaxHelper.getAlignment());
    }

    public void printNum(Num node) {
        this.print(node.num);
    }

    protected void printSingleQuote() {
        this.print(this.syntaxHelper.getSingleQuote());
    }

    protected void printSpace() {
        this.print(this.syntaxHelper.getSpace());
    }

    protected void printStatement(String statement) {
        this.printStatement(statement, false, true);
    }

    protected void printStatement(String statement, boolean spaceBefore, boolean spaceAfter) {
        if (spaceBefore) {
            this.print(this.syntaxHelper.beforeStatement());
        }
        this.print(statement);
        if (spaceAfter) {
            this.print(this.syntaxHelper.afterStatement());
        }
    }

    public void printStatementAs() {
        this.printStatement("as", true, true);
    }

    public void printStatementAssert() {
        this.printStatement("assert");
    }

    public void printStatementBreak() {
        this.print("break");
    }

    public void printStatementDel() {
        this.printStatement("del");
    }

    public void printStatementElif() {
        this.printStatement("elif");
    }

    public void printStatementElse() {
        this.print("else");
    }

    public void printStatementElseWithSpace() {
        this.printSpace();
        this.printStatementElse();
        this.printSpace();
    }

    public void printStatementExcept(boolean spaceAfter) {
        this.printStatement("except", false, spaceAfter);
    }

    public void printStatementExec() {
        this.printStatement("exec");
    }

    public void printStatementFinally() {
        this.print("finally");
    }

    public void printStatementFor(boolean spaceBefore, boolean spaceAfter) {
        this.printStatement("for", spaceBefore, spaceAfter);
    }

    public void printStatementFrom() {
        this.printStatement("from", false, true);
    }

    public void printStatementFromImport() {
        this.printStatement("import", true, true);
    }

    public void printStatementGlobal() {
        this.printStatement("global");
    }

    public void printStatementIf(SimpleNode node, boolean spaceBefore, boolean spaceAfter) {
        if (!this.isDisabledIfPrinting()) {
            this.printStatement("if", spaceBefore, spaceAfter);
        } else {
            if (node != null) {
                for (Object o : node.specialsBefore) {
                    if (!(o instanceof SpecialStr)) continue;
                    SpecialStr specialStr = (SpecialStr)o;
                    if (!specialStr.str.trim().equals("if")) continue;
                    this.printStatement("if", spaceBefore, spaceAfter);
                    return;
                }
            }
            this.setDisabledIfPrinting(false);
        }
    }

    public void printStatementImport() {
        this.printStatement("import");
    }

    public void printStatementIn() {
        this.printStatement("in", true, true);
    }

    public void printstatementLambda() {
        this.printStatement("lambda");
    }

    public void printStatementPass() {
        this.printStatement("pass", false, false);
    }

    public void printStatementPrint() {
        this.printStatement("print");
    }

    public void printStatementRaise(boolean spaceAfter) {
        this.printStatement("raise", false, spaceAfter);
    }

    public void printStatementReturn() {
        this.printStatement("return");
    }

    public void printStatementTry() {
        this.print("try");
    }

    public void printStatementWhile() {
        this.printStatement("while");
    }

    public void printStatementWith() {
        this.printStatement("with");
    }

    public void printStatementYield() {
        this.printStatement("yield");
    }

    public void printStr(Str node) {
        if (node.unicode) {
            this.print("u");
        }
        if (node.raw) {
            this.print("r");
        }
        this.printStrQuote(node);
        this.print(node.s);
        this.printStrQuote(node);
    }

    public void printStrQuote(Str node) {
        switch (node.type) {
            case 4: {
                this.printDoubleQuote();
                break;
            }
            case 3: {
                this.printSingleQuote();
                break;
            }
            case 2: {
                this.printTripeDoubleQuote();
                break;
            }
            case 1: {
                this.printTripeSingleQuote();
            }
        }
    }

    public void printTripeDoubleQuote() {
        int i = 0;
        while (i < 3) {
            this.printDoubleQuote();
            ++i;
        }
    }

    public void printTripeSingleQuote() {
        int i = 0;
        while (i < 3) {
            this.printSingleQuote();
            ++i;
        }
    }

    public void printUnaryOp(int opType) {
        String op;
        switch (opType) {
            case 1: {
                op = this.syntaxHelper.getOperatorInvert();
                break;
            }
            case 2: {
                op = this.syntaxHelper.getOperatorNot();
                break;
            }
            case 3: {
                op = this.syntaxHelper.getOperatorUAdd();
                break;
            }
            case 4: {
                op = this.syntaxHelper.getOperatorUSub();
                break;
            }
            default: {
                op = "<undef_unaryop>";
            }
        }
        this.print(op);
        if (opType == 2) {
            this.printSpace();
        }
    }

    public void setDisabledIfPrinting(boolean disabledIfPrinting) {
        this.disabledIfPrinting = disabledIfPrinting;
    }

    public void setIgnoreComments(boolean ignoreComments) {
        this.ignoreComments = ignoreComments;
    }

    public void printReprQuote() {
        this.print(this.syntaxHelper.getReprQuote());
    }

    public NodeHelper getNodeHelper() {
        return this.nodeHelper;
    }

    public boolean hasSpecialBefore(SimpleNode n, String match) {
        if (n == null) {
            return false;
        }
        return this.checkSpecialStr(n.getSpecialsBefore(), match);
    }

    public boolean hasSpecialAfter(SimpleNode n, String match) {
        if (n == null) {
            return false;
        }
        return this.checkSpecialStr(n.getSpecialsAfter(), match);
    }

    public boolean checkSpecialStr(List<Object> specials, String pattern) {
        for (Object object : specials) {
            String text;
            if (object instanceof SpecialStr) {
                SpecialStr str = (SpecialStr)object;
                if (str.str.compareTo(pattern) != 0) continue;
                return true;
            }
            if (!(object instanceof String) || (text = (String)object).compareTo(pattern) != 0) continue;
            return true;
        }
        return false;
    }

    public void openParentheses(SimpleNode n) {
        if (this.needsParentheses(n)) {
            this.printBeforeTuple();
        }
    }

    public void closeParentheses(SimpleNode n) {
        if (this.needsParentheses(n)) {
            this.printAfterTuple();
        }
    }

    protected boolean needsParentheses(SimpleNode n) {
        return this.inCall() || this.hasParentheses(n);
    }

    protected boolean needsBracket(SimpleNode n) {
        return this.hasBracket(n) || this.nodeHelper.isList(n);
    }

    protected boolean hasParentheses(SimpleNode n) {
        return this.hasSpecialBefore(n, this.getSyntaxhelper().beforeTuple());
    }

    boolean hasBracket(SimpleNode n) {
        return this.hasSpecialBefore(n, this.getSyntaxhelper().beforeList());
    }

    public void closeBracket(SimpleNode n) {
        if (this.needsBracket(n)) {
            this.printAfterList();
        }
    }

    public void openBracket(SimpleNode n) {
        if (this.needsBracket(n)) {
            this.printBeforeList();
        }
    }

    public CallDepth getCallDepth() {
        return this.callDepth;
    }

    public void enterCall() {
        this.callDepth.enterCall();
    }

    public void leaveCall() {
        this.callDepth.leaveCall();
    }

    public boolean inCall() {
        return this.callDepth.inCall();
    }
}

