/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ast.adapters;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.argumentsType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.refactoring.ast.adapters.AbstractNodeAdapter;
import org.python.pydev.refactoring.ast.adapters.FunctionDefAdapter;
import org.python.pydev.refactoring.ast.adapters.ModuleAdapter;
import org.python.pydev.refactoring.ast.rewriter.RewriterVisitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionArgAdapter
extends AbstractNodeAdapter<argumentsType> {
    public FunctionArgAdapter(ModuleAdapter module, FunctionDefAdapter parent, argumentsType node, String endLineDelim) {
        super(module, parent, node, endLineDelim);
        Assert.isNotNull((Object)module);
    }

    public boolean hasKwArg() {
        return ((argumentsType)this.getASTNode()).kwarg != null;
    }

    public boolean hasVarArg() {
        return ((argumentsType)this.getASTNode()).vararg != null;
    }

    public boolean hasArg() {
        return ((argumentsType)this.getASTNode()).args != null && ((argumentsType)this.getASTNode()).args.length > 0;
    }

    public List<String> getArgOnly() {
        ArrayList<String> args = new ArrayList<String>();
        exprType[] exprTypeArray = ((argumentsType)this.getASTNode()).args;
        int n = ((argumentsType)this.getASTNode()).args.length;
        int n2 = 0;
        while (n2 < n) {
            exprType arg = exprTypeArray[n2];
            args.add(this.nodeHelper.getName((SimpleNode)arg));
            ++n2;
        }
        return args;
    }

    public List<String> getSelfFilteredArgNames() {
        ArrayList<String> args = new ArrayList<String>();
        for (exprType arg : this.getSelfFilteredArgs()) {
            args.add(this.nodeHelper.getName((SimpleNode)arg));
        }
        return args;
    }

    public List<exprType> getSelfFilteredArgs() {
        ArrayList<exprType> args = new ArrayList<exprType>();
        if (((argumentsType)this.getASTNode()).args == null) {
            return args;
        }
        exprType[] exprTypeArray = ((argumentsType)this.getASTNode()).args;
        int n = ((argumentsType)this.getASTNode()).args.length;
        int n2 = 0;
        while (n2 < n) {
            exprType arg = exprTypeArray[n2];
            String argument = this.nodeHelper.getName((SimpleNode)arg);
            if (!this.nodeHelper.isSelf(argument)) {
                args.add(arg);
            }
            ++n2;
        }
        return args;
    }

    public boolean isEmptyArgument() {
        return !this.hasArg() && !this.hasVarArg() && !this.hasKwArg();
    }

    public boolean hasOnlySelf() {
        return this.getSelfFilteredArgs().size() == 0 && !this.hasVarArg() && !this.hasKwArg();
    }

    public String getSignature() {
        String endLineDelimiter = this.getModule().getEndLineDelimiter();
        return RewriterVisitor.createSourceFromAST(this.getASTNode(), true, endLineDelimiter);
    }
}

