/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.utils;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyFileListing {
    public static PyFileListingInfo getPyFilesBelow(File file, FileFilter filter, IProgressMonitor monitor, boolean addSubFolders, int level, boolean checkHasInit, String currModuleRep) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        PyFileListingInfo ret = new PyFileListingInfo();
        if (file != null && file.exists()) {
            if (file.isDirectory()) {
                if (level != 0) {
                    StringBuffer newModuleRep = new StringBuffer(currModuleRep);
                    if (newModuleRep.length() != 0) {
                        newModuleRep.append(".");
                    }
                    newModuleRep.append(file.getName());
                    currModuleRep = newModuleRep.toString();
                }
                File[] files = null;
                files = filter != null ? file.listFiles(filter) : file.listFiles();
                boolean hasInit = false;
                LinkedList<File> foldersLater = new LinkedList<File>();
                int i = 0;
                while (i < files.length) {
                    File file2 = files[i];
                    if (file2.isFile()) {
                        ret.filesFound.add(file2);
                        ret.fileParentPathNamesRelativeToRoot.add(currModuleRep);
                        monitor.worked(1);
                        monitor.setTaskName(new StringBuffer("Found:").append(file2.toString()).toString());
                        if (checkHasInit && !hasInit && PythonPathHelper.isValidInitFile(file2.getName())) {
                            hasInit = true;
                        }
                    } else {
                        foldersLater.add(file2);
                    }
                    ++i;
                }
                if (!checkHasInit || hasInit || level == 0) {
                    ret.foldersFound.add(file);
                    for (File file2 : foldersLater) {
                        if (!file2.isDirectory() || !addSubFolders) continue;
                        ret.extendWith(PyFileListing.getPyFilesBelow(file2, filter, monitor, addSubFolders, level + 1, checkHasInit, currModuleRep));
                        monitor.worked(1);
                    }
                }
            } else if (file.isFile()) {
                ret.fileParentPathNamesRelativeToRoot.add(currModuleRep);
                ret.filesFound.add(file);
            } else {
                throw new RuntimeException("Not dir nor file... what is it?");
            }
        }
        return ret;
    }

    public static PyFileListingInfo getPyFilesBelow(File file, FileFilter filter, IProgressMonitor monitor, boolean addSubFolders, boolean checkHasInit) {
        return PyFileListing.getPyFilesBelow(file, filter, monitor, addSubFolders, 0, checkHasInit, "");
    }

    public static PyFileListingInfo getPyFilesBelow(File file, FileFilter filter, IProgressMonitor monitor, boolean checkHasInit) {
        return PyFileListing.getPyFilesBelow(file, filter, monitor, true, checkHasInit);
    }

    public static FileFilter getPyFilesFileFilter(final boolean includeDirs) {
        return new FileFilter(){

            public boolean accept(File pathname) {
                if (includeDirs) {
                    if (pathname.isDirectory()) {
                        return true;
                    }
                    return PythonPathHelper.isValidSourceFile(pathname.toString());
                }
                if (pathname.isDirectory()) {
                    return false;
                }
                return PythonPathHelper.isValidSourceFile(pathname.toString());
            }
        };
    }

    public static PyFileListingInfo getPyFilesBelow(File file, IProgressMonitor monitor, boolean includeDirs, boolean checkHasInit) {
        FileFilter filter = PyFileListing.getPyFilesFileFilter(includeDirs);
        return PyFileListing.getPyFilesBelow(file, filter, monitor, true, checkHasInit);
    }

    public static List<IFile> getAllIFilesBelow(IFolder member) {
        final ArrayList<IFile> ret = new ArrayList<IFile>();
        try {
            member.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) {
                    if (resource instanceof IFile) {
                        ret.add((IFile)resource);
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    public static class PyFileListingInfo {
        public List<File> filesFound = new ArrayList<File>();
        public List<File> foldersFound = new ArrayList<File>();
        public List<String> fileParentPathNamesRelativeToRoot = new ArrayList<String>();

        public void extendWith(PyFileListingInfo other) {
            this.filesFound.addAll(other.filesFound);
            this.foldersFound.addAll(other.foldersFound);
            this.fileParentPathNamesRelativeToRoot.addAll(other.fileParentPathNamesRelativeToRoot);
        }
    }
}

