/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.wizards.files;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.ui.wizards.files.AbstractPythonWizard;
import org.python.pydev.ui.wizards.files.PythonAbstractPathPage;

public class PythonSourceFolderWizard
extends AbstractPythonWizard {
    public static final String WIZARD_ID = "org.python.pydev.ui.wizards.files.PythonSourceFolderWizard";

    public PythonSourceFolderWizard() {
        super("Create a new Source Folder");
    }

    protected PythonAbstractPathPage createPathPage() {
        return new PythonAbstractPathPage(this.description, this.selection){

            protected boolean shouldCreateSourceFolderSelect() {
                return false;
            }

            protected boolean shouldCreatePackageSelect() {
                return false;
            }
        };
    }

    protected IFile doCreateNew(IProgressMonitor monitor) throws CoreException {
        IPythonNature nature;
        IProject project = this.filePage.getValidatedProject();
        String name = this.filePage.getValidatedName();
        if (project == null || !project.exists()) {
            throw new RuntimeException("The project selected does not exist in the workspace.");
        }
        IPythonPathNature pathNature = PythonNature.getPythonPathNature(project);
        if (pathNature == null && (pathNature = (nature = PythonNature.addNature(project, monitor, null, null)).getPythonPathNature()) == null) {
            throw new RuntimeException("Unable to add the nature to the seleted project.");
        }
        IFolder folder = project.getFolder(name);
        if (!folder.exists()) {
            folder.create(true, true, monitor);
        }
        String newPath = folder.getFullPath().toString();
        String curr = pathNature.getProjectSourcePath();
        if (curr == null) {
            curr = "";
        }
        if (curr.endsWith("|")) {
            curr = curr.substring(0, curr.length() - 1);
        }
        curr = curr.length() > 0 ? String.valueOf(curr) + "|" + newPath : newPath;
        pathNature.setProjectSourcePath(curr);
        PythonNature.getPythonNature(project).rebuildPath();
        return null;
    }
}

