/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.pyunit;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.python.pydev.core.REF;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.SocketUtil;

public class PyUnitTestRunner {
    public static final int BUFFER_SIZE = 4096;
    public Process process;
    private Socket socketToRead;
    private File serverFile;
    private ServerSocket serverSocket;
    private BufferedReader reader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleepALittle(int t) {
        try {
            PyUnitTestRunner pyUnitTestRunner = this;
            synchronized (pyUnitTestRunner) {
                this.wait(t);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static File getScriptWithinPySrc(String targetExec) throws CoreException {
        IPath relative = new Path("PySrc").addTrailingSeparator().append(targetExec);
        Bundle bundle = PydevPlugin.getDefault().getBundle();
        URL bundleURL = Platform.find((Bundle)bundle, (IPath)relative);
        try {
            URL fileURL = Platform.asLocalURL((URL)bundleURL);
            File f = new File(fileURL.getPath());
            return f;
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)PydevPlugin.makeStatus(4, "Can't find python script", null));
        }
    }

    public void runTests(String testModuleDir, String testModuleName, IProject project) throws IOException {
        int pRead = SocketUtil.findUnusedLocalPort();
        if (this.process != null) {
            this.endIt();
        }
        try {
            this.serverFile = PyUnitTestRunner.getScriptWithinPySrc("SocketTestRunner.py");
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        String command = "python " + REF.getFileAbsolutePath((File)this.serverFile) + " " + pRead + " ";
        command = String.valueOf(command) + testModuleDir + " " + testModuleName;
        this.process = Runtime.getRuntime().exec(command);
        this.sleepALittle(1000);
        try {
            this.serverSocket = new ServerSocket(pRead);
            try {
                this.socketToRead = this.serverSocket.accept();
                try {
                    this.readMessage();
                }
                finally {
                    this.socketToRead.close();
                }
            }
            finally {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            if (this.process != null) {
                this.process.destroy();
            }
            e.printStackTrace();
            throw e;
        }
    }

    private void readMessage() throws IOException {
        this.reader = new BufferedReader(new InputStreamReader(this.socketToRead.getInputStream()));
        try {
            String line = null;
            while ((line = this.reader.readLine()) != null) {
                this.parseMessage(line);
            }
        }
        finally {
            this.reader.close();
        }
    }

    private void parseMessage(String line) {
        String klass;
        int start;
        PydevPlugin plugin = PydevPlugin.getDefault();
        if (line.startsWith("starting tests ")) {
            start = "starting tests ".length();
            int count = Integer.parseInt(line.substring(start));
            plugin.fireTestsStarted(count);
        }
        if (line.startsWith("ending tests")) {
            plugin.fireTestsFinished();
        }
        if (line.startsWith("starting test ")) {
            start = "starting test ".length();
            String method = line.substring(start, line.indexOf("("));
            klass = line.substring(line.indexOf("(") + 1, line.indexOf(")"));
            plugin.fireTestStarted(klass, method);
        }
        if (line.startsWith("failing test ")) {
            start = "failing test ".length();
            String method = line.substring(start, line.indexOf("("));
            klass = line.substring(line.indexOf("(") + 1, line.indexOf(")"));
            StringWriter buffer = new StringWriter();
            PrintWriter writer = new PrintWriter(buffer);
            String frame = null;
            try {
                while ((frame = this.reader.readLine()) != null && !frame.equals("END TRACE")) {
                    writer.println(frame);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String trace = buffer.getBuffer().toString();
            plugin.fireTestFailed(klass, method, trace);
        }
    }

    private void closeConn() throws IOException {
        if (this.socketToRead != null) {
            this.socketToRead.close();
        }
        this.socketToRead = null;
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
        this.serverSocket = null;
    }

    void endIt() {
        try {
            this.closeConn();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.process != null) {
            try {
                int i = this.process.getErrorStream().available();
                byte[] b = new byte[i];
                this.process.getErrorStream().read(b);
                System.out.println(new String(b));
                i = this.process.getInputStream().available();
                b = new byte[i];
                this.process.getErrorStream().read(b);
                System.out.println(new String(b));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            try {
                this.process.destroy();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            try {
                this.process.waitFor();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            this.process = null;
        }
    }
}

