/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin.nature;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.IToken;
import org.python.pydev.editor.codecompletion.revisited.SystemASTManager;
import org.python.pydev.plugin.nature.AbstractPythonNature;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;

public class SystemPythonNature
extends AbstractPythonNature
implements IPythonNature {
    private IInterpreterManager manager;
    private SystemASTManager systemASTManager;
    private IToken[] builtinCompletions;
    private IModule builtinMod;

    public SystemPythonNature(IInterpreterManager manager) {
        this.manager = manager;
    }

    public String getVersion() throws CoreException {
        if (this.manager.isPython()) {
            return "python 2.5";
        }
        if (this.manager.isJython()) {
            return "jython 2.1";
        }
        throw new RuntimeException("Not python nor jython?");
    }

    public String getDefaultVersion() {
        try {
            return this.getVersion();
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public void setVersion(String version) throws CoreException {
        throw new RuntimeException("Not Implemented: the system nature is read-only.");
    }

    public boolean isJython() throws CoreException {
        return this.manager.isJython();
    }

    public boolean isPython() throws CoreException {
        return this.manager.isPython();
    }

    public int getRelatedId() throws CoreException {
        return PythonNature.getRelatedId(this);
    }

    public File getCompletionsCacheDir() {
        throw new RuntimeException("Not Implemented");
    }

    public void saveAstManager() {
        throw new RuntimeException("Not Implemented: system nature is only transient.");
    }

    public IPythonPathNature getPythonPathNature() {
        throw new RuntimeException("Not Implemented");
    }

    public String resolveModule(String file) {
        InterpreterInfo info = (InterpreterInfo)this.manager.getDefaultInterpreterInfo((IProgressMonitor)new NullProgressMonitor());
        if (info == null) {
            return null;
        }
        return info.getModulesManager().resolveModule(file);
    }

    public ICodeCompletionASTManager getAstManager() {
        if (this.systemASTManager == null) {
            this.systemASTManager = new SystemASTManager(this.manager, this);
        }
        return this.systemASTManager;
    }

    public void configure() throws CoreException {
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return null;
    }

    public void setProject(IProject project) {
    }

    public void rebuildPath() {
        throw new RuntimeException("Not Implemented");
    }

    public void rebuildPath(String defaultSelectedInterpreter, IProgressMonitor monitor) {
        throw new RuntimeException("Not Implemented");
    }

    public IInterpreterManager getRelatedInterpreterManager() {
        return this.manager;
    }

    public IToken[] getBuiltinCompletions() {
        return this.builtinCompletions;
    }

    public void setBuiltinCompletions(IToken[] toks) {
        this.builtinCompletions = toks;
    }

    public IModule getBuiltinMod() {
        return this.builtinMod;
    }

    public void setBuiltinMod(IModule mod) {
        this.builtinMod = mod;
    }

    public int getGrammarVersion() {
        IInterpreterInfo info = this.manager.getDefaultInterpreterInfo((IProgressMonitor)new NullProgressMonitor());
        if (info != null) {
            return info.getGrammarVersion();
        }
        return 11;
    }
}

