/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin.nature;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.IPythonNatureListener;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonNatureListenersManager {
    private static List<WeakReference<IPythonNatureListener>> pythonNatureListeners = new ArrayList<WeakReference<IPythonNatureListener>>();

    public static void addPythonNatureListener(IPythonNatureListener listener) {
        pythonNatureListeners.add(new WeakReference<IPythonNatureListener>(listener));
    }

    public static void removePythonNatureListener(IPythonNatureListener provider) {
        Iterator<WeakReference<IPythonNatureListener>> it = pythonNatureListeners.iterator();
        while (it.hasNext()) {
            WeakReference<IPythonNatureListener> ref = it.next();
            if (ref.get() != provider) continue;
            it.remove();
        }
    }

    public static void notifyPythonPathRebuilt(IProject project, List<String> projectPythonpath) {
        Iterator<WeakReference<IPythonNatureListener>> it = pythonNatureListeners.iterator();
        while (it.hasNext()) {
            WeakReference<IPythonNatureListener> ref = it.next();
            try {
                IPythonNatureListener listener = (IPythonNatureListener)ref.get();
                if (listener == null) {
                    it.remove();
                    continue;
                }
                listener.notifyPythonPathRebuilt(project, projectPythonpath);
            }
            catch (Throwable e) {
                PydevPlugin.log(e);
            }
        }
    }
}

