/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.python.pydev.navigator.elements.IWrappedResource;
import org.python.pydev.navigator.elements.PythonFolder;
import org.python.pydev.navigator.elements.PythonNode;
import org.python.pydev.navigator.elements.PythonProjectSourceFolder;
import org.python.pydev.navigator.elements.PythonSourceFolder;
import org.python.pydev.plugin.PydevPlugin;

public class PythonLabelProvider
implements ILabelProvider {
    private WorkbenchLabelProvider provider = new WorkbenchLabelProvider();

    public Image getImage(Object element) {
        if (element instanceof PythonProjectSourceFolder) {
            return PydevPlugin.getImageCache().get("icons/project_source_folder.gif");
        }
        if (element instanceof PythonSourceFolder) {
            return PydevPlugin.getImageCache().get("icons/packagefolder_obj.gif");
        }
        if (element instanceof PythonFolder) {
            return PydevPlugin.getImageCache().get("icons/package_obj.gif");
        }
        if (element instanceof PythonNode) {
            PythonNode node = (PythonNode)element;
            return node.entry.getImage();
        }
        if (element instanceof IWrappedResource) {
            IWrappedResource resource = (IWrappedResource)element;
            return this.provider.getImage(resource.getActualObject());
        }
        return this.provider.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof PythonNode) {
            PythonNode node = (PythonNode)element;
            return node.entry.toString();
        }
        if (element instanceof PythonSourceFolder) {
            PythonSourceFolder sourceFolder = (PythonSourceFolder)element;
            return this.provider.getText((Object)sourceFolder.container);
        }
        if (element instanceof IWrappedResource) {
            IWrappedResource resource = (IWrappedResource)element;
            return this.provider.getText(resource.getActualObject());
        }
        return this.provider.getText(element);
    }

    public void addListener(ILabelProviderListener listener) {
        this.provider.addListener(listener);
    }

    public void dispose() {
        this.provider.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.provider.isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.provider.removeListener(listener);
    }
}

