/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.hover;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.python.pydev.core.IPythonPartitions;
import org.python.pydev.editor.codefolding.PySourceViewer;

public class PyTextHover
implements ITextHover {
    private boolean pythonCommentOrMultiline = false;

    public PyTextHover(ISourceViewer sourceViewer, String contentType) {
        String[] stringArray = IPythonPartitions.types;
        int n = IPythonPartitions.types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (type.equals(contentType)) {
                this.pythonCommentOrMultiline = true;
            }
            ++n2;
        }
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        StringBuffer buf = new StringBuffer();
        if (!this.pythonCommentOrMultiline && textViewer instanceof PySourceViewer) {
            PySourceViewer s = (PySourceViewer)textViewer;
            Iterator iterator = s.getMarkerIteratable().iterator();
            while (iterator.hasNext()) {
                IMarker marker = (IMarker)iterator.next();
                try {
                    Integer cStart = (Integer)marker.getAttribute("charStart");
                    Integer cEnd = (Integer)marker.getAttribute("charEnd");
                    if (cStart == null || cEnd == null) continue;
                    int offset = hoverRegion.getOffset();
                    if (cStart > offset || cEnd < offset) continue;
                    if (buf.length() > 0) {
                        buf.append("\n");
                    }
                    buf.append(marker.getAttribute("message"));
                }
                catch (CoreException coreException) {}
            }
        }
        return buf.toString();
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return new Region(offset, 0);
    }
}

