/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.correctionassist.heuristics;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.bundle.ImageCache;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.codecompletion.AbstractTemplateCodeCompletion;
import org.python.pydev.editor.codecompletion.CompletionRequest;
import org.python.pydev.editor.correctionassist.heuristics.IAssistProps;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssistSurroundWith
extends AbstractTemplateCodeCompletion
implements IAssistProps {
    public static final String[] SURROUND_WITH_COMPLETIONS = new String[]{"%stry:%s%s%s%sexcept${cursor}:%s%s%sraise", "try..except", "%stry:%s%s%s%sexcept (${RuntimeError}, ), e:%s%s%s${raise}${cursor}", "try..except (RuntimeError, ), e", "%stry:%s%s%s%sfinally:%s%s%s${pass}", "try..finally", "%sif ${True}:%s%s%s%selse:%s%s%s${pass}", "if..else", "%swhile ${True}:%s%s%s%s%s", "while", "%sfor ${item} in ${collection}:%s%s%s%s%s${cursor}", "for", "%sif ${True}:%s%s%s%s%s${cursor}", "if", "%swith ${var}:%s%s%s%s%s${cursor}", "with"};

    @Override
    public List<ICompletionProposal> getProps(PySelection ps, ImageCache imageCache, File f, IPythonNature nature, PyEdit edit, int offset) throws BadLocationException {
        ArrayList<ICompletionProposal> l = new ArrayList<ICompletionProposal>();
        String indentation = PyAction.getStaticIndentationString(edit);
        ps.selectCompleteLine();
        int start = ps.getStartLine().getOffset();
        int end = ps.getEndLine().getOffset() + ps.getEndLine().getLength();
        String delimiter = PyAction.getDelimiter(ps.getDoc());
        int firstCharPosition = PySelection.getFirstCharRelativePosition((IDocument)ps.getDoc(), (int)start);
        StringBuffer startIndentBuffer = new StringBuffer();
        int i = 0;
        while (i < firstCharPosition) {
            startIndentBuffer.append(" ");
            ++i;
        }
        final String startIndent = startIndentBuffer.toString();
        String surroundedCode = ps.getDoc().get(start, end - start);
        surroundedCode = new StringBuffer(String.valueOf(indentation)).append(surroundedCode.replaceAll(delimiter, new StringBuffer(String.valueOf(delimiter)).append(indentation).toString())).toString();
        IRegion region = ps.getRegion();
        TemplateContext context = this.createContext((ITextViewer)edit.getPySourceViewer(), region, ps.getDoc());
        Object[] replace0to3 = new String[]{startIndent, delimiter, surroundedCode, delimiter, startIndent, delimiter, startIndent, indentation, indentation};
        Object[] replace4toEnd = new String[]{startIndent, delimiter, surroundedCode, delimiter, startIndent, indentation};
        int iComp = 0;
        int iRep = 0;
        while (iComp < SURROUND_WITH_COMPLETIONS.length) {
            String comp = SURROUND_WITH_COMPLETIONS[iComp];
            comp = iRep < 4 ? StringUtils.format((String)comp, (Object[])replace0to3) : StringUtils.format((String)comp, (Object[])replace4toEnd);
            Template t = new Template("Surround with", SURROUND_WITH_COMPLETIONS[iComp + 1], "", comp, false);
            l.add((ICompletionProposal)new TemplateProposal(t, context, region, imageCache.get("icons/template.gif"), 5){

                public String getAdditionalProposalInfo() {
                    return String.valueOf(startIndent) + super.getAdditionalProposalInfo();
                }
            });
            iComp += 2;
            ++iRep;
        }
        return l;
    }

    @Override
    public boolean isValid(PySelection ps, String sel, PyEdit edit, int offset) {
        return ps.getTextSelection().getLength() > 0;
    }

    @Override
    public List<Object> getCodeCompletionProposals(ITextViewer viewer, CompletionRequest request) throws CoreException, BadLocationException {
        throw new RuntimeException("Not implemented: completions should be gotten from the IAssistProps interface.");
    }
}

