/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codefolding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.plugin.OverlayPreferenceStore;
import org.python.pydev.plugin.PydevPlugin;

public class PyDevCodeFoldingPrefPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String USE_CODE_FOLDING = "USE_CODE_FOLDING";
    public static final boolean DEFAULT_USE_CODE_FOLDING = true;
    public static final boolean DEFAULT_FOLD_IF = false;
    public static final String FOLD_IF = "FOLD_IF";
    public static final boolean DEFAULT_FOLD_WHILE = false;
    public static final String FOLD_WHILE = "FOLD_WHILE";
    public static final boolean DEFAULT_FOLD_IMPORTS = true;
    public static final String FOLD_IMPORTS = "FOLD_IMPORTS";
    public static final boolean DEFAULT_FOLD_COMMENTS = true;
    public static final String FOLD_COMMENTS = "FOLD_COMMENTS";
    public static final boolean DEFAULT_FOLD_STRINGS = true;
    public static final String FOLD_STRINGS = "FOLD_STRINGS";
    public static final boolean DEFAULT_FOLD_CLASSDEF = true;
    public static final String FOLD_CLASSDEF = "FOLD_CLASSDEF";
    public static final boolean DEFAULT_FOLD_FUNCTIONDEF = true;
    public static final String FOLD_FUNCTIONDEF = "FOLD_FUNCTIONDEF";
    public static final boolean DEFAULT_FOLD_FOR = false;
    public static final String FOLD_FOR = "FOLD_FOR";
    public static final boolean DEFAULT_FOLD_TRY = false;
    public static final String FOLD_TRY = "FOLD_TRY";
    public static final boolean DEFAULT_FOLD_WITH = false;
    public static final String FOLD_WITH = "FOLD_WITH";
    protected OverlayPreferenceStore fOverlayStore;
    protected Map<Button, String> fCheckBoxes = new HashMap<Button, String>();
    protected SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            PyDevCodeFoldingPrefPage.this.fOverlayStore.setValue(PyDevCodeFoldingPrefPage.this.fCheckBoxes.get(button), button.getSelection());
        }
    };
    protected List<SelectionListener> fMasterSlaveListeners = new ArrayList<SelectionListener>();

    public PyDevCodeFoldingPrefPage() {
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
        this.setDescription("PyDev Code Folding Options");
        this.fOverlayStore = this.createOverlayStore();
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        Control control = this.createPreferencePage(parent);
        this.initializeFields();
        return control;
    }

    protected Control createPreferencePage(Composite parent) {
        Composite top = new Composite(parent, 16384);
        top.setLayoutData((Object)new GridData(768));
        top.setLayout((Layout)new GridLayout());
        Button master = this.addCheckBox(top, "Use Code Folding?  -  Will apply to new editors", USE_CODE_FOLDING, 0);
        Label listLabel = new Label(top, 0);
        listLabel.setText("\nSelect the elements you would like PyDev \nto fold on.\n\nWill be applied when the document is saved");
        Button slaveImport = this.addCheckBox(top, "Fold Imports?", FOLD_IMPORTS, 0);
        Button slaveClass = this.addCheckBox(top, "Fold Class Definitions?", FOLD_CLASSDEF, 0);
        Button slaveFunc = this.addCheckBox(top, "Fold Function Definitions?", FOLD_FUNCTIONDEF, 0);
        Button slaveString = this.addCheckBox(top, "Fold Multi-line Strings?", FOLD_STRINGS, 0);
        Button slaveComment = this.addCheckBox(top, "Fold Comments?", FOLD_COMMENTS, 0);
        Button slaveFor = this.addCheckBox(top, "Fold FOR statments?", FOLD_FOR, 0);
        Button slaveIf = this.addCheckBox(top, "Fold IF statments?", FOLD_IF, 0);
        Button slaveTry = this.addCheckBox(top, "Fold TRY statments?", FOLD_TRY, 0);
        Button slaveWhile = this.addCheckBox(top, "Fold WHILE statments?", FOLD_WHILE, 0);
        Button slaveWith = this.addCheckBox(top, "Fold WITH statments?", FOLD_WITH, 0);
        this.createDependency(master, USE_CODE_FOLDING, (Control)slaveClass);
        this.createDependency(master, USE_CODE_FOLDING, (Control)slaveFunc);
        this.createDependency(master, USE_CODE_FOLDING, (Control)slaveImport);
        this.createDependency(master, USE_CODE_FOLDING, (Control)slaveFor);
        this.createDependency(master, USE_CODE_FOLDING, (Control)slaveIf);
        this.createDependency(master, USE_CODE_FOLDING, (Control)slaveTry);
        this.createDependency(master, USE_CODE_FOLDING, (Control)slaveWhile);
        this.createDependency(master, USE_CODE_FOLDING, (Control)slaveWith);
        this.createDependency(master, USE_CODE_FOLDING, (Control)slaveString);
        this.createDependency(master, USE_CODE_FOLDING, (Control)slaveComment);
        return top;
    }

    public boolean performOk() {
        this.fOverlayStore.propagate();
        PydevPlugin.getDefault().savePluginPreferences();
        return true;
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
        super.performDefaults();
    }

    protected void initializeFields() {
        Iterator<Button> e = this.fCheckBoxes.keySet().iterator();
        while (e.hasNext()) {
            Button b = e.next();
            String key = this.fCheckBoxes.get(b);
            b.setSelection(this.fOverlayStore.getBoolean(key));
        }
        Iterator<SelectionListener> iter = this.fMasterSlaveListeners.iterator();
        while (iter.hasNext()) {
            SelectionListener listener = iter.next();
            listener.widgetSelected(null);
        }
    }

    protected Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    protected void createDependency(final Button master, String masterKey, final Control slave) {
        PyDevCodeFoldingPrefPage.indent(slave);
        boolean masterState = this.fOverlayStore.getBoolean(masterKey);
        slave.setEnabled(masterState);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                slave.setEnabled(master.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        master.addSelectionListener(listener);
        this.fMasterSlaveListeners.add(listener);
    }

    protected static void indent(Control control) {
        GridData gridData = new GridData();
        gridData.horizontalIndent = 20;
        control.setLayoutData((Object)gridData);
    }

    protected OverlayPreferenceStore createOverlayStore() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, USE_CODE_FOLDING));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, FOLD_CLASSDEF));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, FOLD_COMMENTS));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, FOLD_FOR));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, FOLD_FUNCTIONDEF));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, FOLD_IF));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, FOLD_IMPORTS));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, FOLD_STRINGS));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, FOLD_TRY));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, FOLD_WHILE));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, FOLD_WITH));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return new OverlayPreferenceStore(this.getPreferenceStore(), keys);
    }
}

