/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited.javaintegration;

import com.rc.retroweaver.runtime.Autobox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.swt.widgets.Display;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.Tuple;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.codecompletion.revisited.javaintegration.JavaDefinition;
import org.python.pydev.editor.codecompletion.revisited.javaintegration.JavaElementToken;
import org.python.pydev.editor.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.editor.codecompletion.revisited.modules.CompiledToken;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.plugin.PydevPlugin;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaClassModule
extends AbstractModule {
    public static final boolean DEBUG_JAVA_COMPLETIONS = false;
    protected static final CompiledToken[] EMPTY_ITOKEN = new CompiledToken[0];
    protected CompiledToken[] tokens;
    public static HashMap<String, String> replacementMap = new HashMap();
    private static boolean imageDescriptorCreated;
    private static HashMap<Integer, Integer> typesMapping;

    protected abstract IJavaElement findJavaElement(String var1) throws Exception;

    protected abstract List<Tuple<IJavaElement, CompletionProposal>> getJavaCompletionProposals(String var1, String var2) throws Exception;

    protected abstract List<Tuple<IJavaElement, CompletionProposal>> getJavaCompletionProposals(String var1, int var2, String var3) throws Exception;

    static {
        replacementMap.put("object", "obj");
        replacementMap.put("class", "class_");
        replacementMap.put("[QString", "str");
        replacementMap.put("[I", "int");
        imageDescriptorCreated = false;
        typesMapping = new HashMap();
        typesMapping.put(Autobox.valueOf((int)6), Autobox.valueOf((int)1));
        typesMapping.put(Autobox.valueOf((int)5), Autobox.valueOf((int)1));
        typesMapping.put(Autobox.valueOf((int)11), Autobox.valueOf((int)6));
        typesMapping.put(Autobox.valueOf((int)4), Autobox.valueOf((int)6));
        typesMapping.put(Autobox.valueOf((int)3), Autobox.valueOf((int)6));
    }

    protected AbstractJavaClassModule(String name) {
        super(name);
        this.checkJavaImageDescriptorCreated();
    }

    protected void checkJavaImageDescriptorCreated() {
        if (imageDescriptorCreated) {
            return;
        }
        try {
            JavaPlugin.getImageDescriptorRegistry();
        }
        catch (Throwable throwable) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    try {
                        JavaPlugin.getImageDescriptorRegistry();
                    }
                    catch (Throwable throwable) {}
                }
            });
        }
        imageDescriptorCreated = true;
    }

    protected CompiledToken[] createTokens(String packagePlusactTok) {
        ArrayList<JavaElementToken> lst = new ArrayList<JavaElementToken>();
        try {
            List<Tuple<IJavaElement, CompletionProposal>> elementsFound = this.getJavaCompletionProposals(packagePlusactTok, null);
            for (Tuple<IJavaElement, CompletionProposal> element : elementsFound) {
                IJavaElement javaElement = (IJavaElement)element.o1;
                String args = "";
                if (javaElement instanceof IMethod) {
                    StringBuffer tempArgs = new StringBuffer("()");
                    IMethod method = (IMethod)javaElement;
                    String[] stringArray = method.getParameterTypes();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String replacement;
                        String lastPart;
                        String param = stringArray[n2];
                        if (tempArgs.length() > 2) {
                            tempArgs.insert(1, ", ");
                        }
                        if ((lastPart = FullRepIterable.getLastPart((String)param)).length() > 0 && (lastPart = PyAction.lowerChar(lastPart, 0)).charAt(lastPart.length() - 1) == ';') {
                            lastPart = lastPart.substring(0, lastPart.length() - 1);
                        }
                        if ((replacement = replacementMap.get(lastPart)) != null) {
                            lastPart = replacement;
                        }
                        tempArgs.insert(1, lastPart);
                        ++n2;
                    }
                    args = tempArgs.toString();
                }
                lst.add(new JavaElementToken(javaElement.getElementName(), "", args, this.name, this.getType(javaElement.getElementType()), javaElement, (CompletionProposal)element.o2));
            }
        }
        catch (Exception e) {
            PydevPlugin.log(e);
        }
        return lst.toArray(new CompiledToken[lst.size()]);
    }

    private int getType(int elementType) {
        Integer found = typesMapping.get(Autobox.valueOf((int)elementType));
        if (found != null) {
            return found;
        }
        return 3;
    }

    @Override
    public IToken[] getWildImportedModules() {
        return EMPTY_ITOKEN;
    }

    @Override
    public IToken[] getTokenImportedModules() {
        return EMPTY_ITOKEN;
    }

    @Override
    public IToken[] getGlobalTokens() {
        return this.tokens;
    }

    @Override
    public String getDocString() {
        return "Java class module extension";
    }

    @Override
    public IToken[] getGlobalTokens(ICompletionState state, ICodeCompletionASTManager manager) {
        String act = new StringBuffer(String.valueOf(this.name)).append(".").append(state.getActivationToken()).toString();
        return this.createTokens(act);
    }

    @Override
    public boolean isInDirectGlobalTokens(String tok, ICompletionCache completionCache) {
        if (this.tokens != null) {
            return AbstractJavaClassModule.binaryHasObject(this.tokens, new CompiledToken(tok, "", "", "", 0));
        }
        return false;
    }

    @Override
    public boolean isInGlobalTokens(String tok, IPythonNature nature, ICompletionCache completionCache) {
        if (tok.indexOf(46) == -1) {
            return this.isInDirectGlobalTokens(tok, completionCache);
        }
        System.err.println(new StringBuffer("Still no treated isInDirectGlobalTokens with dotted string:").append(tok).toString());
        return false;
    }

    private static boolean binaryHasObject(CompiledToken[] a, CompiledToken key) {
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            CompiledToken midVal = a[mid];
            int cmp = midVal.getRepresentation().compareTo(key.getRepresentation());
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public Definition[] findDefinition(ICompletionState state, int line, int col, IPythonNature nature) throws Exception {
        String foundAs;
        String[] splitted = FullRepIterable.dotSplit((String)state.getActivationToken());
        StringBuffer modNameBuf = new StringBuffer(this.getName());
        AbstractJavaClassModule validModule = null;
        IModule module = null;
        int i = 0;
        while (i < splitted.length) {
            String s = splitted[i];
            modNameBuf.append(".");
            modNameBuf.append(s);
            module = nature.getAstManager().getModule(modNameBuf.toString(), nature, true, false);
            if (module == null) break;
            validModule = module;
            ++i;
        }
        StringBuffer pathInJavaClass = new StringBuffer();
        if (validModule == null) {
            validModule = this;
            pathInJavaClass = new StringBuffer(state.getActivationToken());
        } else {
            if (!(validModule instanceof AbstractJavaClassModule)) {
                throw new RuntimeException(new StringBuffer("The module found from a java class module was found as another kind: ").append(validModule.getClass()).toString());
            }
            int j = i;
            while (j < splitted.length) {
                if (j != i) {
                    pathInJavaClass.append(".");
                }
                pathInJavaClass.append(splitted[j]);
                ++j;
            }
        }
        AbstractJavaClassModule javaClassModule = validModule;
        IJavaElement elementFound = null;
        if (pathInJavaClass.length() == 0) {
            foundAs = "";
            elementFound = this.findJavaElement(javaClassModule.getName());
        } else {
            foundAs = pathInJavaClass.toString();
            List<Tuple<IJavaElement, CompletionProposal>> javaCompletionProposals = this.getJavaCompletionProposals(javaClassModule.getName(), foundAs);
            if (javaCompletionProposals.size() > 0) {
                elementFound = (IJavaElement)javaCompletionProposals.get((int)0).o1;
            }
        }
        if (elementFound != null) {
            return new Definition[]{new JavaDefinition(foundAs, javaClassModule, elementFound)};
        }
        return new Definition[0];
    }

    protected CompletionProposalCollector createCollector(final String filterCompletionName, final List<Tuple<IJavaElement, CompletionProposal>> ret, ICompilationUnit unit) {
        CompletionProposalCollector collector = new CompletionProposalCollector(unit){

            public IJavaCompletionProposal createJavaCompletionProposal(CompletionProposal proposal) {
                AbstractJavaCompletionProposal prop;
                IJavaElement javaElement;
                IJavaCompletionProposal javaCompletionProposal = super.createJavaCompletionProposal(proposal);
                if (javaCompletionProposal instanceof AbstractJavaCompletionProposal && (javaElement = (prop = (AbstractJavaCompletionProposal)javaCompletionProposal).getJavaElement()) != null) {
                    if (filterCompletionName == null) {
                        ret.add(new Tuple((Object)javaElement, (Object)proposal));
                        return null;
                    }
                    if (javaElement.getElementName().equals(filterCompletionName)) {
                        ret.add(new Tuple((Object)javaElement, (Object)proposal));
                        return null;
                    }
                }
                return null;
            }
        };
        return collector;
    }

    @Override
    public String getPackageFolderName() {
        return this.name;
    }

    @Override
    public /* synthetic */ IDefinition[] findDefinition(ICompletionState iCompletionState, int n, int n2, IPythonNature iPythonNature) throws Exception {
        return this.findDefinition(iCompletionState, n, n2, iPythonNature);
    }
}

