/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited;

import com.rc.retroweaver.runtime.Autobox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.editor.codecompletion.revisited.CompletionCache;
import org.python.pydev.editor.codecompletion.revisited.CompletionStateFactory;
import org.python.pydev.editor.codecompletion.revisited.CompletionStateWrapper;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionState
implements ICompletionState {
    public String activationToken;
    public int line = -1;
    public int col = -1;
    public IPythonNature nature;
    public String qualifier;
    public Memo<String> memory = new Memo();
    public Memo<Definition> definitionMemory = new Memo();
    public Memo<IModule> wildImportMemory = new Memo();
    public Memo<String> importedModsCalled = new Memo();
    public Memo<String> findMemory = new Memo();
    public Memo<String> resolveImportMemory = new Memo();
    public Memo<String> findDefinitionMemory = new Memo();
    public Stack<Memo<IToken>> findResolveImportMemory = new Stack();
    public Memo<String> findModuleCompletionsMemory = new Memo();
    public Memo<String> findSourceFromCompiledMemory = new Memo(1);
    public boolean builtinsGotten = false;
    public boolean localImportsGotten = false;
    public boolean isInCalltip = false;
    public int lookingForInstance = 0;
    private List<IToken> tokenImportedModules;
    private ICompletionCache completionCache;

    public ICompletionState getCopy() {
        return new CompletionStateWrapper(this);
    }

    public ICompletionState getCopyForResolveImportWithActTok(String actTok) {
        CompletionState state = (CompletionState)CompletionStateFactory.getEmptyCompletionState(actTok, this.nature, this.completionCache);
        state.nature = this.nature;
        state.findResolveImportMemory = this.findResolveImportMemory;
        return state;
    }

    public CompletionState(int line2, int col2, String token, IPythonNature nature2, String qualifier) {
        this(line2, col2, token, nature2, qualifier, new CompletionCache());
    }

    public CompletionState(int line2, int col2, String token, IPythonNature nature2, String qualifier, ICompletionCache completionCache) {
        this.line = line2;
        this.col = col2;
        this.activationToken = token;
        this.nature = nature2;
        this.qualifier = qualifier;
        Assert.isNotNull((Object)completionCache);
        this.completionCache = completionCache;
    }

    public CompletionState() {
    }

    public void checkWildImportInMemory(IModule caller, IModule wild) throws CompletionRecursionException {
        if (this.wildImportMemory.isInRecursion(caller, wild)) {
            throw new CompletionRecursionException(new StringBuffer("Possible recursion found -- probably programming error -- (caller: ").append(caller.getName()).append(", import: ").append(wild.getName()).append(" ) - stopping analysis.").toString());
        }
    }

    public void checkDefinitionMemory(IModule module, IDefinition definition) throws CompletionRecursionException {
        if (this.definitionMemory.isInRecursion(module, (Definition)definition)) {
            throw new CompletionRecursionException(new StringBuffer("Possible recursion found -- probably programming error --  (module: ").append(module.getName()).append(", token: ").append(definition).append(") - stopping analysis.").toString());
        }
    }

    public void checkFindMemory(IModule module, String value) throws CompletionRecursionException {
        if (this.findMemory.isInRecursion(module, value)) {
            throw new CompletionRecursionException(new StringBuffer("Possible recursion found -- probably programming error --  (module: ").append(module.getName()).append(", value: ").append(value).append(") - stopping analysis.").toString());
        }
    }

    public void checkResolveImportMemory(IModule module, String value) throws CompletionRecursionException {
        if (this.resolveImportMemory.isInRecursion(module, value)) {
            throw new CompletionRecursionException(new StringBuffer("Possible recursion found -- probably programming error --  (module: ").append(module.getName()).append(", value: ").append(value).append(") - stopping analysis.").toString());
        }
    }

    public void checkFindDefinitionMemory(IModule mod, String tok) throws CompletionRecursionException {
        if (this.findDefinitionMemory.isInRecursion(mod, tok)) {
            throw new CompletionRecursionException(new StringBuffer("Possible recursion found -- probably programming error --  (module: ").append(mod.getName()).append(", value: ").append(tok).append(") - stopping analysis.").toString());
        }
    }

    public void checkMemory(IModule module, String base) throws CompletionRecursionException {
        if (this.memory.isInRecursion(module, base)) {
            throw new CompletionRecursionException(new StringBuffer("Possible recursion found -- probably programming error --  (module: ").append(module.getName()).append(", token: ").append(base).append(") - stopping analysis.").toString());
        }
    }

    public boolean canStillCheckFindSourceFromCompiled(IModule mod, String tok) {
        return !this.findSourceFromCompiledMemory.isInRecursion(mod, tok);
    }

    public void checkFindResolveImportMemory(IToken token) throws CompletionRecursionException {
        for (Memo memo : this.findResolveImportMemory) {
            if (!memo.isInRecursion(null, token)) continue;
            throw new CompletionRecursionException(new StringBuffer("Possible recursion found -- probably programming error --  (token: ").append(token).append(") - stopping analysis.").toString());
        }
    }

    public void popFindResolveImportMemoryCtx() {
        this.findResolveImportMemory.pop();
    }

    public void pushFindResolveImportMemoryCtx() {
        this.findResolveImportMemory.push(new Memo());
    }

    public void checkFindModuleCompletionsMemory(IModule mod, String tok) throws CompletionRecursionException {
        if (this.findModuleCompletionsMemory.isInRecursion(mod, tok)) {
            throw new CompletionRecursionException(new StringBuffer("Possible recursion found -- probably programming error --  (module: ").append(mod.getName()).append(", token: ").append(tok).append(") - stopping analysis.").toString());
        }
    }

    public String getActivationToken() {
        return this.activationToken;
    }

    public IPythonNature getNature() {
        return this.nature;
    }

    public void setActivationToken(String string) {
        this.activationToken = string;
    }

    public void setBuiltinsGotten(boolean b) {
        this.builtinsGotten = b;
    }

    public void setCol(int i) {
        this.col = i;
    }

    public void setLine(int i) {
        this.line = i;
    }

    public void setLocalImportsGotten(boolean b) {
        this.localImportsGotten = b;
    }

    public boolean getLocalImportsGotten() {
        return this.localImportsGotten;
    }

    public int getLine() {
        return this.line;
    }

    public int getCol() {
        return this.col;
    }

    public boolean getBuiltinsGotten() {
        return this.builtinsGotten;
    }

    public void raiseNFindTokensOnImportedModsCalled(IModule mod, String tok) throws CompletionRecursionException {
        if (this.importedModsCalled.isInRecursion(mod, tok)) {
            throw new CompletionRecursionException(new StringBuffer("Possible recursion found (mod: ").append(mod.getName()).append(", tok: ").append(tok).append(" ) - stopping analysis.").toString());
        }
    }

    public boolean getIsInCalltip() {
        return this.isInCalltip;
    }

    public void setLookingFor(int b) {
        this.setLookingFor(b, false);
    }

    public void setLookingFor(int b, boolean force) {
        if (this.lookingForInstance == 0 || force) {
            this.lookingForInstance = b;
        }
    }

    public int getLookingFor() {
        return this.lookingForInstance;
    }

    public ICompletionState getCopyWithActTok(String value) {
        ICompletionState copy = this.getCopy();
        copy.setActivationToken(value);
        return copy;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setIsInCalltip(boolean isInCalltip) {
        this.isInCalltip = isInCalltip;
    }

    public void setTokenImportedModules(List<IToken> tokenImportedModules) {
        if (tokenImportedModules != null && this.tokenImportedModules == null) {
            this.tokenImportedModules = new ArrayList<IToken>(tokenImportedModules);
        }
    }

    public List<IToken> getTokenImportedModules() {
        return this.tokenImportedModules;
    }

    public void add(Object key, Object n) {
        this.completionCache.add(key, n);
    }

    public Object getObj(Object o) {
        return this.completionCache.getObj(o);
    }

    public void remove(Object key) {
        this.completionCache.remove(key);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Memo<E> {
        private int max;
        private static final int MAX_NUMBER_OF_OCURRENCES = 5;
        public Map<IModule, Map<E, Integer>> memo = new HashMap<IModule, Map<E, Integer>>();

        public Memo() {
            this.max = 5;
        }

        public Memo(int max) {
            this.max = max;
        }

        public boolean isInRecursion(IModule caller, E def) {
            Integer numberOfOccurences;
            Map<Object, Object> val;
            boolean occuredMoreThanMax = false;
            if (!this.memo.containsKey(caller)) {
                val = new HashMap();
                this.memo.put(caller, val);
            } else {
                val = this.memo.get(caller);
                if (val.containsKey(def) && (numberOfOccurences = (Integer)val.get(def)) > this.max) {
                    occuredMoreThanMax = true;
                }
            }
            numberOfOccurences = (Integer)val.get(def);
            if (numberOfOccurences == null) {
                val.put(def, Autobox.valueOf((int)1));
            } else {
                val.put(def, Autobox.valueOf((int)(numberOfOccurences + 1)));
            }
            return occuredMoreThanMax;
        }
    }
}

