/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import org.eclipse.core.runtime.Preferences;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.actions.AbstractBlockCommentAction;
import org.python.pydev.plugin.PydevPlugin;

public class PyAddBlockComment
extends AbstractBlockCommentAction {
    private boolean defaultClassNameBehaviour;
    private boolean defaultFunctionNameBehaviour;

    public PyAddBlockComment() {
    }

    PyAddBlockComment(int defaultCols, boolean alignLeft, boolean classNameBehaviour, boolean functionNameBehaviour) {
        super(defaultCols, alignLeft);
        this.defaultClassNameBehaviour = classNameBehaviour;
        this.defaultFunctionNameBehaviour = functionNameBehaviour;
    }

    protected void revealSelEndLine(PySelection ps) {
        this.getTextEditor().selectAndReveal(ps.getEndLine().getOffset(), 0);
    }

    protected boolean getUseClassNameBehaviour() {
        try {
            Preferences prefs = PydevPlugin.getDefault().getPluginPreferences();
            return prefs.getBoolean("MULTI_BLOCK_COMMENT_SHOW_ONLY_CLASS_NAME");
        }
        catch (NullPointerException nullPointerException) {
            return this.defaultClassNameBehaviour;
        }
    }

    protected boolean getUseFunctionNameBehaviour() {
        try {
            Preferences prefs = PydevPlugin.getDefault().getPluginPreferences();
            return prefs.getBoolean("MULTI_BLOCK_COMMENT_SHOW_ONLY_FUNCTION_NAME");
        }
        catch (NullPointerException nullPointerException) {
            return this.defaultFunctionNameBehaviour;
        }
    }

    public int perform(PySelection ps) {
        StringBuffer strbuf = new StringBuffer();
        ps.selectCompleteLine();
        try {
            String endLineDelim = ps.getEndLineDelim();
            int startLineIndex = ps.getStartLineIndex();
            int endLineIndex = ps.getEndLineIndex();
            boolean classBehaviour = false;
            if (startLineIndex == endLineIndex && this.getUseClassNameBehaviour() && ps.isInClassLine()) {
                classBehaviour = true;
            }
            boolean functionBehaviour = false;
            if (startLineIndex == endLineIndex && this.getUseFunctionNameBehaviour() && ps.isInFunctionLine()) {
                functionBehaviour = true;
            }
            if (classBehaviour || functionBehaviour) {
                int tokLen;
                int classIndex;
                String line = ps.getLine(startLineIndex);
                if (classBehaviour) {
                    classIndex = line.indexOf("class ");
                    tokLen = 6;
                } else {
                    classIndex = line.indexOf("def ");
                    tokLen = 4;
                }
                String fullCommentLine = this.getFullCommentLine(classIndex);
                String spacesBefore = classIndex > 0 ? line.substring(0, classIndex) : "";
                strbuf.append(String.valueOf(spacesBefore) + "#" + fullCommentLine + endLineDelim);
                String initialLine = line;
                line = line.substring(classIndex + tokLen);
                StringBuffer className = new StringBuffer();
                int i = 0;
                while (i < line.length()) {
                    char cN = line.charAt(i);
                    if (!Character.isJavaIdentifierPart(cN)) break;
                    className.append(cN);
                    ++i;
                }
                strbuf.append(spacesBefore);
                strbuf.append("# ");
                strbuf.append(className);
                strbuf.append(endLineDelim);
                strbuf.append(spacesBefore);
                strbuf.append("#" + fullCommentLine);
                strbuf.append(endLineDelim);
                strbuf.append(initialLine);
            } else {
                String fullCommentLine = this.getFullCommentLine(0);
                strbuf.append("#" + fullCommentLine + endLineDelim);
                int i = startLineIndex;
                while (i <= endLineIndex) {
                    strbuf.append("#");
                    String line = ps.getLine(i);
                    if (!line.startsWith("\t") && !line.startsWith(" ")) {
                        strbuf.append(" ");
                    }
                    strbuf.append(line);
                    strbuf.append(endLineDelim);
                    ++i;
                }
                strbuf.append("#" + fullCommentLine);
            }
            int startOffset = ps.getStartLine().getOffset();
            String str = strbuf.toString();
            ps.getDoc().replace(startOffset, ps.getSelLength(), str);
            return startOffset + str.length();
        }
        catch (Exception e) {
            PyAddBlockComment.beep(e);
            return -1;
        }
    }

    protected String getPreferencesNameForChar() {
        return "MULTI_BLOCK_COMMENT_CHAR";
    }

    protected String getFullCommentLine(int subtract) {
        Tuple<Integer, Character> colsAndChar = this.getColsAndChar();
        int cols = (Integer)colsAndChar.o1 - subtract;
        char c = ((Character)colsAndChar.o2).charValue();
        StringBuffer buffer = new StringBuffer(cols);
        int i = 0;
        while (i < cols - 1) {
            buffer.append(c);
            ++i;
        }
        return buffer.toString();
    }
}

