/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder;

import com.rc.retroweaver.runtime.Autobox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.builder.PyDevBuilder;
import org.python.pydev.builder.PyDevBuilderVisitor;
import org.python.pydev.builder.PydevInternalResourceDeltaVisitor;
import org.python.pydev.core.REF;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.nature.PythonNature;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PydevGrouperVisitor
extends PydevInternalResourceDeltaVisitor {
    private List<PyDevBuilderVisitor> visitors;

    public PydevGrouperVisitor(List<PyDevBuilderVisitor> _visitors, IProgressMonitor monitor, int totalResources) {
        super(monitor, totalResources);
        this.visitors = new ArrayList<PyDevBuilderVisitor>(_visitors);
    }

    private void visitWith(String name, boolean isAddOrChange, IResource resource, IDocument document, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        PythonNature nature = PythonNature.getPythonNature(resource);
        if (nature == null) {
            return;
        }
        if (!nature.startRequests()) {
            return;
        }
        try {
            if (!nature.isResourceInPythonpath(resource)) {
                return;
            }
            HashMap<String, Boolean> memo = new HashMap<String, Boolean>();
            memo.put("IS_FULL_BUILD", Autobox.valueOf((boolean)false));
            for (PyDevBuilderVisitor visitor : this.visitors) {
                if (visitor.maxResourcesToVisit() != -1 && visitor.maxResourcesToVisit() < this.totalResources) continue;
                visitor.memo = memo;
                try {
                    PyDevBuilder.communicateProgress(monitor, this.totalResources, this.currentResourcesVisited, resource, visitor);
                    REF.invoke((Object)visitor, (String)name, (Object[])new Object[]{resource, document, monitor});
                    if (!isAddOrChange || !visitor.shouldVisitInitDependency() || !this.isInitFile(resource)) continue;
                    IResource[] initDependents = this.getInitDependents(resource);
                    int i = 0;
                    while (i < initDependents.length) {
                        IDocument doc = REF.getDocFromResource((IResource)initDependents[i]);
                        REF.invoke((Object)visitor, (String)name, (Object[])new Object[]{initDependents[i], doc, monitor});
                        ++i;
                    }
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
        }
        finally {
            nature.endRequests();
        }
    }

    @Override
    public void visitAddedResource(IResource resource, IDocument document, IProgressMonitor monitor) {
        this.visitWith("visitAddedResource", true, resource, document, monitor);
    }

    @Override
    public void visitChangedResource(IResource resource, IDocument document, IProgressMonitor monitor) {
        this.visitWith("visitChangedResource", true, resource, document, monitor);
    }

    @Override
    public void visitRemovedResource(IResource resource, IDocument document, IProgressMonitor monitor) {
        this.visitWith("visitRemovedResource", false, resource, document, monitor);
    }
}

