/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.visitors;

import com.python.pydev.analysis.scopeanalysis.AbstractScopeAnalyzerVisitor;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.Tuple3;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.codecompletion.revisited.AbstractASTManager;
import org.python.pydev.editor.codecompletion.revisited.CompletionStateFactory;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;

public final class ImportChecker {
    private IPythonNature nature;
    private String moduleName;
    private AbstractScopeAnalyzerVisitor visitor;

    public ImportChecker(AbstractScopeAnalyzerVisitor visitor, IPythonNature nature, String moduleName) {
        this.nature = nature;
        this.moduleName = moduleName;
        this.visitor = visitor;
    }

    public ImportInfo visitImportToken(IToken token, boolean reportUndefinedImports, ICompletionCache completionCache) {
        return ImportChecker.visitImportToken(reportUndefinedImports, token, this.moduleName, this.nature, this.visitor, completionCache);
    }

    public static ImportInfo visitImportToken(boolean reportUndefinedImports, IToken token, String moduleName, IPythonNature nature, AbstractScopeAnalyzerVisitor visitor, ICompletionCache completionCache) {
        boolean wasResolved = false;
        Tuple3 modTok = null;
        String checkForToken = "";
        if (token instanceof SourceToken) {
            ICodeCompletionASTManager astManager = nature.getAstManager();
            ICompletionState state = CompletionStateFactory.getEmptyCompletionState((String)token.getRepresentation(), (IPythonNature)nature, (ICompletionCache)completionCache);
            try {
                modTok = astManager.findOnImportedMods(new IToken[]{token}, state, moduleName);
            }
            catch (CompletionRecursionException completionRecursionException) {
                modTok = null;
            }
            if (modTok != null && modTok.o1 != null) {
                checkForToken = (String)modTok.o2;
                if (((String)modTok.o2).length() == 0) {
                    wasResolved = true;
                } else {
                    try {
                        checkForToken = AbstractASTManager.getTokToSearchInOtherModule((Tuple3)modTok);
                        if (astManager.getRepInModule((IModule)modTok.o1, checkForToken, nature) != null) {
                            wasResolved = true;
                        }
                    }
                    catch (CompletionRecursionException completionRecursionException) {}
                }
            }
            if (!wasResolved && reportUndefinedImports) {
                visitor.onAddUnresolvedImport(token);
            }
        }
        if (modTok != null) {
            return new ImportInfo((IModule)modTok.o1, checkForToken, (IToken)modTok.o3, wasResolved);
        }
        return new ImportInfo(null, null, null, wasResolved);
    }

    public static class ImportInfo {
        public IModule mod;
        public IToken token;
        public String rep;
        public boolean wasResolved;

        public ImportInfo(IModule mod, String rep, IToken token, boolean wasResolved) {
            this.mod = mod;
            this.rep = rep;
            this.token = token;
            this.wasResolved = wasResolved;
        }

        public String toString() {
            FastStringBuffer buffer = new FastStringBuffer();
            buffer.append("ImportInfo(");
            buffer.append(" Resolved:");
            buffer.append(this.wasResolved);
            if (this.wasResolved) {
                buffer.append(" Rep:");
                buffer.append(this.rep);
                buffer.append(" Mod:");
                buffer.append(this.mod.getName());
            }
            buffer.append(")");
            return buffer.toString();
        }

        public Definition getModuleDefinitionFromImportInfo(IPythonNature nature, ICompletionCache completionCache) {
            try {
                IDefinition[] definitions;
                IDefinition[] iDefinitionArray = definitions = this.mod.findDefinition(CompletionStateFactory.getEmptyCompletionState((String)this.rep, (IPythonNature)nature, (ICompletionCache)completionCache), -1, -1, nature);
                int n = definitions.length;
                int n2 = 0;
                while (n2 < n) {
                    IDefinition definition = iDefinitionArray[n2];
                    if (definition instanceof Definition) {
                        Definition d = (Definition)definition;
                        if (d.module != null && d.value.length() == 0 && d.ast == null) {
                            return d;
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        }
    }
}

