/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.indexview;

import com.python.pydev.analysis.additionalinfo.AbstractAdditionalDependencyInfo;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalInterpreterInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalProjectInterpreterInfo;
import com.python.pydev.analysis.indexview.ElementWithChildren;
import com.python.pydev.analysis.indexview.ITreeElement;
import com.python.pydev.analysis.indexview.LeafElement;
import com.rc.retroweaver.runtime.Autobox;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.editor.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.utils.PyFileListing;

public class NatureGroup
extends ElementWithChildren {
    private PythonNature nature;

    public NatureGroup(ITreeElement parent, PythonNature nature) {
        super(parent);
        this.nature = nature;
    }

    public boolean hasChildren() {
        return true;
    }

    protected void calculateChildren() throws MisconfigurationException {
        ModulesKey key;
        String s;
        Object modName;
        ICodeCompletionASTManager astManager = this.nature.getAstManager();
        if (astManager == null) {
            this.addLeaf("AST manager == null (should happen only in the plugin initialization) -- skipping other checks.");
            return;
        }
        IModulesManager projectModulesManager = astManager.getModulesManager();
        if (projectModulesManager == null) {
            this.addLeaf("Modules manager == null (should happen only in the plugin initialization) -- skipping other checks.");
            return;
        }
        PythonPathHelper pythonPathHelper = (PythonPathHelper)projectModulesManager.getPythonPathHelper();
        if (pythonPathHelper == null) {
            this.addLeaf("PythonPathHelper == null (should happen only in the plugin initialization) -- skipping other checks.");
            return;
        }
        List pythonpath = pythonPathHelper.getPythonpath();
        Iterator iterator = pythonpath.iterator();
        while (iterator.hasNext()) {
            String s2 = (String)iterator.next();
            this.addLeaf("PYTHONPATH: " + s2);
        }
        HashSet<ModulesKey> expectedModuleNames = new HashSet<ModulesKey>();
        Iterator iterator2 = pythonpath.iterator();
        while (iterator2.hasNext()) {
            String string = (String)iterator2.next();
            File file = new File(string);
            if (file.isDirectory()) {
                Collection modulesBelow = pythonPathHelper.getModulesBelow(file, (IProgressMonitor)new NullProgressMonitor()).getFoundPyFileInfos();
                Iterator iterator3 = modulesBelow.iterator();
                while (iterator3.hasNext()) {
                    PyFileListing.PyFileInfo fileInfo = (PyFileListing.PyFileInfo)iterator3.next();
                    File moduleFile = fileInfo.getFile();
                    modName = pythonPathHelper.resolveModule(REF.getFileAbsolutePath((File)moduleFile), true);
                    if (modName != null) {
                        expectedModuleNames.add(new ModulesKey((String)modName, moduleFile));
                        continue;
                    }
                    if (!PythonPathHelper.isValidModuleLastPart((String)StringUtils.stripExtension((String)moduleFile.getName()))) continue;
                    this.addLeaf(StringUtils.format((String)"Unable to resolve module: %s (gotten null module name)", (Object[])new Object[]{moduleFile}));
                }
                continue;
            }
            if (!file.exists()) {
                this.addLeaf(StringUtils.format((String)"File %s is referenced in the pythonpath but does not exist.", (Object[])new Object[]{file}));
                continue;
            }
            this.addLeaf(StringUtils.format((String)"File %s not handled (TODO: Fix zip files support in the viewer).", (Object[])new Object[]{file}));
        }
        IntegrityInfo info = new IntegrityInfo();
        ModulesKey[] onlyDirectModules = projectModulesManager.getOnlyDirectModules();
        TreeSet<ModulesKey> inModulesManager = new TreeSet<ModulesKey>(Arrays.asList(onlyDirectModules));
        TreeSet<String> allAdditionalInfoModuleNames = new TreeSet<String>();
        Tuple<List<AbstractAdditionalInterpreterInfo>, List<IPythonNature>> additionalInfoAndNature = AdditionalProjectInterpreterInfo.getAdditionalInfoAndNature((IPythonNature)this.nature, false, false, false);
        if (((List)additionalInfoAndNature.o1).size() == 0) {
            this.addChild(new LeafElement(this, "No additional infos found (1 expected) -- skipping other checks."));
            return;
        }
        if (((List)additionalInfoAndNature.o1).size() > 1) {
            this.addChild(new LeafElement(this, StringUtils.format((String)"%s additional infos found (only 1 expected) -- continuing checks but analysis may be wrong.", (Object[])new Object[]{Autobox.valueOf((int)((List)additionalInfoAndNature.o1).size())})));
        }
        AbstractAdditionalInterpreterInfo additionalProjectInfo = (AbstractAdditionalInterpreterInfo)((List)additionalInfoAndNature.o1).get(0);
        allAdditionalInfoModuleNames.addAll(additionalProjectInfo.getAllModulesWithTokens());
        modName = inModulesManager.iterator();
        while (modName.hasNext()) {
            ModulesKey key2 = (ModulesKey)modName.next();
            if (expectedModuleNames.contains(key2)) continue;
            info.modulesNotInDisk.add(key2);
            this.addChild(new LeafElement(this, StringUtils.format((String)"%s exists in memory but not in the disk.", (Object[])new Object[]{key2})));
        }
        ModulesKey tempKey = new ModulesKey(null, null);
        Iterator<Object> iterator4 = allAdditionalInfoModuleNames.iterator();
        while (iterator4.hasNext()) {
            tempKey.name = s = (String)iterator4.next();
            if (expectedModuleNames.contains(tempKey)) continue;
            info.additionalModulesNotInDisk.add(s);
            this.addChild(new LeafElement(this, StringUtils.format((String)"%s exists in the additional info but not in the disk.", (Object[])new Object[]{s})));
        }
        iterator4 = expectedModuleNames.iterator();
        while (iterator4.hasNext()) {
            key = (ModulesKey)iterator4.next();
            boolean isInModulesManager = inModulesManager.contains(key);
            if (!isInModulesManager) {
                info.modulesNotInMemory.add(key);
                this.addChild(new LeafElement(this, StringUtils.format((String)"%s exists in the disk but not in memory.", (Object[])new Object[]{key})));
            }
            if (allAdditionalInfoModuleNames.contains(key.name)) continue;
            try {
                AbstractModule mod = AbstractModule.createModule((String)key.name, (File)key.file, (IPythonNature)info.nature, (int)-1);
                if (!(mod instanceof SourceModule)) continue;
                SourceModule module = (SourceModule)mod;
                if (module == null || module.getAst() == null) {
                    this.addChild(new LeafElement(this, StringUtils.format((String)"Warning: cannot parse: %s - %s (so, it's ok not having additional info on it)", (Object[])new Object[]{key.name, key.file})));
                    continue;
                }
                try {
                    Iterator innerEntriesForAST = (Iterator)AbstractAdditionalDependencyInfo.getInnerEntriesForAST((SimpleNode)module.getAst()).o2;
                    if (!innerEntriesForAST.hasNext()) continue;
                    info.moduleNotInAdditionalInfo.add(module);
                    this.addChild(new LeafElement(this, StringUtils.format((String)"The additional info index of the module: %s is not updated.", (Object[])new Object[]{key.name})));
                }
                catch (Exception e) {
                    this.addChild(new LeafElement(this, StringUtils.format((String)"Unexpected error happened on: %s - %s: %s", (Object[])new Object[]{key.name, key.file, e.getMessage()})));
                }
            }
            catch (IOException iOException) {
                this.addChild(new LeafElement(this, StringUtils.format((String)"Warning: cannot parse: %s - %s (so, it's ok not having additional info on it)", (Object[])new Object[]{key.name, key.file})));
            }
        }
        if (info.modulesNotInDisk.size() > 0) {
            iterator4 = info.modulesNotInDisk.iterator();
            while (iterator4.hasNext()) {
                ModulesKey m = (ModulesKey)iterator4.next();
                this.addChild(new LeafElement(this, StringUtils.format((String)"FIX: Removing from modules manager: %s", (Object[])new Object[]{m})));
            }
            projectModulesManager.removeModules(info.modulesNotInDisk);
        }
        iterator4 = info.modulesNotInMemory.iterator();
        while (iterator4.hasNext()) {
            key = (ModulesKey)iterator4.next();
            this.addChild(new LeafElement(this, "FIX: Adding to modules manager: " + key));
            projectModulesManager.addModule(key);
        }
        iterator4 = info.additionalModulesNotInDisk.iterator();
        while (iterator4.hasNext()) {
            s = (String)iterator4.next();
            this.addChild(new LeafElement(this, StringUtils.format((String)"FIX: Removing from additional info: %s", (Object[])new Object[]{s})));
            additionalProjectInfo.removeInfoFromModule(s, true);
        }
        iterator4 = info.moduleNotInAdditionalInfo.iterator();
        while (iterator4.hasNext()) {
            SourceModule mod = (SourceModule)iterator4.next();
            this.addChild(new LeafElement(this, StringUtils.format((String)"FIX: Adding to additional info: %s", (Object[])new Object[]{mod.getName()})));
            additionalProjectInfo.addSourceModuleInfo(mod, info.nature, true);
        }
    }

    private void addLeaf(String msg) {
        this.addChild(new LeafElement(this, msg));
    }

    public String toString() {
        IProject project = this.nature.getProject();
        if (project != null) {
            return project.getName();
        }
        return "Project not set";
    }

    public static class IntegrityInfo {
        public IPythonNature nature;
        public List<ModulesKey> modulesNotInDisk = new ArrayList<ModulesKey>();
        public List<ModulesKey> modulesNotInMemory = new ArrayList<ModulesKey>();
        public List<SourceModule> moduleNotInAdditionalInfo = new ArrayList<SourceModule>();
        public List<String> additionalModulesNotInDisk = new ArrayList<String>();
    }
}

