/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.actions;

import com.python.pydev.analysis.AnalysisPlugin;
import com.python.pydev.analysis.actions.AdditionalInfoAndIInfo;
import com.python.pydev.analysis.actions.GlobalsDialogFactory;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalDependencyInfo;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalInterpreterInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalProjectInterpreterInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalSystemInterpreterInfo;
import com.python.pydev.analysis.additionalinfo.IInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.actions.PyOpenAction;
import org.python.pydev.editor.codecompletion.revisited.CompletionCache;
import org.python.pydev.editor.model.ItemPointer;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.plugin.nature.SystemPythonNature;
import org.python.pydev.ui.interpreters.ChooseInterpreterManager;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyGlobalsBrowser
extends PyAction {
    public void run(IAction action) {
        IPythonNature pythonNature;
        try {
            pythonNature = this.getPyEdit().getPythonNature();
        }
        catch (MisconfigurationException e1) {
            PyGlobalsBrowser.handle(e1);
            return;
        }
        PySelection ps = new PySelection((ITextEditor)this.getPyEdit());
        String selectedText = ps.getSelectedText();
        if (selectedText == null || selectedText.length() == 0) {
            try {
                selectedText = (String)ps.getCurrToken().o1;
            }
            catch (BadLocationException badLocationException) {}
        }
        if (pythonNature != null) {
            IInterpreterManager manager = pythonNature.getRelatedInterpreterManager();
            PyGlobalsBrowser.getFromManagerAndRelatedNatures(selectedText, manager);
        } else {
            this.getFromSystemManager(selectedText);
        }
    }

    private void getFromSystemManager(String selectedText) {
        Tuple infoForFile = PydevPlugin.getInfoForFile((File)this.getPyEdit().getEditorFile());
        if (infoForFile != null) {
            IPythonNature systemPythonNature = (IPythonNature)infoForFile.o1;
            if (systemPythonNature == null) {
                PyGlobalsBrowser.getFromWorkspace(selectedText);
                return;
            }
            IInterpreterManager manager = ((SystemPythonNature)infoForFile.o1).getRelatedInterpreterManager();
            PyGlobalsBrowser.getFromManagerAndRelatedNatures(selectedText, manager);
        } else {
            PyGlobalsBrowser.getFromWorkspace(selectedText);
        }
    }

    public static void getFromWorkspace(String selectedText) {
        IInterpreterManager useManager = ChooseInterpreterManager.chooseInterpreterManager();
        if (useManager == null) {
            return;
        }
        PyGlobalsBrowser.getFromManagerAndRelatedNatures(selectedText, useManager);
    }

    private static void handle(MisconfigurationException e) {
        Log.log((Throwable)e);
    }

    private static void getFromManagerAndRelatedNatures(String selectedText, IInterpreterManager useManager) {
        AbstractAdditionalInterpreterInfo additionalSystemInfo;
        try {
            additionalSystemInfo = AdditionalSystemInterpreterInfo.getAdditionalSystemInfo(useManager, useManager.getDefaultInterpreter());
        }
        catch (MisconfigurationException e) {
            MessageDialog.openError((Shell)PyGlobalsBrowser.getShell(), (String)"Error", (String)"Additional info is not available (default interpreter not configured).");
            PyGlobalsBrowser.handle(e);
            return;
        }
        ArrayList<AbstractAdditionalInterpreterInfo> additionalInfo = new ArrayList<AbstractAdditionalInterpreterInfo>();
        additionalInfo.add(additionalSystemInfo);
        List natures = PythonNature.getPythonNaturesRelatedTo((int)useManager.getInterpreterType());
        for (IPythonNature nature : natures) {
            try {
                AbstractAdditionalDependencyInfo info = AdditionalProjectInterpreterInfo.getAdditionalInfoForProject(nature);
                if (info == null) continue;
                additionalInfo.add(info);
            }
            catch (MisconfigurationException e) {
                PyGlobalsBrowser.handle(e);
            }
        }
        PyGlobalsBrowser.doSelect(natures, additionalInfo, selectedText);
    }

    public static void doSelect(List<IPythonNature> pythonNatures, List<AbstractAdditionalInterpreterInfo> additionalInfo, String selectedText) {
        SelectionDialog dialog = GlobalsDialogFactory.create(PyGlobalsBrowser.getShell(), additionalInfo, selectedText, pythonNatures);
        dialog.open();
        Object[] result = dialog.getResult();
        if (result != null && result.length > 0) {
            Object[] objectArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                IInfo entry = obj instanceof AdditionalInfoAndIInfo ? ((AdditionalInfoAndIInfo)obj).info : (IInfo)obj;
                ArrayList<ItemPointer> pointers = new ArrayList<ItemPointer>();
                CompletionCache completionCache = new CompletionCache();
                for (IPythonNature pythonNature : pythonNatures) {
                    ICodeCompletionASTManager astManager = pythonNature.getAstManager();
                    if (astManager == null) continue;
                    AnalysisPlugin.getDefinitionFromIInfo(pointers, astManager, pythonNature, entry, (ICompletionCache)completionCache);
                    if (pointers.size() <= 0) continue;
                    new PyOpenAction().run((ItemPointer)pointers.get(0));
                    break;
                }
                ++n2;
            }
        }
    }
}

