/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.search;

import com.python.pydev.refactoring.IPyRefactoring2;
import com.python.pydev.refactoring.refactorer.search.AbstractPythonSearchQuery;
import com.python.pydev.refactoring.search.FindOccurrencesSearchResult;
import com.python.pydev.refactoring.wizards.rename.AbstractRenameRefactorProcess;
import com.python.pydev.ui.search.FileMatch;
import com.python.pydev.ui.search.LineElement;
import com.rc.retroweaver.runtime.Autobox;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.plugin.PydevPlugin;

public class FindOccurrencesSearchQuery
extends AbstractPythonSearchQuery {
    private IPyRefactoring2 pyRefactoring;
    private RefactoringRequest req;
    private FindOccurrencesSearchResult findOccurrencesSearchResult;

    public FindOccurrencesSearchQuery(IPyRefactoring2 r, RefactoringRequest req) {
        super(req.initialName);
        this.pyRefactoring = r;
        this.req = req;
    }

    public ISearchResult getSearchResult() {
        if (this.findOccurrencesSearchResult == null) {
            this.findOccurrencesSearchResult = new FindOccurrencesSearchResult(this);
        }
        return this.findOccurrencesSearchResult;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        try {
            this.req.pushMonitor(monitor);
            Map occurrences = this.pyRefactoring.findAllOccurrences(this.req);
            if (occurrences == null) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            try {
                int length = this.req.initialName.length();
                HashSet<Integer> foundOffsets = new HashSet<Integer>();
                Iterator iterator = occurrences.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry o = iterator.next();
                    foundOffsets.clear();
                    IFile file = (IFile)((Tuple)o.getKey()).o2;
                    IDocument doc = REF.getDocFromResource((IResource)file);
                    Iterator iterator2 = ((HashSet)o.getValue()).iterator();
                    while (iterator2.hasNext()) {
                        ASTEntry entry = (ASTEntry)iterator2.next();
                        int offset = AbstractRenameRefactorProcess.getOffset(doc, entry);
                        if (foundOffsets.contains(Autobox.valueOf((int)offset))) continue;
                        foundOffsets.add(Autobox.valueOf((int)offset));
                        PySelection ps = new PySelection(doc, offset);
                        int lineNumber = ps.getLineOfOffset();
                        String lineContents = ps.getLine(lineNumber);
                        int lineStartOffset = ps.getLineOffset(lineNumber);
                        LineElement element = new LineElement((IResource)file, lineNumber, lineStartOffset, lineContents);
                        this.findOccurrencesSearchResult.addMatch((Match)new FileMatch(file, offset, length, element));
                    }
                }
            }
            catch (CoreException e) {
                PydevPlugin.log((Throwable)e);
            }
        }
        finally {
            this.req.popMonitor();
        }
        return Status.OK_STATUS;
    }

    public String getResultLabel(int nMatches) {
        String searchString = this.getSearchString();
        if (searchString.length() > 0) {
            if (this.isScopeAllFileTypes()) {
                if (nMatches == 1) {
                    return StringUtils.format((String)"%s - 1 match in %s", (Object[])new Object[]{searchString, this.getDescription()});
                }
                return StringUtils.format((String)"%s - %s matches in %s", (Object[])new Object[]{searchString, new Integer(nMatches), this.getDescription()});
            }
            if (nMatches == 1) {
                return StringUtils.format((String)"%s - 1 match in %s", (Object[])new Object[]{searchString, this.getDescription()});
            }
            return StringUtils.format((String)"%s - %s matches in %s", (Object[])new Object[]{searchString, new Integer(nMatches), this.getDescription()});
        }
        throw new RuntimeException("Unexpected condition when finding: " + searchString);
    }

    private String getDescription() {
        return "'" + this.req.pyEdit.getProject().getName() + "' and related projects";
    }
}

