/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.shell;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.python.copiedfromeclipsesrc.JDTNotAvailableException;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.REF;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.shell.AbstractShell;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.runners.SimpleJythonRunner;
import org.python.pydev.runners.SimplePythonRunner;
import org.python.pydev.runners.SimpleRunner;

public class JythonShell
extends AbstractShell {
    public JythonShell() throws IOException, CoreException {
        super(PydevPlugin.getScriptWithinPySrc("pycompletionserver.py"));
    }

    protected synchronized String createServerProcess(IInterpreterInfo jythonJar, int pWrite, int pRead) throws IOException, JDTNotAvailableException, MisconfigurationException {
        String script = REF.getFileAbsolutePath((File)this.serverFile);
        String[] executableStr = SimpleJythonRunner.makeExecutableCommandStr(jythonJar.getExecutableOrJar(), script, "", String.valueOf(pWrite), String.valueOf(pRead));
        IInterpreterManager manager = PydevPlugin.getJythonInterpreterManager();
        String[] envp = null;
        try {
            envp = new SimplePythonRunner().getEnvironment(null, jythonJar, manager);
        }
        catch (CoreException e) {
            Log.log((Throwable)e);
        }
        this.process = SimpleRunner.createProcess(executableStr, envp, this.serverFile.getParentFile());
        return SimpleRunner.getArgumentsAsStr(executableStr, new String[0]);
    }
}

