/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.event;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.geom.Point2D;

public class PPanEventHandler
extends PDragSequenceEventHandler {
    private boolean autopan;
    private double minAutopanSpeed = 250.0;
    private double maxAutopanSpeed = 750.0;

    public PPanEventHandler() {
        this.setEventFilter(new PInputEventFilter(16));
        this.setAutopan(true);
    }

    protected void drag(PInputEvent e) {
        super.drag(e);
        this.pan(e);
    }

    protected void pan(PInputEvent e) {
        PCamera c = e.getCamera();
        Point2D l = e.getPosition();
        if (c.getViewBounds().contains(l)) {
            PDimension d = e.getDelta();
            c.translateView(d.getWidth(), d.getHeight());
        }
    }

    public void setAutopan(boolean autopan) {
        this.autopan = autopan;
    }

    public boolean getAutopan() {
        return this.autopan;
    }

    public void setMinAutopanSpeed(double minAutopanSpeed) {
        this.minAutopanSpeed = minAutopanSpeed;
    }

    public void setMaxAutopanSpeed(double maxAutopanSpeed) {
        this.maxAutopanSpeed = maxAutopanSpeed;
    }

    protected void dragActivityStep(PInputEvent aEvent) {
        if (!this.autopan) {
            return;
        }
        PCamera c = aEvent.getCamera();
        PBounds b = c.getBoundsReference();
        Point2D l = aEvent.getPositionRelativeTo(c);
        int outcode = b.outcode(l);
        PDimension delta = new PDimension();
        if ((outcode & 2) != 0) {
            delta.height = this.validatePanningSpeed(-1.0 - 0.5 * Math.abs(l.getY() - b.getY()));
        } else if ((outcode & 8) != 0) {
            delta.height = this.validatePanningSpeed(1.0 + 0.5 * Math.abs(l.getY() - (b.getY() + b.getHeight())));
        }
        if ((outcode & 4) != 0) {
            delta.width = this.validatePanningSpeed(1.0 + 0.5 * Math.abs(l.getX() - (b.getX() + b.getWidth())));
        } else if ((outcode & 1) != 0) {
            delta.width = this.validatePanningSpeed(-1.0 - 0.5 * Math.abs(l.getX() - b.getX()));
        }
        c.localToView(delta);
        if (delta.width != 0.0 || delta.height != 0.0) {
            c.translateView(delta.width, delta.height);
        }
    }

    protected double validatePanningSpeed(double delta) {
        double minDelta = this.minAutopanSpeed / (double)(1000L / this.getDragActivity().getStepRate());
        double maxDelta = this.maxAutopanSpeed / (double)(1000L / this.getDragActivity().getStepRate());
        boolean deltaNegative = delta < 0.0;
        if ((delta = Math.abs(delta)) < minDelta) {
            delta = minDelta;
        }
        if (delta > maxDelta) {
            delta = maxDelta;
        }
        if (deltaNegative) {
            delta = -delta;
        }
        return delta;
    }

    protected String paramString() {
        StringBuffer result = new StringBuffer();
        result.append("minAutopanSpeed=" + this.minAutopanSpeed);
        result.append(",maxAutopanSpeed=" + this.maxAutopanSpeed);
        if (this.autopan) {
            result.append(",autopan");
        }
        result.append(',');
        result.append(super.paramString());
        return result.toString();
    }
}

