/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.actions.container;

import com.rc.retroweaver.runtime.Autobox;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.uiutils.AsynchronousProgressMonitorDialog;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.plugin.PydevPlugin;

public abstract class PyContainerAction
implements IObjectActionDelegate {
    protected List<IContainer> selectedContainers;

    protected abstract boolean confirmRun();

    protected abstract void afterRun(int var1);

    protected abstract int doActionOnContainer(IContainer var1, IProgressMonitor var2);

    protected boolean getRefreshBeforeExecute() {
        return true;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            this.selectedContainers = null;
            return;
        }
        IStructuredSelection selections = (IStructuredSelection)selection;
        ArrayList<IContainer> containers = new ArrayList<IContainer>();
        Iterator it = selections.iterator();
        while (it.hasNext()) {
            IAdaptable adaptable;
            IContainer container;
            Object o = it.next();
            if (o instanceof IContainer) {
                containers.add((IContainer)o);
                continue;
            }
            if (!(o instanceof IAdaptable) || (container = (IContainer)(adaptable = (IAdaptable)o).getAdapter(ClassLiteral.getClass((String)"org/eclipse/core/resources/IContainer"))) == null) continue;
            containers.add(container);
        }
        this.selectedContainers = containers;
    }

    public void run(IAction action) {
        if (this.selectedContainers == null) {
            return;
        }
        if (!this.confirmRun()) {
            return;
        }
        this.beforeRun();
        final Integer[] nChanged = new Integer[]{Autobox.valueOf((int)0)};
        AsynchronousProgressMonitorDialog monitorDialog = new AsynchronousProgressMonitorDialog(PyAction.getShell());
        try {
            IRunnableWithProgress operation = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Iterator<IContainer> iter = PyContainerAction.this.selectedContainers.iterator();
                    while (iter.hasNext()) {
                        IContainer next = iter.next();
                        if (PyContainerAction.this.getRefreshBeforeExecute()) {
                            try {
                                next.refreshLocal(2, monitor);
                            }
                            catch (Exception e) {
                                PydevPlugin.log(e);
                            }
                        }
                        nChanged[0] = Autobox.valueOf((int)(nChanged[0] + PyContainerAction.this.doActionOnContainer(next, monitor)));
                    }
                }
            };
            boolean fork = !this.needsUIThread();
            monitorDialog.run(fork, true, operation);
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
        this.afterRun(nChanged[0]);
    }

    protected void beforeRun() {
    }

    protected boolean needsUIThread() {
        return false;
    }
}

