/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;
import org.python.pydev.core.callbacks.ICallback;
import org.python.pydev.core.structure.FastStack;
import org.python.pydev.core.structure.TreeNode;
import org.python.pydev.navigator.ProjectInfoForPackageExplorer;
import org.python.pydev.navigator.ProjectInfoToTreeStructure;
import org.python.pydev.navigator.PyPackageStateSaver;
import org.python.pydev.navigator.PythonBaseModelProvider;
import org.python.pydev.navigator.elements.IWrappedResource;
import org.python.pydev.navigator.elements.ProjectConfigError;
import org.python.pydev.navigator.elements.PythonFile;
import org.python.pydev.navigator.elements.PythonFolder;
import org.python.pydev.navigator.elements.PythonProjectSourceFolder;
import org.python.pydev.navigator.elements.PythonResource;
import org.python.pydev.navigator.elements.PythonSourceFolder;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonModelProvider
extends PythonBaseModelProvider
implements IPipelinedTreeContentProvider {
    public void getPipelinedChildren(Object parent, Set currentElements) {
        if (parent instanceof IWrappedResource) {
            Object[] children = this.getChildren(parent);
            currentElements.clear();
            currentElements.addAll(Arrays.asList(children));
            if (parent instanceof PythonProjectSourceFolder) {
                PythonProjectSourceFolder projectSourceFolder = (PythonProjectSourceFolder)parent;
                IProject project = (IProject)projectSourceFolder.getActualObject();
                this.fillChildrenForProject(currentElements, project);
            }
            return;
        }
        if (parent instanceof IWorkspaceRoot) {
            switch (this.topLevelChoice.getRootMode()) {
                case 0: {
                    currentElements.clear();
                    currentElements.addAll((Collection)getWorkingSetsCallback.call((Object)((IWorkspaceRoot)parent)));
                }
            }
        } else if (parent instanceof IWorkingSet) {
            IWorkingSet workingSet = (IWorkingSet)parent;
            currentElements.clear();
            currentElements.addAll(Arrays.asList(workingSet.getElements()));
        } else if (parent instanceof TreeNode) {
            TreeNode treeNode = (TreeNode)parent;
            currentElements.addAll(treeNode.getChildren());
        } else if (parent instanceof IProject) {
            IProject project = (IProject)parent;
            this.fillChildrenForProject(currentElements, project);
        }
        PipelinedShapeModification modification = new PipelinedShapeModification(parent, currentElements);
        this.convertToPythonElementsAddOrRemove(modification, true);
    }

    private void fillChildrenForProject(Set currentElements, IProject project) {
        ProjectInfoForPackageExplorer projectInfo = this.getProjectInfo(project);
        if (projectInfo != null) {
            currentElements.addAll(projectInfo.configErrors);
            if (projectInfo.interpreterInfo != null) {
                currentElements.add(ProjectInfoToTreeStructure.createFrom(projectInfo.interpreterInfo));
            }
        }
    }

    public void getPipelinedElements(Object input, Set currentElements) {
        this.getPipelinedChildren(input, currentElements);
    }

    public Object getPipelinedParent(Object object, Object aSuggestedParent) {
        Object p = this.topLevelChoice.getWorkingSetParentIfAvailable(object, (ICallback<List<IWorkingSet>, IWorkspaceRoot>)getWorkingSetsCallback);
        if (p != null) {
            aSuggestedParent = p;
        } else if (object instanceof IWrappedResource) {
            IWrappedResource resource = (IWrappedResource)object;
            Object parentElement = resource.getParentElement();
            if (parentElement != null) {
                aSuggestedParent = parentElement;
            }
        } else {
            if (object instanceof TreeNode) {
                TreeNode treeNode = (TreeNode)object;
                return treeNode.getParent();
            }
            if (object instanceof ProjectConfigError) {
                ProjectConfigError configError = (ProjectConfigError)object;
                return configError.getParent();
            }
        }
        return aSuggestedParent;
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification addModification) {
        this.convertToPythonElementsAddOrRemove(addModification, true);
        return addModification;
    }

    public boolean interceptRefresh(PipelinedViewerUpdate refreshSynchronization) {
        return this.convertToPythonElementsUpdateOrRefresh(refreshSynchronization.getRefreshTargets());
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification removeModification) {
        this.convertToPythonElementsAddOrRemove(removeModification, false);
        return removeModification;
    }

    public boolean interceptUpdate(PipelinedViewerUpdate updateSynchronization) {
        boolean ret = this.convertToPythonElementsUpdateOrRefresh(updateSynchronization.getRefreshTargets());
        return ret;
    }

    private void debug(String desc, PipelinedViewerUpdate updateSynchronization) {
        System.out.println(new StringBuffer("\nDesc:").append(desc).toString());
        System.out.println("Refresh targets:");
        for (Object o : updateSynchronization.getRefreshTargets()) {
            System.out.println(o);
        }
    }

    private void debug(String desc, PipelinedShapeModification modification) {
        System.out.println(new StringBuffer("\nDesc:").append(desc).toString());
        Object parent = modification.getParent();
        System.out.println(new StringBuffer("Parent:").append(parent).toString());
        System.out.println("Children:");
        for (Object o : modification.getChildren()) {
            System.out.println(o);
        }
    }

    public void restoreState(IMemento memento) {
        new PyPackageStateSaver(this, (Viewer)this.viewer, memento).restoreState();
    }

    public void saveState(IMemento memento) {
        new PyPackageStateSaver(this, (Viewer)this.viewer, memento).saveState();
    }

    private void convertToPythonElementsAddOrRemove(PipelinedShapeModification modification, boolean isAdd) {
        Object parent = modification.getParent();
        if (parent instanceof IContainer) {
            IContainer parentContainer = (IContainer)parent;
            Object pythonParent = this.getResourceInPythonModel((IResource)parentContainer, true);
            if (pythonParent instanceof IWrappedResource) {
                IWrappedResource parentResource = (IWrappedResource)pythonParent;
                modification.setParent((Object)parentResource);
                this.wrapChildren(parentResource, parentResource.getSourceFolder(), modification.getChildren(), isAdd);
            } else if (pythonParent == null) {
                Object parentInWrap = parentContainer;
                PythonSourceFolder sourceFolderInWrap = null;
                FastStack found = new FastStack();
                while (parentContainer != null) {
                    found.push((Object)parentContainer);
                    if (parentContainer instanceof IProject) {
                        this.tryCreateModelFromProject((IProject)parentContainer, (FastStack<Object>)found);
                        this.convertToPythonElementsUpdateOrRefresh(modification.getChildren());
                        return;
                    }
                    Object p = this.getResourceInPythonModel((IResource)parentContainer, true);
                    if (p instanceof IWrappedResource) {
                        IWrappedResource wrappedResource = (IWrappedResource)p;
                        sourceFolderInWrap = wrappedResource.getSourceFolder();
                        while (found.size() > 0) {
                            Object child;
                            Object f = found.pop();
                            if (f instanceof IResource && (child = sourceFolderInWrap.getChild((IResource)f)) != null && child instanceof IWrappedResource) {
                                wrappedResource = (IWrappedResource)child;
                                continue;
                            }
                            if (f instanceof IFile) {
                                wrappedResource = new PythonFile(wrappedResource, (IFile)f, sourceFolderInWrap);
                                continue;
                            }
                            if (!(f instanceof IFolder)) continue;
                            wrappedResource = new PythonFolder(wrappedResource, (IFolder)f, sourceFolderInWrap);
                        }
                        parentInWrap = wrappedResource;
                        break;
                    }
                    parentContainer = parentContainer.getParent();
                }
                this.wrapChildren(parentInWrap, sourceFolderInWrap, modification.getChildren(), isAdd);
            }
        } else if (parent == null) {
            this.wrapChildren(null, null, modification.getChildren(), isAdd);
        }
    }

    private void tryCreateModelFromProject(IProject project, FastStack<Object> found) {
        PythonNature nature = PythonNature.getPythonNature(project);
        if (nature == null) {
            return;
        }
        HashSet<String> sourcePathSet = new HashSet();
        try {
            sourcePathSet = nature.getPythonPathNature().getProjectSourcePathSet(true);
        }
        catch (CoreException e) {
            PydevPlugin.log(e);
        }
        Object currentParent = project;
        PythonSourceFolder pythonSourceFolder = null;
        Iterator it = found.topDownIterator();
        while (it.hasNext()) {
            IWrappedResource r;
            Object child = it.next();
            if ((child instanceof IFolder || child instanceof IProject) && pythonSourceFolder == null) {
                pythonSourceFolder = this.tryWrapSourceFolder(currentParent, (IContainer)child, sourcePathSet);
                if (pythonSourceFolder != null) {
                    currentParent = pythonSourceFolder;
                    continue;
                }
                if (!(child instanceof IContainer)) continue;
                currentParent = (IContainer)child;
                continue;
            }
            if (pythonSourceFolder != null && (r = this.doWrap(currentParent, pythonSourceFolder, child)) != null) {
                child = r;
            }
            currentParent = child;
        }
    }

    protected boolean wrapChildren(Object parent, PythonSourceFolder pythonSourceFolder, Set currentChildren, boolean isAdd) {
        LinkedHashSet<Object> convertedChildren = new LinkedHashSet<Object>();
        Iterator childrenItr = currentChildren.iterator();
        while (childrenItr.hasNext()) {
            Object child = childrenItr.next();
            if (child == null) {
                childrenItr.remove();
                continue;
            }
            if (!(child instanceof IResource)) continue;
            Object existing = this.getResourceInPythonModel((IResource)child, true);
            if (existing == null) {
                IWrappedResource w;
                if (!isAdd || (w = this.doWrap(parent, pythonSourceFolder, child)) == null) continue;
                childrenItr.remove();
                convertedChildren.add(w);
                continue;
            }
            childrenItr.remove();
            convertedChildren.add(existing);
            if (isAdd) continue;
            IWrappedResource wrapped = (IWrappedResource)existing;
            wrapped.getSourceFolder().removeChild((IResource)child);
        }
        if (!convertedChildren.isEmpty()) {
            currentChildren.addAll(convertedChildren);
            return true;
        }
        return false;
    }

    protected IWrappedResource doWrap(Object parent, PythonSourceFolder pythonSourceFolder, Object child) {
        if (child instanceof IProject) {
            PythonSourceFolder f;
            if (pythonSourceFolder == null && parent != null && (f = this.doWrapPossibleSourceFolder(parent, (IContainer)((IProject)child))) != null) {
                return f;
            }
        } else if (child instanceof IFolder) {
            PythonSourceFolder f;
            IFolder folder = (IFolder)child;
            if (pythonSourceFolder == null && parent != null && (f = this.doWrapPossibleSourceFolder(parent, (IContainer)folder)) != null) {
                return f;
            }
            if (pythonSourceFolder != null) {
                return new PythonFolder((IWrappedResource)parent, folder, pythonSourceFolder);
            }
        } else if (child instanceof IFile) {
            if (pythonSourceFolder != null) {
                return new PythonFile((IWrappedResource)parent, (IFile)child, pythonSourceFolder);
            }
        } else if (child instanceof IResource) {
            if (pythonSourceFolder != null) {
                return new PythonResource((IWrappedResource)parent, (IResource)child, pythonSourceFolder);
            }
        } else {
            throw new RuntimeException(new StringBuffer("Unexpected class:").append(child.getClass()).toString());
        }
        return null;
    }

    private PythonSourceFolder doWrapPossibleSourceFolder(Object parent, IContainer container) {
        try {
            Set sourcePathSet;
            PythonSourceFolder newSourceFolder;
            IProject project = !(container instanceof IProject) ? ((IContainer)parent).getProject() : (IProject)container;
            PythonNature nature = PythonNature.getPythonNature(project);
            if (nature != null && (newSourceFolder = this.tryWrapSourceFolder(parent, container, sourcePathSet = nature.getPythonPathNature().getProjectSourcePathSet(true))) != null) {
                return newSourceFolder;
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private PythonSourceFolder tryWrapSourceFolder(Object parent, IContainer container, Set<String> sourcePathSet) {
        IPath fullPath = container.getFullPath();
        if (sourcePathSet.contains(fullPath.toString())) {
            PythonSourceFolder sourceFolder;
            if (container instanceof IFolder) {
                sourceFolder = new PythonSourceFolder(parent, (IFolder)container);
            } else if (container instanceof IProject) {
                sourceFolder = new PythonProjectSourceFolder(parent, (IProject)container);
            } else {
                return null;
            }
            Set<PythonSourceFolder> sourceFolders = this.getProjectSourceFolders(container.getProject());
            sourceFolders.add(sourceFolder);
            return sourceFolder;
        }
        return null;
    }

    protected boolean convertToPythonElementsUpdateOrRefresh(Set currentChildren) {
        LinkedHashSet<Object> convertedChildren = new LinkedHashSet<Object>();
        Iterator childrenItr = currentChildren.iterator();
        while (childrenItr.hasNext()) {
            PythonNature nature;
            IFolder folder;
            IProject project;
            Object child = childrenItr.next();
            if (child == null) {
                childrenItr.remove();
                continue;
            }
            if (!(child instanceof IResource) || child instanceof IWrappedResource) continue;
            IResource res = (IResource)child;
            Object resourceInPythonModel = this.getResourceInPythonModel(res, true);
            if (resourceInPythonModel != null) {
                childrenItr.remove();
                convertedChildren.add(resourceInPythonModel);
                continue;
            }
            IContainer p = res.getParent();
            if (p == null) continue;
            Object pythonParent = this.getResourceInPythonModel((IResource)p, true);
            if (pythonParent instanceof IWrappedResource) {
                IWrappedResource parent = (IWrappedResource)pythonParent;
                if (res instanceof IProject) {
                    throw new RuntimeException("A project's parent should never be an IWrappedResource!");
                }
                if (res instanceof IFolder) {
                    childrenItr.remove();
                    convertedChildren.add(new PythonFolder(parent, (IFolder)res, parent.getSourceFolder()));
                    continue;
                }
                if (res instanceof IFile) {
                    childrenItr.remove();
                    convertedChildren.add(new PythonFile(parent, (IFile)res, parent.getSourceFolder()));
                    continue;
                }
                if (!(child instanceof IResource)) continue;
                childrenItr.remove();
                convertedChildren.add(new PythonResource(parent, (IResource)child, parent.getSourceFolder()));
                continue;
            }
            if (!(res instanceof IFolder) || (project = (folder = (IFolder)res).getProject()) == null || (nature = PythonNature.getPythonNature(project)) == null) continue;
            HashSet<String> sourcePathSet = new HashSet();
            try {
                sourcePathSet = nature.getPythonPathNature().getProjectSourcePathSet(true);
            }
            catch (CoreException e) {
                PydevPlugin.log(e);
            }
            PythonSourceFolder wrapped = this.tryWrapSourceFolder(p, (IContainer)folder, sourcePathSet);
            if (wrapped == null) continue;
            childrenItr.remove();
            convertedChildren.add(wrapped);
        }
        if (!convertedChildren.isEmpty()) {
            currentChildren.addAll(convertedChildren);
            return true;
        }
        return false;
    }
}

