/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.uiutils;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AsynchronousProgressMonitorDialog
extends ProgressMonitorDialog {
    private static int UPDATE_INTERVAL_MS = 300;
    private volatile Runnable updateStatus;
    private volatile String lastTaskName = null;
    private Object updateStatusLock = new Object();
    private IProgressMonitor progressMonitor = null;

    public AsynchronousProgressMonitorDialog(Shell parent) {
        super(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleTaskNameChange() {
        Object object = this.updateStatusLock;
        synchronized (object) {
            if (this.updateStatus == null) {
                this.updateStatus = new Runnable(){

                    public void run() {
                        try {
                            IProgressMonitor monitor = AsynchronousProgressMonitorDialog.super.getProgressMonitor();
                            String s = AsynchronousProgressMonitorDialog.this.lastTaskName;
                            if (s != null) {
                                monitor.setTaskName(s);
                            }
                        }
                        finally {
                            AsynchronousProgressMonitorDialog.this.updateStatus = null;
                        }
                    }
                };
                Display disp = this.getContents().getDisplay();
                disp.timerExec(UPDATE_INTERVAL_MS, this.updateStatus);
            }
        }
    }

    public IProgressMonitor getProgressMonitor() {
        if (this.progressMonitor == null) {
            final IProgressMonitor m = super.getProgressMonitor();
            this.progressMonitor = new IProgressMonitor(){

                public void worked(int work) {
                    m.worked(work);
                }

                public void subTask(String name) {
                    m.subTask(name);
                }

                public void setTaskName(String name) {
                    if (AsynchronousProgressMonitorDialog.this.updateStatus == null) {
                        AsynchronousProgressMonitorDialog.this.scheduleTaskNameChange();
                    }
                    AsynchronousProgressMonitorDialog.this.lastTaskName = name;
                }

                public void setCanceled(boolean value) {
                    m.setCanceled(value);
                }

                public boolean isCanceled() {
                    return m.isCanceled();
                }

                public void internalWorked(double work) {
                    m.internalWorked(work);
                }

                public void done() {
                    m.done();
                }

                public void beginTask(String name, int totalWork) {
                    m.beginTask(name, totalWork);
                }
            };
        }
        return this.progressMonitor;
    }

    public static void main(String[] arg) {
        Shell shl = new Shell();
        AsynchronousProgressMonitorDialog dlg = new AsynchronousProgressMonitorDialog(shl);
        long l = System.currentTimeMillis();
        try {
            dlg.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Testing", 100000);
                    long i = 0L;
                    while (i < 100000L && !monitor.isCanceled()) {
                        monitor.setTaskName("Task " + i);
                        ++i;
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Took " + (System.currentTimeMillis() - l));
    }
}

