/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.docutils;

import com.rc.retroweaver.runtime.Autobox;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.ImportsSelection;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.PyPartitionScanner;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStringBuffer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PySelection {
    private IDocument doc;
    private ITextSelection textSelection;
    public static final String[] DEDENT_TOKENS = new String[]{"return", "break", "continue", "pass", "raise"};
    public static final String[] CLASS_AND_FUNC_TOKENS = new String[]{"def", "class"};
    public static final String[] INDENT_TOKENS = new String[]{"if", "for", "except", "def", "class", "else", "elif", "while", "try", "with", "finally"};
    public static final String[] TOKENS_BEFORE_ELSE = new String[]{"if ", "if(", "for ", "for(", "except:", "except(", "while ", "while(", "elif ", "elif:"};
    public static final String[] TOKENS_BEFORE_EXCEPT = new String[]{"try:"};
    public static final String[] TOKENS_BEFORE_FINALLY = new String[]{"try:", "except:", "except("};
    private static final Pattern FunctionPattern = Pattern.compile("\\s*def\\s+\\w*.*", 32);
    private static final Pattern ClassPattern = Pattern.compile("\\s*class\\s+\\w*.*", 32);
    private static final Pattern IdentifierPattern = Pattern.compile("\\w*");
    public static int DECLARATION_NONE = 0;
    public static int DECLARATION_CLASS = 1;
    public static int DECLARATION_METHOD = 2;

    public PySelection(ITextEditor textEditor) {
        this(textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput()), (ITextSelection)textEditor.getSelectionProvider().getSelection());
    }

    public PySelection(IDocument doc, ITextSelection selection) {
        this.doc = doc;
        this.textSelection = selection;
    }

    public PySelection(IDocument doc, int line, int col) {
        this(doc, line, col, 0);
    }

    public PySelection(IDocument doc, int line, int col, int len) {
        this.doc = doc;
        this.textSelection = new TextSelection(doc, this.getAbsoluteCursorOffset(line, col), len);
    }

    public static int getAbsoluteCursorOffset(IDocument doc, int line, int col) {
        try {
            IRegion offsetR = doc.getLineInformation(line);
            return offsetR.getOffset() + col;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int getAbsoluteCursorOffset(int line, int col) {
        return PySelection.getAbsoluteCursorOffset(this.doc, line, col);
    }

    public PySelection(IDocument doc, int offset) {
        this.doc = doc;
        this.textSelection = new TextSelection(doc, offset, 0);
    }

    public void setSelection(int absoluteStart, int absoluteEnd) {
        this.textSelection = new TextSelection(this.doc, absoluteStart, absoluteEnd - absoluteStart);
    }

    public PySelection(IDocument doc) {
        this(doc, 0);
    }

    public void selectCompleteLine() {
        IRegion endLine = this.getEndLine();
        IRegion startLine = this.getStartLine();
        this.textSelection = new TextSelection(this.doc, startLine.getOffset(), endLine.getOffset() + endLine.getLength() - startLine.getOffset());
    }

    public static boolean isFutureImportLine(String line) {
        List<String> split = StringUtils.split(line, ' ', '\t');
        int fromIndex = split.indexOf("from");
        int futureIndex = split.indexOf("__future__");
        boolean isFuture = fromIndex != -1 && futureIndex != -1 && futureIndex == fromIndex + 1;
        return isFuture;
    }

    public int getLineAvailableForImport(boolean isFutureImport) {
        FastStringBuffer multiLineBuf = new FastStringBuffer();
        int[] firstGlobalLiteral = this.getFirstGlobalLiteral(multiLineBuf, 0);
        if (multiLineBuf.length() > 0 && firstGlobalLiteral[0] >= 0 && firstGlobalLiteral[1] >= 0) {
            int startingMultilineComment = this.getLineOfOffset(firstGlobalLiteral[0]);
            if (startingMultilineComment < 4) {
                int lineOfOffset = this.getLineOfOffset(firstGlobalLiteral[1]);
                return this.getLineAvailableForImport(lineOfOffset + 1, isFutureImport);
            }
            return this.getLineAvailableForImport(0, isFutureImport);
        }
        return this.getLineAvailableForImport(0, isFutureImport);
    }

    private int getLineAvailableForImport(int startingAtLine, boolean isFutureImport) {
        int firstNonCommentLine = -1;
        int afterFirstImports = -1;
        IDocument document = this.getDoc();
        int lines = document.getNumberOfLines();
        ParsingUtils parsingUtils = ParsingUtils.create(document);
        int line = startingAtLine;
        while (line < lines) {
            String str = this.getLine(line);
            if (!str.startsWith("#")) {
                ICodeCompletionASTManager.ImportInfo importInfo;
                int i = str.indexOf(35);
                if (i != -1) {
                    str = str.substring(0, i);
                }
                if (firstNonCommentLine == -1) {
                    firstNonCommentLine = line;
                }
                if ((importInfo = ImportsSelection.getImportsTipperStr(str, false)) != null && importInfo.importsTipperStr != null && importInfo.importsTipperStr.length() > 0) {
                    i = str.indexOf(40);
                    if (i != -1) {
                        int j;
                        int lineOffset = -1;
                        try {
                            lineOffset = document.getLineOffset(line);
                        }
                        catch (BadLocationException e1) {
                            throw new RuntimeException(e1);
                        }
                        try {
                            j = parsingUtils.eatPar(lineOffset + i, null);
                        }
                        catch (SyntaxErrorException e1) {
                            throw new RuntimeException(e1);
                        }
                        try {
                            line = document.getLineOfOffset(j);
                        }
                        catch (BadLocationException e) {
                            Log.log(e);
                        }
                    } else if (str.endsWith("\\")) {
                        while (str.endsWith("\\") && line < lines) {
                            str = this.getLine(++line);
                        }
                    }
                    afterFirstImports = line + 1;
                } else if (str.trim().length() > 0) break;
            }
            ++line;
        }
        if (isFutureImport) {
            return firstNonCommentLine;
        }
        return afterFirstImports > firstNonCommentLine ? afterFirstImports : firstNonCommentLine;
    }

    public int[] getFirstGlobalLiteral(FastStringBuffer buf, int initialOffset) {
        try {
            IDocument d = this.getDoc();
            String strDoc = d.get(initialOffset, d.getLength() - initialOffset);
            int docLen = strDoc.length();
            if (initialOffset > docLen - 1) {
                return new int[]{-1, -1};
            }
            char current = strDoc.charAt(initialOffset);
            ParsingUtils parsingUtils = ParsingUtils.create(strDoc);
            while (current != '\'' && current != '\"' && initialOffset < docLen - 1) {
                if (current == '(') {
                    initialOffset = parsingUtils.eatPar(initialOffset, buf);
                }
                if (++initialOffset >= docLen - 1) continue;
                current = strDoc.charAt(initialOffset);
            }
            if (initialOffset < docLen - 1) {
                if (initialOffset == 0) {
                    int i = parsingUtils.eatLiterals(buf, initialOffset);
                    return new int[]{initialOffset, i};
                }
                char lastChar = strDoc.charAt(initialOffset - 1);
                if (lastChar == '\r' || lastChar == '\n') {
                    int i = parsingUtils.eatLiterals(buf, initialOffset);
                    return new int[]{initialOffset, i};
                }
                return this.getFirstGlobalLiteral(buf, initialOffset + 1);
            }
            return new int[]{-1, -1};
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        catch (SyntaxErrorException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void beep(Exception e) {
        Log.log(e);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay().beep();
    }

    public static String getLineWithoutCommentsOrLiterals(String l) {
        FastStringBuffer buf = new FastStringBuffer(l, 2);
        boolean throwSyntaxError = false;
        try {
            ParsingUtils.removeCommentsWhitespacesAndLiterals(buf, false, throwSyntaxError);
        }
        catch (SyntaxErrorException e) {
            throw new RuntimeException(e);
        }
        return buf.toString();
    }

    public String getLineWithoutCommentsOrLiterals() {
        return PySelection.getLineWithoutCommentsOrLiterals(this.getLine());
    }

    public static String getLineWithoutLiterals(String line) {
        FastStringBuffer buf = new FastStringBuffer(line, 2);
        boolean throwSyntaxError = false;
        try {
            ParsingUtils.removeLiterals(buf, throwSyntaxError);
        }
        catch (SyntaxErrorException e) {
            throw new RuntimeException(e);
        }
        return buf.toString();
    }

    public int getCursorColumn() {
        try {
            int absoluteOffset = this.getAbsoluteCursorOffset();
            IRegion region = this.doc.getLineInformationOfOffset(absoluteOffset);
            return absoluteOffset - region.getOffset();
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public String getLine() {
        return PySelection.getLine(this.getDoc(), this.getCursorLine());
    }

    public String getLine(int i) {
        return PySelection.getLine(this.getDoc(), i);
    }

    public static String getLine(IDocument doc, int i) {
        try {
            return doc.get(doc.getLineInformation(i).getOffset(), doc.getLineInformation(i).getLength());
        }
        catch (Exception exception) {
            return "";
        }
    }

    public int getLineOfOffset() {
        return this.getLineOfOffset(this.getAbsoluteCursorOffset());
    }

    public int getLineOfOffset(int offset) {
        return PySelection.getLineOfOffset(this.getDoc(), offset);
    }

    public static int getLineOfOffset(IDocument doc, int offset) {
        try {
            return doc.getLineOfOffset(offset);
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    public int getLineOffset() {
        return this.getLineOffset(this.getCursorLine());
    }

    public int getLineOffset(int line) {
        try {
            return this.getDoc().getLineInformation(line).getOffset();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void deleteLine(int i) {
        PySelection.deleteLine(this.getDoc(), i);
    }

    public static void deleteLine(IDocument doc, int i) {
        try {
            IRegion lineInformation = doc.getLineInformation(i);
            int offset = lineInformation.getOffset();
            int length = -1;
            if (doc.getNumberOfLines() > i) {
                int nextLineOffset = doc.getLineInformation(i + 1).getOffset();
                length = nextLineOffset - offset;
            } else {
                length = lineInformation.getLength();
            }
            if (length > -1) {
                doc.replace(offset, length, "");
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void deleteSpacesAfter(int offset) {
        try {
            int len = this.countSpacesAfter(offset);
            if (len > 0) {
                this.doc.replace(offset, len, "");
            }
        }
        catch (Exception exception) {}
    }

    public int countSpacesAfter(int offset) throws BadLocationException {
        if (offset >= this.doc.getLength()) {
            return 0;
        }
        int initial = offset;
        String next = this.doc.get(offset, 1);
        try {
            while (next.charAt(0) == ' ' || next.charAt(0) == '\t') {
                next = this.doc.get(++offset, 1);
            }
        }
        catch (Exception exception) {}
        return offset - initial;
    }

    public void deleteSelection() throws BadLocationException {
        int offset = this.textSelection.getOffset();
        this.doc.replace(offset, this.textSelection.getLength(), "");
    }

    public void addLine(String contents, int afterLine) {
        PySelection.addLine(this.getDoc(), this.getEndLineDelim(), contents, afterLine);
    }

    public static void addLine(IDocument doc, String endLineDelim, String contents, int afterLine) {
        try {
            int offset = -1;
            offset = doc.getNumberOfLines() > afterLine ? doc.getLineInformation(afterLine + 1).getOffset() : doc.getLineInformation(afterLine).getOffset();
            if (doc.getNumberOfLines() - 1 == afterLine) {
                contents = new StringBuffer(String.valueOf(endLineDelim)).append(contents).toString();
            }
            if (!contents.endsWith(endLineDelim)) {
                contents = new StringBuffer(String.valueOf(contents)).append(endLineDelim).toString();
            }
            if (offset >= 0) {
                doc.replace(offset, 0, contents);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public String getLineContentsFromCursor() throws BadLocationException {
        int lineOfOffset = this.getDoc().getLineOfOffset(this.getAbsoluteCursorOffset());
        IRegion lineInformation = this.getDoc().getLineInformation(lineOfOffset);
        String lineToCursor = this.getDoc().get(this.getAbsoluteCursorOffset(), lineInformation.getOffset() + lineInformation.getLength() - this.getAbsoluteCursorOffset());
        return lineToCursor;
    }

    public String getLineContentsToCursor(boolean removeComments, boolean removeLiterals) throws BadLocationException {
        if (!removeComments || !removeLiterals) {
            throw new RuntimeException("Currently only accepts removing the literals and comments.");
        }
        int cursorOffset = this.getAbsoluteCursorOffset();
        IRegion lineInformationOfOffset = this.doc.getLineInformationOfOffset(cursorOffset);
        IDocumentPartitioner partitioner = PyPartitionScanner.checkPartitionScanner(this.doc);
        if (partitioner == null) {
            throw new RuntimeException("Partitioner not set up.");
        }
        StringBuffer buffer = new StringBuffer();
        int offset = lineInformationOfOffset.getOffset();
        int length = lineInformationOfOffset.getLength();
        int i = offset;
        while (i <= offset + length && i < cursorOffset) {
            String contentType = partitioner.getContentType(i);
            if (contentType.equals("__dftl_partition_content_type")) {
                buffer.append(this.doc.getChar(i));
            } else {
                buffer.append(' ');
            }
            ++i;
        }
        return buffer.toString();
    }

    public String getLineContentsToCursor() throws BadLocationException {
        int lineOfOffset = this.getDoc().getLineOfOffset(this.getAbsoluteCursorOffset());
        IRegion lineInformation = this.getDoc().getLineInformation(lineOfOffset);
        String lineToCursor = this.getDoc().get(lineInformation.getOffset(), this.getAbsoluteCursorOffset() - lineInformation.getOffset());
        return lineToCursor;
    }

    public void selectAll(boolean forceNewSelection) {
        if (!forceNewSelection && this.getSelLength() > 0) {
            return;
        }
        this.textSelection = new TextSelection(this.doc, 0, this.doc.getLength());
    }

    public int getStartLineIndex() {
        return this.getTextSelection().getStartLine();
    }

    public int getEndLineIndex() {
        return this.getTextSelection().getEndLine();
    }

    public IDocument getDoc() {
        return this.doc;
    }

    public int getSelLength() {
        return this.getTextSelection().getLength();
    }

    public String getCursorLineContents() {
        try {
            int start = this.getStartLine().getOffset();
            int end = this.getEndLine().getOffset() + this.getEndLine().getLength();
            return this.doc.get(start, end - start);
        }
        catch (BadLocationException e) {
            Log.log(e);
            return "";
        }
    }

    public static String getDelimiter(IDocument doc) {
        return TextUtilities.getDefaultLineDelimiter((IDocument)doc);
    }

    public String getEndLineDelim() {
        return PySelection.getDelimiter(this.getDoc());
    }

    public IRegion getStartLine() {
        try {
            return this.getDoc().getLineInformation(this.getStartLineIndex());
        }
        catch (BadLocationException e) {
            Log.log(e);
            return null;
        }
    }

    public IRegion getEndLine() {
        int endLineIndex;
        block3: {
            try {
                endLineIndex = this.getEndLineIndex();
                if (endLineIndex != -1) break block3;
                return null;
            }
            catch (BadLocationException e) {
                Log.log(e);
                return null;
            }
        }
        return this.getDoc().getLineInformation(endLineIndex);
    }

    public int getCursorLine() {
        return this.getTextSelection().getEndLine();
    }

    public int getAbsoluteCursorOffset() {
        return this.getTextSelection().getOffset();
    }

    public ITextSelection getTextSelection() {
        return this.textSelection;
    }

    public String getSelectedText() {
        ITextSelection txtSel = this.getTextSelection();
        int start = txtSel.getOffset();
        int len = txtSel.getLength();
        try {
            return this.doc.get(start, len);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public char getCharAfterCurrentOffset() throws BadLocationException {
        return this.getDoc().getChar(this.getAbsoluteCursorOffset() + 1);
    }

    public char getCharAtCurrentOffset() throws BadLocationException {
        return this.getDoc().getChar(this.getAbsoluteCursorOffset());
    }

    public Tuple<String, String> getBeforeAndAfterMatchingChars(char c) {
        int initial = this.getAbsoluteCursorOffset();
        int curr = initial - 1;
        IDocument doc = this.getDoc();
        FastStringBuffer buf = new FastStringBuffer(10);
        int length = doc.getLength();
        while (curr >= 0 && curr < length) {
            char gotten;
            try {
                gotten = doc.getChar(curr);
            }
            catch (BadLocationException badLocationException) {
                break;
            }
            if (gotten != c) break;
            buf.append(c);
            --curr;
        }
        String before = buf.toString();
        buf.clear();
        curr = initial;
        while (curr >= 0 && curr < length) {
            char gotten;
            try {
                gotten = doc.getChar(curr);
            }
            catch (BadLocationException badLocationException) {
                break;
            }
            if (gotten != c) break;
            buf.append(c);
            ++curr;
        }
        String after = buf.toString();
        return new Tuple<String, String>(before, after);
    }

    public int getEndLineOffset(int line) throws BadLocationException {
        IRegion lineInformation = this.doc.getLineInformation(line);
        return lineInformation.getOffset() + lineInformation.getLength();
    }

    public int getEndLineOffset() {
        IRegion endLine = this.getEndLine();
        return endLine.getOffset() + endLine.getLength();
    }

    public int getStartLineOffset() {
        IRegion startLine = this.getStartLine();
        return startLine.getOffset();
    }

    public String getFullRepAfterSelection() throws BadLocationException {
        int absoluteCursorOffset = this.getAbsoluteCursorOffset();
        int length = this.doc.getLength();
        int end = absoluteCursorOffset;
        char ch = this.doc.getChar(end);
        while (Character.isLetterOrDigit(ch) || ch == '.') {
            if (length - 1 < ++end) break;
            ch = this.doc.getChar(end);
        }
        return this.doc.get(absoluteCursorOffset, end - absoluteCursorOffset);
    }

    public Tuple<String, Integer> getCurrToken() throws BadLocationException {
        int start;
        Tuple<String, Integer> tup = PySelection.extractActivationToken(this.doc, this.getAbsoluteCursorOffset(), false);
        String prefix = (String)tup.o1;
        int end = start = (Integer)tup.o2 - prefix.length();
        while (this.doc.getLength() - 1 >= end) {
            char ch = this.doc.getChar(end);
            if (!Character.isJavaIdentifierPart(ch)) break;
            ++end;
        }
        String post = this.doc.get(((Integer)tup.o2).intValue(), end - (Integer)tup.o2);
        return new Tuple<String, Integer>(new StringBuffer(String.valueOf(prefix)).append(post).toString(), Autobox.valueOf((int)start));
    }

    public Tuple<List<String>, Integer> getInsideParentesisToks(boolean addSelf) {
        String line = this.getLine();
        int openParIndex = line.indexOf(40);
        if (openParIndex <= -1) {
            return null;
        }
        int lineOffset = this.getStartLineOffset();
        int i = lineOffset + openParIndex;
        return this.getInsideParentesisToks(addSelf, i);
    }

    public Tuple<List<String>, Integer> getInsideParentesisToks(boolean addSelf, int offset) {
        int j;
        ArrayList<String> l = new ArrayList<String>();
        String docContents = this.doc.get();
        try {
            j = ParsingUtils.create(docContents).eatPar(offset, null);
        }
        catch (SyntaxErrorException e) {
            throw new RuntimeException(e);
        }
        String insideParentesisTok = docContents.substring(offset + 1, j);
        StringTokenizer tokenizer = new StringTokenizer(insideParentesisTok, ",");
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            String trimmed = tok.split("=")[0].trim();
            trimmed = trimmed.replaceAll("\\(", "");
            trimmed = trimmed.replaceAll("\\)", "");
            if (!addSelf && trimmed.equals("self") || trimmed.length() <= 0) continue;
            int colonPos = trimmed.indexOf(58);
            if (colonPos != -1) {
                trimmed = trimmed.substring(0, colonPos);
                trimmed = trimmed.trim();
            }
            if (trimmed.length() <= 0) continue;
            l.add(trimmed);
        }
        return new Tuple<List<String>, Integer>(l, Autobox.valueOf((int)j));
    }

    public void replaceLineContentsToSelection(String newContents) throws BadLocationException {
        int lineOfOffset = this.getDoc().getLineOfOffset(this.getAbsoluteCursorOffset());
        IRegion lineInformation = this.getDoc().getLineInformation(lineOfOffset);
        this.getDoc().replace(lineInformation.getOffset(), this.getAbsoluteCursorOffset() - lineInformation.getOffset(), newContents);
    }

    public String getPreviousLineThatStartsWithToken(String[] tokens) {
        DocIterator iterator = new DocIterator(false, this);
        while (iterator.hasNext()) {
            String line = iterator.next();
            String trimmed = line.trim();
            String[] stringArray = tokens;
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String prefix = stringArray[n2];
                if (trimmed.startsWith(prefix)) {
                    return line;
                }
                ++n2;
            }
        }
        return null;
    }

    public LineStartingScope getPreviousLineThatStartsScope() {
        return this.getPreviousLineThatStartsScope(INDENT_TOKENS, true, Integer.MAX_VALUE);
    }

    public LineStartingScope getNextLineThatStartsScope() {
        return this.getNextLineThatStartsScope(INDENT_TOKENS, true, Integer.MAX_VALUE);
    }

    public LineStartingScope getPreviousLineThatStartsScope(String[] indentTokens, boolean considerCurrentLine, int mustHaveIndentLowerThan) {
        int lineToStart = -1;
        if (!considerCurrentLine) {
            lineToStart = this.getCursorLine() - 1;
        }
        return this.getPreviousLineThatStartsScope(indentTokens, lineToStart, mustHaveIndentLowerThan);
    }

    public LineStartingScope getNextLineThatStartsScope(String[] indentTokens, boolean considerCurrentLine, int mustHaveIndentLowerThan) {
        int lineToStart = -1;
        if (!considerCurrentLine) {
            lineToStart = this.getCursorLine() - 1;
        }
        return this.getNextLineThatStartsScope(indentTokens, lineToStart, mustHaveIndentLowerThan);
    }

    public LineStartingScope getPreviousLineThatStartsScope(int lineToStart) {
        return this.getPreviousLineThatStartsScope(INDENT_TOKENS, lineToStart, Integer.MAX_VALUE);
    }

    public LineStartingScope getNextLineThatStartsScope(String[] indentTokens, int lineToStart, int mustHaveIndentLowerThan) {
        return this.getLineThatStartsScope(true, indentTokens, lineToStart, mustHaveIndentLowerThan);
    }

    public LineStartingScope getPreviousLineThatStartsScope(String[] indentTokens, int lineToStart, int mustHaveIndentLowerThan) {
        return this.getLineThatStartsScope(false, indentTokens, lineToStart, mustHaveIndentLowerThan);
    }

    public LineStartingScope getLineThatStartsScope(boolean forward, String[] indentTokens, int lineToStart, int mustHaveIndentLowerThan) {
        DocIterator iterator = lineToStart == -1 ? new DocIterator(forward, this) : new DocIterator(forward, this, lineToStart, false);
        String foundDedent = null;
        String lowestStr = null;
        while (iterator.hasNext()) {
            int firstCharPosition;
            if (mustHaveIndentLowerThan == 0) {
                return null;
            }
            String line = iterator.next();
            String trimmed = line.trim();
            String[] stringArray = indentTokens;
            int n = indentTokens.length;
            int n2 = 0;
            while (n2 < n) {
                String dedent = stringArray[n2];
                if (trimmed.startsWith(dedent) && PySelection.isCompleteToken(trimmed, dedent)) {
                    if (PySelection.getFirstCharPosition(line) >= mustHaveIndentLowerThan) break;
                    return new LineStartingScope(line, foundDedent, lowestStr, iterator.getLastReturnedLine());
                }
                ++n2;
            }
            if (lowestStr == null && foundDedent == null && PySelection.startsWithDedentToken(trimmed)) {
                foundDedent = line;
                continue;
            }
            if (foundDedent != null || trimmed.length() <= 0 || (firstCharPosition = PySelection.getFirstCharPosition(line)) >= mustHaveIndentLowerThan) continue;
            mustHaveIndentLowerThan = firstCharPosition;
            lowestStr = line;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static int eatFuncCall(IDocument theDoc, int documentOffset) throws BadLocationException {
        c = theDoc.get(documentOffset, 1);
        if (c.equals(")")) ** GOTO lbl5
        throw new AssertionError((Object)new StringBuffer("Expecting ) to eat callable. Received: ").append(c).toString());
lbl-1000:
        // 1 sources

        {
            --documentOffset;
lbl5:
            // 2 sources

            ** while (documentOffset > 0 && !theDoc.get((int)documentOffset, (int)1).equals((Object)"("))
        }
lbl6:
        // 1 sources

        return documentOffset;
    }

    public static boolean endsWithSomeChar(char[] cs, String activationToken) {
        int i = 0;
        while (i < cs.length) {
            if (activationToken.endsWith(new StringBuffer(String.valueOf(cs[i])).toString())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static List<Integer> getLineStartOffsets(String replacementString) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        ret.add(Autobox.valueOf((int)0));
        int i = 0;
        while (i < replacementString.length()) {
            char c = replacementString.charAt(i);
            if (c == '\r') {
                int foundAt = ++i;
                if (i < replacementString.length() && (c = replacementString.charAt(i)) == '\n') {
                    foundAt = i + 1;
                }
                ret.add(Autobox.valueOf((int)foundAt));
            } else if (c == '\n') {
                ret.add(Autobox.valueOf((int)(i + 1)));
            }
            ++i;
        }
        return ret;
    }

    public static List<Integer> getLineBreakOffsets(String replacementString) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int lineBreaks = 0;
        int ignoreNextNAt = -1;
        int i = 0;
        while (i < replacementString.length()) {
            char c = replacementString.charAt(i);
            if (c == '\r') {
                ++lineBreaks;
                ret.add(Autobox.valueOf((int)i));
                ignoreNextNAt = i + 1;
            } else if (c == '\n' && ignoreNextNAt != i) {
                ret.add(Autobox.valueOf((int)i));
                ++lineBreaks;
            }
            ++i;
        }
        return ret;
    }

    public static int countLineBreaks(String replacementString) {
        int lineBreaks = 0;
        int ignoreNextNAt = -1;
        int i = 0;
        while (i < replacementString.length()) {
            char c = replacementString.charAt(i);
            if (c == '\r') {
                ++lineBreaks;
                ignoreNextNAt = i + 1;
            } else if (c == '\n' && ignoreNextNAt != i) {
                ++lineBreaks;
            }
            ++i;
        }
        return lineBreaks;
    }

    public String[] getActivationTokenAndQual(boolean getFullQualifier) {
        return PySelection.getActivationTokenAndQual(this.doc, this.getAbsoluteCursorOffset(), getFullQualifier);
    }

    public ActivationTokenAndQual getActivationTokenAndQual(boolean getFullQualifier, boolean handleForCalltips) {
        return PySelection.getActivationTokenAndQual(this.doc, this.getAbsoluteCursorOffset(), getFullQualifier, handleForCalltips);
    }

    public static String[] getActivationTokenAndQual(IDocument theDoc, int documentOffset, boolean getFullQualifier) {
        ActivationTokenAndQual ret = PySelection.getActivationTokenAndQual(theDoc, documentOffset, getFullQualifier, false);
        return new String[]{ret.activationToken, ret.qualifier};
    }

    public static ActivationTokenAndQual getActivationTokenAndQual(IDocument doc, int documentOffset, boolean getFullQualifier, boolean handleForCalltips) {
        int foundCalltipOffset;
        int offsetForKeywordParam;
        boolean isInMethodKeywordParam;
        boolean alreadyHasParams;
        boolean changedForCalltip;
        block33: {
            int calltipOffset;
            changedForCalltip = false;
            alreadyHasParams = false;
            int parOffset = -1;
            isInMethodKeywordParam = false;
            offsetForKeywordParam = -1;
            foundCalltipOffset = -1;
            if (handleForCalltips && (calltipOffset = documentOffset - 1) > 0 && calltipOffset < doc.getLength()) {
                try {
                    char c = doc.getChar(calltipOffset);
                    while (Character.isWhitespace(c) && calltipOffset > 0) {
                        c = doc.getChar(--calltipOffset);
                    }
                    if (c == '(' || c == ',') {
                        parOffset = calltipOffset;
                        if ((calltipOffset = PySelection.getBeforeParentesisCall(doc, calltipOffset)) != -1) {
                            documentOffset = calltipOffset;
                            changedForCalltip = true;
                            foundCalltipOffset = PySelection.calculateProperCalltipOffset(doc, calltipOffset);
                        }
                    } else {
                        c = doc.getChar(calltipOffset);
                        while ((Character.isJavaIdentifierPart(c) || Character.isWhitespace(c)) && calltipOffset > 0) {
                            c = doc.getChar(--calltipOffset);
                        }
                        if ((c == '(' || c == ',') && (calltipOffset = PySelection.getBeforeParentesisCall(doc, calltipOffset)) != -1) {
                            offsetForKeywordParam = calltipOffset;
                            isInMethodKeywordParam = true;
                            foundCalltipOffset = PySelection.calculateProperCalltipOffset(doc, calltipOffset);
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new RuntimeException(e);
                }
            }
            if (parOffset != -1) {
                try {
                    char c = doc.getChar(parOffset);
                    if (c == '(') {
                        ++parOffset;
                        while (parOffset < doc.getLength()) {
                            c = doc.getChar(parOffset);
                            if (c == ')') break block33;
                            if (!Character.isWhitespace(c)) {
                                alreadyHasParams = true;
                                break block33;
                            }
                            ++parOffset;
                        }
                        break block33;
                    }
                    alreadyHasParams = true;
                }
                catch (BadLocationException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        Tuple<String, Integer> tupPrefix = PySelection.extractActivationToken(doc, documentOffset, getFullQualifier);
        if (getFullQualifier) {
            documentOffset = (Integer)tupPrefix.o2;
        }
        String activationToken = (String)tupPrefix.o1;
        documentOffset = documentOffset - activationToken.length() - 1;
        try {
            while (documentOffset >= 0 && documentOffset < doc.getLength() && doc.get(documentOffset, 1).equals(".")) {
                String tok = (String)PySelection.extractActivationToken((IDocument)doc, (int)documentOffset, (boolean)false).o1;
                String c = doc.get(documentOffset - 1, 1);
                if (c.equals("]")) {
                    int docOff = documentOffset;
                    while (docOff > 0 && !doc.get(docOff, 1).equals("[")) {
                        --docOff;
                    }
                    tok = (String)PySelection.extractActivationToken((IDocument)doc, (int)docOff, (boolean)false).o1;
                    if (tok.length() > 0) {
                        activationToken = new StringBuffer(String.valueOf(tok)).append(".__getitem__().").append(activationToken).toString();
                        documentOffset = docOff - tok.length() - 1;
                    } else {
                        activationToken = new StringBuffer("list.").append(activationToken).toString();
                    }
                } else if (c.equals("}")) {
                    activationToken = new StringBuffer("dict.").append(activationToken).toString();
                } else if (c.equals("'") || c.equals("\"")) {
                    activationToken = new StringBuffer("str.").append(activationToken).toString();
                } else {
                    if (c.equals(")")) {
                        documentOffset = PySelection.eatFuncCall(doc, documentOffset - 1);
                        tok = (String)PySelection.extractActivationToken((IDocument)doc, (int)documentOffset, (boolean)false).o1;
                        activationToken = new StringBuffer(String.valueOf(tok)).append("().").append(activationToken).toString();
                        documentOffset = documentOffset - tok.length() - 1;
                        continue;
                    }
                    if (tok.length() > 0) {
                        activationToken = new StringBuffer(String.valueOf(tok)).append(".").append(activationToken).toString();
                        documentOffset = documentOffset - tok.length() - 1;
                        continue;
                    }
                }
                break;
            }
        }
        catch (BadLocationException e) {
            System.out.println(new StringBuffer("documentOffset ").append(documentOffset).toString());
            System.out.println(new StringBuffer("theDoc.getLength() ").append(doc.getLength()).toString());
            e.printStackTrace();
        }
        String qualifier = "";
        if (activationToken.indexOf(46) != -1) {
            while (!PySelection.endsWithSomeChar(new char[]{'.', '['}, activationToken) && activationToken.length() > 0) {
                qualifier = new StringBuffer(String.valueOf(activationToken.charAt(activationToken.length() - 1))).append(qualifier).toString();
                activationToken = activationToken.substring(0, activationToken.length() - 1);
            }
        } else {
            qualifier = activationToken.trim();
            activationToken = "";
        }
        return new ActivationTokenAndQual(activationToken, qualifier, changedForCalltip, alreadyHasParams, isInMethodKeywordParam, offsetForKeywordParam, foundCalltipOffset);
    }

    private static int calculateProperCalltipOffset(IDocument doc, int calltipOffset) {
        try {
            char c = doc.getChar(calltipOffset);
            while (c != '(') {
                c = doc.getChar(++calltipOffset);
            }
            return ++calltipOffset;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public static int getBeforeParentesisCall(Object doc, int calltipOffset) {
        ParsingUtils parsingUtils = ParsingUtils.create(doc);
        char c = parsingUtils.charAt(calltipOffset);
        while (calltipOffset > 0 && c != '(') {
            c = parsingUtils.charAt(--calltipOffset);
        }
        if (c == '(') {
            while (calltipOffset > 0 && Character.isWhitespace(c)) {
                c = parsingUtils.charAt(--calltipOffset);
            }
            return calltipOffset;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Tuple<String, Integer> extractActivationToken(IDocument document, int offset, boolean getFullQualifier) {
        try {
            int i;
            if (getFullQualifier) {
                char ch;
                while (offset < document.getLength() && Character.isJavaIdentifierPart(ch = document.getChar(offset))) {
                    ++offset;
                }
            }
            if ((i = offset) > document.getLength()) {
                return new Tuple<String, Integer>("", Autobox.valueOf((int)document.getLength()));
            }
            while (true) {
                if (i <= 0) {
                    return new Tuple<String, Integer>(document.get(i, offset - i), Autobox.valueOf((int)offset));
                }
                char ch = document.getChar(i - 1);
                if (!Character.isJavaIdentifierPart(ch)) {
                    return new Tuple<String, Integer>(document.get(i, offset - i), Autobox.valueOf((int)offset));
                }
                --i;
            }
        }
        catch (BadLocationException badLocationException) {
            return new Tuple<String, Integer>("", Autobox.valueOf((int)offset));
        }
    }

    public static boolean containsOnly(char c, String string) {
        int i = 0;
        while (i < string.length()) {
            if (string.charAt(i) != c) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean containsOnlyWhitespaces(String string) {
        int i = 0;
        while (i < string.length()) {
            if (!Character.isWhitespace(string.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getIndentationFromLine(String selection) {
        int firstCharPosition = PySelection.getFirstCharPosition(selection);
        return selection.substring(0, firstCharPosition);
    }

    public String getIndentationFromLine() {
        return PySelection.getIndentationFromLine(this.getCursorLineContents());
    }

    public static int getFirstCharPosition(String src) {
        int i = 0;
        boolean breaked = false;
        while (i < src.length()) {
            if (!Character.isWhitespace(src.charAt(i)) && src.charAt(i) != '\t') {
                ++i;
                breaked = true;
                break;
            }
            ++i;
        }
        if (!breaked) {
            ++i;
        }
        return i - 1;
    }

    public static int getFirstCharRelativePosition(IDocument doc, IRegion region) throws BadLocationException {
        int offset = region.getOffset();
        String src = doc.get(offset, region.getLength());
        return PySelection.getFirstCharPosition(src);
    }

    public static int getFirstCharRelativeLinePosition(IDocument doc, int line) throws BadLocationException {
        IRegion region = doc.getLineInformation(line);
        return PySelection.getFirstCharRelativePosition(doc, region);
    }

    public static int getFirstCharRelativePosition(IDocument doc, int cursorOffset) throws BadLocationException {
        IRegion region = doc.getLineInformationOfOffset(cursorOffset);
        return PySelection.getFirstCharRelativePosition(doc, region);
    }

    public static int getFirstCharPosition(IDocument doc, int cursorOffset) throws BadLocationException {
        IRegion region = doc.getLineInformationOfOffset(cursorOffset);
        int offset = region.getOffset();
        return offset + PySelection.getFirstCharRelativePosition(doc, cursorOffset);
    }

    public static boolean startsWithDedentToken(String trimmedLine) {
        String[] stringArray = DEDENT_TOKENS;
        int n = DEDENT_TOKENS.length;
        int n2 = 0;
        while (n2 < n) {
            String dedent = stringArray[n2];
            if (trimmedLine.startsWith(dedent)) {
                return PySelection.isCompleteToken(trimmedLine, dedent);
            }
            ++n2;
        }
        return false;
    }

    private static boolean isCompleteToken(String trimmedLine, String dedent) {
        if (dedent.length() < trimmedLine.length()) {
            char afterToken = trimmedLine.charAt(dedent.length());
            return afterToken == ' ' || afterToken == ':' || afterToken == ';' || afterToken == '(';
        }
        return true;
    }

    public static boolean isInside(int offset, IRegion region) {
        return offset >= region.getOffset() && offset <= region.getOffset() + region.getLength();
    }

    public static boolean isInside(int col, int initialCol, int len) {
        return col >= initialCol && col <= initialCol + len;
    }

    public static boolean endsInSameLine(IDocument document, IRegion region) {
        try {
            int startLine = document.getLineOfOffset(region.getOffset());
            int end = region.getOffset() + region.getLength();
            int endLine = document.getLineOfOffset(end);
            return startLine == endLine;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public Tuple<Integer, Integer> getLineAndCol(int offset) {
        try {
            IRegion region = this.doc.getLineInformationOfOffset(offset);
            int line = this.doc.getLineOfOffset(offset);
            int col = offset - region.getOffset();
            return new Tuple<Integer, Integer>(Autobox.valueOf((int)line), Autobox.valueOf((int)col));
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public String getToColon() {
        StringBuffer buffer = new StringBuffer();
        int i = this.getLineOffset();
        while (i < this.doc.getLength()) {
            try {
                char c = this.doc.getChar(i);
                buffer.append(c);
                if (c == ':') {
                    return buffer.toString();
                }
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
            ++i;
        }
        return "";
    }

    public boolean isInFunctionLine(boolean matchOnlyComplete) {
        String line = !matchOnlyComplete ? this.getLine() : this.getToColon();
        return this.matchesFunctionLine(line);
    }

    public boolean matchesFunctionLine(String line) {
        return FunctionPattern.matcher(line.trim()).matches();
    }

    public static boolean isIdentifier(String str) {
        return IdentifierPattern.matcher(str).matches();
    }

    public boolean isInClassLine() {
        String line = this.getLine().trim();
        return ClassPattern.matcher(line).matches();
    }

    public static boolean isCommentLine(String line) {
        int j = 0;
        while (j < line.length()) {
            char c = line.charAt(j);
            if (c != ' ' && c == '#') {
                return true;
            }
            ++j;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int isInDeclarationLine() {
        try {
            String contents = this.getLineContentsToCursor();
            StringTokenizer strTok = new StringTokenizer(contents);
            if (!strTok.hasMoreTokens()) return 0;
            String tok = strTok.nextToken();
            int decl = DECLARATION_NONE;
            if (tok.equals("class")) {
                decl = DECLARATION_CLASS;
            } else if (tok.equals("def")) {
                decl = DECLARATION_METHOD;
            }
            if (decl == DECLARATION_NONE) return 0;
            do {
                if (!strTok.hasMoreTokens()) {
                    return decl;
                }
                tok = strTok.nextToken();
                if (tok.indexOf(40) != -1) return 0;
            } while (tok.indexOf(58) == -1);
            return 0;
        }
        catch (BadLocationException badLocationException) {}
        return 0;
    }

    public IRegion getRegion() {
        return new Region(this.textSelection.getOffset(), this.textSelection.getLength());
    }

    public static class ActivationTokenAndQual {
        public final String activationToken;
        public final String qualifier;
        public final boolean changedForCalltip;
        public final boolean alreadyHasParams;
        public final boolean isInMethodKeywordParam;
        public final int offsetForKeywordParam;
        public final int calltipOffset;

        public ActivationTokenAndQual(String activationToken, String qualifier, boolean changedForCalltip, boolean alreadyHasParams, boolean isInMethodKeywordParam, int offsetForKeywordParam, int calltipOffset) {
            this.activationToken = activationToken;
            this.qualifier = qualifier;
            this.changedForCalltip = changedForCalltip;
            this.alreadyHasParams = alreadyHasParams;
            this.isInMethodKeywordParam = isInMethodKeywordParam;
            this.offsetForKeywordParam = offsetForKeywordParam;
            this.calltipOffset = calltipOffset;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DocIterator
    implements Iterator<String> {
        private int startingLine;
        private boolean forward;
        private boolean isFirst = true;
        private int numberOfLines;
        private int lastReturnedLine = -1;
        private PySelection ps;

        public DocIterator(boolean forward, PySelection ps) {
            this(forward, ps, ps.getCursorLine(), true);
        }

        public DocIterator(boolean forward, PySelection ps, int startingLine, boolean considerFirst) {
            this.startingLine = startingLine;
            this.forward = forward;
            this.numberOfLines = ps.getDoc().getNumberOfLines();
            this.ps = ps;
            if (!considerFirst) {
                this.isFirst = false;
            }
        }

        public int getCurrentLine() {
            return this.startingLine;
        }

        @Override
        public boolean hasNext() {
            if (this.forward) {
                return this.startingLine < this.numberOfLines;
            }
            return this.startingLine >= 0;
        }

        @Override
        public String next() {
            try {
                String line;
                if (this.forward) {
                    line = this.ps.getLine(this.startingLine);
                    this.lastReturnedLine = this.startingLine++;
                } else {
                    if (this.isFirst) {
                        line = this.ps.getLineContentsToCursor();
                        this.isFirst = false;
                    } else {
                        line = this.ps.getLine(this.startingLine);
                    }
                    this.lastReturnedLine = this.startingLine--;
                }
                return line;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new RuntimeException("Remove not implemented.");
        }

        public int getLastReturnedLine() {
            return this.lastReturnedLine;
        }

        @Override
        public /* synthetic */ Object next() {
            return this.next();
        }
    }

    public static class LineStartingScope {
        public final String lineStartingScope;
        public final String lineWithDedentWhileLookingScope;
        public final String lineWithLowestIndent;
        public final int iLineStartingScope;

        public LineStartingScope(String lineStartingScope, String lineWithDedentWhileLookingScope, String lineWithLowestIndent, int iLineStartingScope) {
            this.lineStartingScope = lineStartingScope;
            this.lineWithDedentWhileLookingScope = lineWithDedentWhileLookingScope;
            this.lineWithLowestIndent = lineWithLowestIndent;
            this.iLineStartingScope = iLineStartingScope;
        }
    }
}

