/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis;

import com.python.pydev.analysis.IAnalysisPreferences;
import com.python.pydev.analysis.IAnalyzer;
import com.python.pydev.analysis.messages.IMessage;
import com.python.pydev.analysis.tabnanny.TabNanny;
import com.python.pydev.analysis.visitors.OccurrencesVisitor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.IIndentPrefs;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.editor.autoedit.DefaultIndentPrefs;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.plugin.PydevPlugin;

public class OccurrencesAnalyzer
implements IAnalyzer {
    public IMessage[] analyzeDocument(IPythonNature nature, SourceModule module, IAnalysisPreferences prefs, IDocument document) {
        return this.analyzeDocument(nature, module, prefs, document, (IProgressMonitor)new NullProgressMonitor());
    }

    public IMessage[] analyzeDocument(IPythonNature nature, SourceModule module, IAnalysisPreferences prefs, IDocument document, IProgressMonitor monitor) {
        return this.analyzeDocument(nature, module, prefs, document, monitor, DefaultIndentPrefs.get());
    }

    public IMessage[] analyzeDocument(IPythonNature nature, SourceModule module, IAnalysisPreferences prefs, IDocument document, IProgressMonitor monitor, IIndentPrefs indentPrefs) {
        OccurrencesVisitor visitor;
        block9: {
            visitor = new OccurrencesVisitor(nature, module.getName(), (IModule)module, prefs, document, monitor);
            try {
                SimpleNode ast = module.getAst();
                if (ast == null) break block9;
                nature.startRequests();
                try {
                    ast.accept((VisitorIF)visitor);
                }
                finally {
                    nature.endRequests();
                }
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                PydevPlugin.log((int)4, (String)("Error while visiting " + module.getName() + " (" + module.getFile() + ")"), (Throwable)e);
            }
        }
        List<Object> messages = new ArrayList();
        if (!monitor.isCanceled()) {
            messages = visitor.getMessages();
            try {
                messages.addAll(TabNanny.analyzeDoc(document, prefs, module.getName(), indentPrefs, monitor));
            }
            catch (Exception e) {
                PydevPlugin.log((Throwable)e);
            }
        }
        return messages.toArray(new IMessage[messages.size()]);
    }
}

