/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.event;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolox.nodes.PStyledText;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class PStyledTextEventHandler
extends PBasicInputEventHandler {
    protected PCanvas canvas;
    protected JTextComponent editor;
    protected DocumentListener docListener;
    protected PStyledText editedText;

    public PStyledTextEventHandler(PCanvas canvas) {
        this.canvas = canvas;
        this.initEditor(this.createDefaultEditor());
    }

    public PStyledTextEventHandler(PCanvas canvas, JTextComponent editor) {
        this.canvas = canvas;
        this.initEditor(editor);
    }

    protected void initEditor(JTextComponent newEditor) {
        this.editor = newEditor;
        this.canvas.setLayout(null);
        this.canvas.add(this.editor);
        this.editor.setVisible(false);
        this.docListener = this.createDocumentListener();
    }

    protected JTextComponent createDefaultEditor() {
        JTextPane tComp = new JTextPane(){

            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
                super.paint(g);
            }

            public void scrollRectToVisible() {
            }
        };
        tComp.setBorder(new CompoundBorder(new LineBorder(Color.black), new EmptyBorder(3, 3, 3, 3)));
        return tComp;
    }

    protected DocumentListener createDocumentListener() {
        return new DocumentListener(){

            public void removeUpdate(DocumentEvent e) {
                PStyledTextEventHandler.this.reshapeEditorLater();
            }

            public void insertUpdate(DocumentEvent e) {
                PStyledTextEventHandler.this.reshapeEditorLater();
            }

            public void changedUpdate(DocumentEvent e) {
                PStyledTextEventHandler.this.reshapeEditorLater();
            }
        };
    }

    public PStyledText createText() {
        PStyledText newText = new PStyledText();
        Document doc = this.editor.getUI().getEditorKit(this.editor).createDefaultDocument();
        if (!(!(doc instanceof StyledDocument) || doc.getDefaultRootElement().getAttributes().isDefined(StyleConstants.FontFamily) && doc.getDefaultRootElement().getAttributes().isDefined(StyleConstants.FontSize))) {
            Font eFont = this.editor.getFont();
            SimpleAttributeSet sas = new SimpleAttributeSet();
            sas.addAttribute(StyleConstants.FontFamily, eFont.getFamily());
            sas.addAttribute(StyleConstants.FontSize, new Integer(eFont.getSize()));
            ((StyledDocument)doc).setParagraphAttributes(0, doc.getLength(), sas, false);
        }
        newText.setDocument(doc);
        return newText;
    }

    public void mousePressed(PInputEvent inputEvent) {
        PNode pickedNode = inputEvent.getPickedNode();
        this.stopEditing();
        if (pickedNode instanceof PStyledText) {
            this.startEditing(inputEvent, (PStyledText)pickedNode);
        } else if (pickedNode instanceof PCamera) {
            PStyledText newText = this.createText();
            Insets pInsets = newText.getInsets();
            this.canvas.getLayer().addChild(newText);
            newText.translate(inputEvent.getPosition().getX() - (double)pInsets.left, inputEvent.getPosition().getY() - (double)pInsets.top);
            this.startEditing(inputEvent, newText);
        }
    }

    public void startEditing(PInputEvent event, PStyledText text) {
        Insets pInsets = text.getInsets();
        Point2D.Double nodePt = new Point2D.Double(text.getX() + (double)pInsets.left, text.getY() + (double)pInsets.top);
        text.localToGlobal(nodePt);
        event.getTopCamera().viewToLocal(nodePt);
        this.editor.setDocument(text.getDocument());
        this.editor.setVisible(true);
        Insets bInsets = this.editor.getBorder().getBorderInsets(this.editor);
        this.editor.setLocation((int)((Point2D)nodePt).getX() - bInsets.left, (int)((Point2D)nodePt).getY() - bInsets.top);
        this.reshapeEditorLater();
        this.dispatchEventToEditor(event);
        this.canvas.repaint();
        text.setEditing(true);
        text.getDocument().addDocumentListener(this.docListener);
        this.editedText = text;
    }

    public void stopEditing() {
        if (this.editedText != null) {
            this.editedText.getDocument().removeDocumentListener(this.docListener);
            this.editedText.setEditing(false);
            if (this.editedText.getDocument().getLength() == 0) {
                this.editedText.removeFromParent();
            } else {
                this.editedText.syncWithDocument();
            }
            this.editor.setVisible(false);
            this.canvas.repaint();
            this.editedText = null;
        }
    }

    public void dispatchEventToEditor(final PInputEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MouseEvent me = new MouseEvent((this).PStyledTextEventHandler.this.editor, 501, e.getWhen(), e.getModifiers() | 0x10, (int)(e.getCanvasPosition().getX() - (double)(this).PStyledTextEventHandler.this.editor.getX()), (int)(e.getCanvasPosition().getY() - (double)(this).PStyledTextEventHandler.this.editor.getY()), 1, false);
                        (this).PStyledTextEventHandler.this.editor.dispatchEvent(me);
                    }
                });
            }
        });
    }

    public void reshapeEditor() {
        if (this.editedText != null) {
            Dimension prefSize = this.editor.getPreferredSize();
            Insets pInsets = this.editedText.getInsets();
            Insets jInsets = this.editor.getInsets();
            int width = this.editedText.getConstrainWidthToTextWidth() ? (int)prefSize.getWidth() : (int)(this.editedText.getWidth() - (double)pInsets.left - (double)pInsets.right + (double)jInsets.left + (double)jInsets.right + 3.0);
            prefSize.setSize((double)width, prefSize.getHeight());
            this.editor.setSize(prefSize);
            prefSize = this.editor.getPreferredSize();
            int height = this.editedText.getConstrainHeightToTextHeight() ? (int)prefSize.getHeight() : (int)(this.editedText.getHeight() - (double)pInsets.top - (double)pInsets.bottom + (double)jInsets.top + (double)jInsets.bottom + 3.0);
            prefSize.setSize(width, height);
            this.editor.setSize(prefSize);
        }
    }

    protected void reshapeEditorLater() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PStyledTextEventHandler.this.reshapeEditor();
            }
        });
    }
}

