/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.prettyprinterv2;

import com.rc.retroweaver.runtime.Autobox;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IIndentPrefs;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.Tuple;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.parser.prettyprinterv2.ILinePart;
import org.python.pydev.parser.prettyprinterv2.ILinePart2;
import org.python.pydev.parser.prettyprinterv2.ILinePartIndentMark;
import org.python.pydev.parser.prettyprinterv2.ILinePartStatementMark;
import org.python.pydev.parser.prettyprinterv2.IPrettyPrinterPrefs;
import org.python.pydev.parser.prettyprinterv2.LinePartRequireMark;
import org.python.pydev.parser.prettyprinterv2.PrettyPrinterDocLineEntry;
import org.python.pydev.parser.prettyprinterv2.PrettyPrinterDocV2;
import org.python.pydev.parser.prettyprinterv2.PrettyPrinterPrefsV2;
import org.python.pydev.parser.prettyprinterv2.PrettyPrinterVisitorV2;
import org.python.pydev.parser.prettyprinterv2.WriteStateV2;
import org.python.pydev.parser.prettyprinterv2.WriterEraserV2;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrettyPrinterV2 {
    private IPrettyPrinterPrefs prefs;
    private final int LEVEL_PARENS = 0;
    private final int LEVEL_BRACKETS = 1;
    private final int LEVEL_BRACES = 2;
    private final int[] LEVELS = new int[3];
    private int statementLevel = 0;
    WriterEraserV2 writerEraserV2;
    WriteStateV2 writeStateV2;
    Set<Map.Entry<Integer, PrettyPrinterDocLineEntry>> entrySet;
    List<Tuple<PrettyPrinterDocLineEntry, String>> previousLines;
    List<LinePartRequireMark> requireMarks = new ArrayList<LinePartRequireMark>();
    boolean lastWasComment;
    boolean writtenComment;
    boolean savedLineIndent;
    int indentDiff;

    public static PrettyPrinterPrefsV2 createDefaultPrefs(IGrammarVersionProvider versionProvider, IIndentPrefs indentPrefs, String endLineDelim) {
        if (versionProvider == null) {
            versionProvider = new IGrammarVersionProvider(){

                public int getGrammarVersion() throws MisconfigurationException {
                    return 13;
                }
            };
        }
        PrettyPrinterPrefsV2 prettyPrinterPrefs = new PrettyPrinterPrefsV2(endLineDelim, indentPrefs.getIndentationString(), versionProvider);
        prettyPrinterPrefs.setSpacesAfterComma(1);
        prettyPrinterPrefs.setSpacesBeforeComment(1);
        prettyPrinterPrefs.setLinesAfterMethod(1);
        prettyPrinterPrefs.setLinesAfterClass(2);
        prettyPrinterPrefs.setLinesAfterSuite(1);
        return prettyPrinterPrefs;
    }

    public PrettyPrinterV2(IPrettyPrinterPrefs prefs) {
        this.prefs = prefs;
    }

    public String print(SimpleNode ast) throws IOException {
        PrettyPrinterDocV2 doc = new PrettyPrinterDocV2();
        PrettyPrinterVisitorV2 visitor = new PrettyPrinterVisitorV2(this.prefs, doc);
        try {
            visitor.visitNode(ast);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.writerEraserV2 = new WriterEraserV2();
        this.writeStateV2 = new WriteStateV2(this.writerEraserV2, this.prefs);
        this.entrySet = doc.linesToColAndContents.entrySet();
        this.previousLines = new ArrayList<Tuple<PrettyPrinterDocLineEntry, String>>();
        doc.validateRequireMarks();
        ArrayList<Tuple<ILinePart, PrettyPrinterDocLineEntry>> commentsSkipped = new ArrayList<Tuple<ILinePart, PrettyPrinterDocLineEntry>>();
        for (Map.Entry<Integer, PrettyPrinterDocLineEntry> entry : this.entrySet) {
            Object indentWritten;
            ILinePart linePart;
            PrettyPrinterDocLineEntry line = entry.getValue();
            List<ILinePart> sortedParts = line.getSortedParts();
            this.indentDiff = line.getIndentDiff();
            this.savedLineIndent = false;
            List<ILinePart2> sortedPartsWithILinePart2 = this.getLineParts2(sortedParts);
            this.lastWasComment = false;
            this.writtenComment = false;
            if (sortedParts.size() == 0) continue;
            if (sortedPartsWithILinePart2.size() == 1 && (linePart = (ILinePart)sortedPartsWithILinePart2.get(0)).getToken() instanceof commentType && linePart instanceof ILinePart2 && (indentWritten = this.handleSingleLineComment((ILinePart2)linePart, line, commentsSkipped)) != null) {
                this.saveLineIndent(line, (String)indentWritten);
            }
            indentWritten = sortedParts.iterator();
            while (indentWritten.hasNext()) {
                linePart = indentWritten.next();
                this.writeLinePart(linePart, commentsSkipped, line);
            }
            if (!this.savedLineIndent) {
                this.saveLineIndent(line);
            }
            if (this.statementLevel != 0 && !this.lastWasComment && !this.isInLevel()) continue;
            this.writeStateV2.writeNewLine();
            int newLinesRequired = line.getNewLinesRequired();
            if (newLinesRequired == 0) continue;
            int i = 0;
            while (i < newLinesRequired) {
                this.writeStateV2.writeNewLine();
                ++i;
            }
        }
        return this.writerEraserV2.getBuffer().toString();
    }

    private void saveLineIndent(PrettyPrinterDocLineEntry line) {
        this.savedLineIndent = true;
        this.previousLines.add((Tuple<PrettyPrinterDocLineEntry, String>)new Tuple((Object)line, (Object)this.writeStateV2.getIndentString()));
    }

    private void saveLineIndent(PrettyPrinterDocLineEntry line, String indentWritten) {
        this.savedLineIndent = true;
        this.previousLines.add((Tuple<PrettyPrinterDocLineEntry, String>)new Tuple((Object)line, (Object)indentWritten));
    }

    private void writeLinePart(ILinePart linePart, List<Tuple<ILinePart, PrettyPrinterDocLineEntry>> commentsSkipped, PrettyPrinterDocLineEntry line) throws IOException {
        boolean isSlash = false;
        if (linePart instanceof ILinePart2 && !this.writtenComment) {
            Tuple<Integer, Boolean> newLevel;
            String tok = ((ILinePart2)linePart).getString();
            if (tok.charAt(0) == ';') {
                this.writeStateV2.writeNewLine();
                this.savedLineIndent = true;
                return;
            }
            if (tok.charAt(0) == '\\') {
                if (this.isInLevel()) {
                    this.savedLineIndent = true;
                    return;
                }
                isSlash = true;
            } else if (tok.charAt(0) == '@') {
                this.writeStateV2.requireNextNewLine();
            }
            if (linePart.getToken() instanceof commentType) {
                if (this.statementLevel > 0 && !this.isInLevel()) {
                    commentsSkipped.add((Tuple<ILinePart, PrettyPrinterDocLineEntry>)new Tuple((Object)linePart, (Object)line));
                    this.savedLineIndent = true;
                    return;
                }
                this.writeStateV2.writeSpacesBeforeComment();
            }
            boolean written = false;
            if (tok.length() == 1 && (newLevel = this.updateLevels(tok)) != null) {
                if (!this.savedLineIndent) {
                    this.saveLineIndent(line);
                }
                if (((Boolean)newLevel.o2).booleanValue()) {
                    this.writeStateV2.write(this.prefs.getReplacement(tok));
                    this.writeStateV2.indent();
                    written = true;
                } else {
                    if (this.indentDiff == 0) {
                        this.writeStateV2.dedent();
                    }
                    this.writeStateV2.write(this.prefs.getReplacement(tok));
                    if (this.indentDiff != 0) {
                        this.writeStateV2.dedent();
                    }
                    written = true;
                }
            }
            if (!written) {
                written = true;
                this.writeStateV2.write(this.prefs.getReplacement(tok));
            }
            if (isSlash) {
                this.writeStateV2.writeNewLine();
            }
            if (linePart.getToken() instanceof commentType) {
                this.writeStateV2.requireNextNewLine();
                this.lastWasComment = true;
            } else {
                this.lastWasComment = false;
            }
        } else if (linePart instanceof ILinePartIndentMark) {
            ILinePartIndentMark indentMark = (ILinePartIndentMark)linePart;
            if (!this.savedLineIndent) {
                this.saveLineIndent(line);
            }
            if (indentMark.isIndent()) {
                if (indentMark.getRequireNewLineOnIndent()) {
                    this.writeStateV2.requireNextNewLineOrComment();
                }
                this.writeStateV2.indent();
                --this.indentDiff;
            } else {
                this.writeStateV2.dedent();
                ++this.indentDiff;
            }
        } else if (linePart instanceof ILinePartStatementMark) {
            ILinePartStatementMark statementMark = (ILinePartStatementMark)((Object)linePart);
            if (statementMark.isStart()) {
                if (this.statementLevel == 0) {
                    this.writeStateV2.requireNextNewLineOrComment();
                }
                ++this.statementLevel;
            } else {
                --this.statementLevel;
            }
        }
        if ((this.statementLevel == 0 || this.isInLevel()) && commentsSkipped != null && commentsSkipped.size() > 0) {
            this.savedLineIndent = true;
            for (Tuple<ILinePart, PrettyPrinterDocLineEntry> tup : commentsSkipped) {
                this.writeLinePart((ILinePart)tup.o1, null, (PrettyPrinterDocLineEntry)tup.o2);
            }
            commentsSkipped.clear();
        }
    }

    private List<ILinePart2> getLineParts2(List<ILinePart> sortedParts) {
        ArrayList<ILinePart2> sortedPartsWithILinePart2 = new ArrayList<ILinePart2>();
        for (ILinePart p : sortedParts) {
            if (!(p instanceof ILinePart2)) continue;
            sortedPartsWithILinePart2.add((ILinePart2)p);
        }
        return sortedPartsWithILinePart2;
    }

    private String handleSingleLineComment(ILinePart2 linePart, PrettyPrinterDocLineEntry line, List<Tuple<ILinePart, PrettyPrinterDocLineEntry>> commentsSkipped) throws IOException {
        String indent = null;
        if (this.statementLevel > 0 && !this.isInLevel()) {
            commentsSkipped.add((Tuple<ILinePart, PrettyPrinterDocLineEntry>)new Tuple((Object)linePart, (Object)line));
            this.savedLineIndent = true;
            this.writtenComment = true;
            return indent;
        }
        ILinePart2 iLinePart2 = linePart;
        commentType commentType2 = (commentType)linePart.getToken();
        int col = commentType2.beginColumn;
        if (col == 1) {
            this.lastWasComment = true;
            this.writtenComment = true;
            this.writeStateV2.writeRaw(iLinePart2.getString());
            indent = "";
        } else {
            Tuple<PrettyPrinterDocLineEntry, String> found = null;
            ListIterator<Tuple<PrettyPrinterDocLineEntry, String>> it = this.previousLines.listIterator(this.previousLines.size());
            while (it.hasPrevious() && found == null) {
                Tuple<PrettyPrinterDocLineEntry, String> previous = it.previous();
                int firstCol = ((PrettyPrinterDocLineEntry)previous.o1).getFirstCol();
                if (firstCol == -1 || firstCol != col) continue;
                found = previous;
            }
            if (found != null) {
                this.lastWasComment = true;
                this.writtenComment = true;
                this.writeStateV2.writeRaw((String)found.o2);
                this.writeStateV2.writeRaw(iLinePart2.getString());
                indent = (String)found.o2;
            }
        }
        return indent;
    }

    private boolean isInLevel() {
        int i = 0;
        while (i < 3) {
            if (this.LEVELS[i] != 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Tuple<Integer, Boolean> updateLevels(String tok) {
        int use = -1;
        boolean increaseLevel = true;
        switch (tok.charAt(0)) {
            case '(': 
            case ')': {
                use = 0;
                break;
            }
            case '[': 
            case ']': {
                use = 1;
                break;
            }
            case '{': 
            case '}': {
                use = 2;
            }
        }
        if (use != -1) {
            switch (tok.charAt(0)) {
                case ')': 
                case ']': 
                case '}': {
                    increaseLevel = false;
                }
            }
            if (increaseLevel) {
                int n = use;
                this.LEVELS[n] = this.LEVELS[n] + 1;
            } else {
                int n = use;
                this.LEVELS[n] = this.LEVELS[n] - 1;
            }
            return new Tuple((Object)Autobox.valueOf((int)this.LEVELS[use]), (Object)Autobox.valueOf((boolean)increaseLevel));
        }
        return null;
    }

    public String toString() {
        return new StringBuffer("PrettyPrinterV2[\n").append(this.writeStateV2).append("\n]").toString();
    }
}

