/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.parser.visitors.scope.DefinitionsASTIteratorVisitor;

public final class ShowOutlineTreeContentProvider
implements ITreeContentProvider {
    private List<ASTEntry> outline;
    private Map<SimpleNode, List<ASTEntry>> objectsWithParentStillNotDeterminedInOutline;
    private final Map<Object, ASTEntry[]> cache = new HashMap<Object, ASTEntry[]>();
    private Object[] elementsForCurrentInput;
    private Object newInput;
    private static final ASTEntry[] EMPTY = new ASTEntry[0];

    public Object[] getChildren(Object element) {
        Object[] ret = this.cache.get(element);
        if (ret != null) {
            return ret;
        }
        ASTEntry entry = (ASTEntry)element;
        if (this.objectsWithParentStillNotDeterminedInOutline != null && (entry.node instanceof ClassDef || entry.node instanceof FunctionDef)) {
            List<ASTEntry> list = this.objectsWithParentStillNotDeterminedInOutline.remove(entry.node);
            Object[] array = EMPTY;
            if (list != null) {
                array = list.toArray(EMPTY);
            }
            this.cache.put(element, (ASTEntry[])array);
            return array;
        }
        return EMPTY;
    }

    public Object getParent(Object element) {
        ASTEntry entry = (ASTEntry)element;
        return entry.parent;
    }

    public boolean hasChildren(Object element) {
        ASTEntry entry = (ASTEntry)element;
        if (entry.node instanceof ClassDef || entry.node instanceof FunctionDef) {
            Object[] children = this.getChildren(entry);
            return children != null && children.length > 0;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (this.newInput == null) {
            this.inputChanged(null, null, inputElement);
        }
        Assert.isTrue((inputElement == this.newInput ? 1 : 0) != 0);
        return this.elementsForCurrentInput == null ? EMPTY : this.elementsForCurrentInput;
    }

    public void dispose() {
        this.outline = null;
        this.objectsWithParentStillNotDeterminedInOutline = null;
        this.cache.clear();
        this.elementsForCurrentInput = null;
        this.newInput = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput == this.newInput) {
            return;
        }
        this.dispose();
        this.newInput = newInput;
        if (newInput == null) {
            return;
        }
        DefinitionsASTIteratorVisitor visitor = DefinitionsASTIteratorVisitor.create((SimpleNode)((SimpleNode)newInput));
        if (visitor == null) {
            this.elementsForCurrentInput = EMPTY;
            return;
        }
        this.outline = new ArrayList<ASTEntry>();
        this.objectsWithParentStillNotDeterminedInOutline = new HashMap<SimpleNode, List<ASTEntry>>();
        Iterator it = visitor.getOutline();
        while (it.hasNext()) {
            ASTEntry next = (ASTEntry)it.next();
            this.outline.add(next);
            if (next.parent == null) continue;
            List<ASTEntry> list = this.objectsWithParentStillNotDeterminedInOutline.get(next.parent.node);
            if (list == null) {
                list = new ArrayList<ASTEntry>();
                this.objectsWithParentStillNotDeterminedInOutline.put(next.parent.node, list);
            }
            list.add(next);
        }
        ArrayList<ASTEntry> list = new ArrayList<ASTEntry>();
        Iterator<ASTEntry> it2 = this.outline.iterator();
        while (it2.hasNext()) {
            ASTEntry next = it2.next();
            if (next.parent != null) continue;
            list.add(next);
        }
        this.elementsForCurrentInput = list.toArray(new ASTEntry[0]);
    }
}

