/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.launching;

import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.ui.launching.LaunchConfigurationCreator;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.ui.dialogs.PythonModulePickerDialog;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLaunchShortcut
implements ILaunchShortcut {
    protected abstract String getLaunchConfigurationType();

    protected abstract IInterpreterManager getInterpreterManager(IProject var1);

    public void launch(ISelection selection, String mode) {
        boolean requireFile = this.getRequireFile();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() == 1) {
                Object object = structuredSelection.getFirstElement();
                if (object instanceof IAdaptable) {
                    IFile resource = (IFile)((IAdaptable)object).getAdapter(ClassLiteral.getClass((String)"org/eclipse/core/resources/IFile"));
                    if (resource != null) {
                        this.launch((IResource)resource, mode);
                        return;
                    }
                    IContainer folder = (IContainer)((IAdaptable)object).getAdapter(ClassLiteral.getClass((String)"org/eclipse/core/resources/IContainer"));
                    if (folder != null) {
                        if (requireFile) {
                            Object[] results;
                            Shell parent;
                            PythonModulePickerDialog dialog;
                            int result;
                            if (folder instanceof IProject && (result = (dialog = new PythonModulePickerDialog(parent = PyAction.getShell(), "Select python file", "Select the python file to be launched.", (IProject)folder)).open()) == 0 && (results = dialog.getResult()) != null && results.length > 0 && results[0] instanceof IFile) {
                                resource = (IResource)results[0];
                            }
                        } else {
                            resource = folder;
                        }
                        if (resource != null) {
                            this.launch((IResource)resource, mode);
                        }
                        return;
                    }
                }
            } else if (structuredSelection.size() > 1) {
                Assert.isTrue((!requireFile ? 1 : 0) != 0);
                ArrayList<Object> sel = new ArrayList<Object>();
                for (Object object : structuredSelection) {
                    if (!(object instanceof IAdaptable)) continue;
                    IContainer folder = (IContainer)((IAdaptable)object).getAdapter(ClassLiteral.getClass((String)"org/eclipse/core/resources/IContainer"));
                    if (folder != null) {
                        sel.add(folder);
                        continue;
                    }
                    IFile file = (IFile)((IAdaptable)object).getAdapter(ClassLiteral.getClass((String)"org/eclipse/core/resources/IFile"));
                    if (file == null) continue;
                    sel.add(file);
                }
                if (sel.size() > 0) {
                    this.launch(sel.toArray(new IResource[sel.size()]), mode);
                }
                return;
            }
            StringBuffer buf = new StringBuffer();
            Iterator it = structuredSelection.iterator();
            while (it.hasNext()) {
                buf.append(it.next());
            }
            AbstractLaunchShortcut.reportError(new StringBuffer("Unable to discover launch config for: ").append((Object)buf).toString(), null);
            return;
        }
        PydevPlugin.log((String)new StringBuffer("Expecting instance of IStructuredSelection. Received: ").append(selection.getClass().getName()).toString());
    }

    protected boolean getRequireFile() {
        return false;
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        IFile file = (IFile)input.getAdapter(ClassLiteral.getClass((String)"org/eclipse/core/resources/IFile"));
        if (file != null) {
            this.launch((IResource)file, mode);
            return;
        }
        this.fileNotFound();
    }

    public void fileNotFound() {
        String msg = "Unable to launch the file. Possible reasons may include:\n    - the file (editor) being launched is not under a project in the workspace;\n    - the file was deleted.";
        AbstractLaunchShortcut.reportError(msg, null);
    }

    protected static void reportError(String message, Throwable throwable) {
        if (message == null) {
            message = "Unexpected error";
        }
        Object status = null;
        status = throwable instanceof CoreException ? ((CoreException)throwable).getStatus() : new Status(4, "org.python.pydev.debug", 0, message, throwable);
        ErrorDialog.openError((Shell)PydevDebugPlugin.getActiveWorkbenchWindow().getShell(), (String)"Python pydev.debug error", (String)"Python launch failed", (IStatus)status);
    }

    protected List<ILaunchConfiguration> findExistingLaunchConfigurations(IResource[] file) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(this.getLaunchConfigurationType());
        ArrayList<ILaunchConfiguration> validConfigs = new ArrayList<ILaunchConfiguration>();
        if (type == null) {
            return validConfigs;
        }
        try {
            ILaunchConfiguration[] configs = manager.getLaunchConfigurations(type);
            String defaultLocation = LaunchConfigurationCreator.getDefaultLocation(file, true);
            String defaultLocation2 = LaunchConfigurationCreator.getDefaultLocation(file, false);
            int i = 0;
            while (i < configs.length) {
                String configPath = configs[i].getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", "");
                if (defaultLocation.equals(configPath) || defaultLocation2.equals(configPath)) {
                    validConfigs.add(configs[i]);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            AbstractLaunchShortcut.reportError("Unexpected error", e);
        }
        return validConfigs;
    }

    public ILaunchConfiguration createDefaultLaunchConfiguration(IResource[] resource) {
        try {
            ILaunchConfigurationWorkingCopy createdConfiguration = this.createDefaultLaunchConfigurationWithoutSaving(resource);
            return createdConfiguration.doSave();
        }
        catch (CoreException e) {
            AbstractLaunchShortcut.reportError(null, e);
            return null;
        }
    }

    public ILaunchConfigurationWorkingCopy createDefaultLaunchConfigurationWithoutSaving(IResource[] resource) throws CoreException {
        IProject project = resource[0].getProject();
        IInterpreterManager pythonInterpreterManager = this.getInterpreterManager(project);
        String projName = project.getName();
        ILaunchConfigurationWorkingCopy createdConfiguration = LaunchConfigurationCreator.createDefaultLaunchConfiguration(resource, this.getLaunchConfigurationType(), LaunchConfigurationCreator.getDefaultLocation(resource, false), pythonInterpreterManager, projName);
        CommonTab tab = new CommonTab();
        tab.setDefaults(createdConfiguration);
        tab.dispose();
        return createdConfiguration;
    }

    protected ILaunchConfiguration chooseConfig(List<ILaunchConfiguration> configs) {
        if (configs.isEmpty()) {
            return null;
        }
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)labelProvider);
        dialog.setElements((Object[])configs.toArray(new ILaunchConfiguration[configs.size()]));
        dialog.setTitle("Pick a Python configuration");
        dialog.setMessage("Choose a python configuration to run");
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected void launch(IResource file, String mode) {
        this.launch(new IResource[]{file}, mode);
    }

    protected void launch(IResource[] resources, String mode) {
        ILaunchConfiguration conf = null;
        List<ILaunchConfiguration> configurations = this.findExistingLaunchConfigurations(resources);
        if (configurations.isEmpty()) {
            conf = this.createDefaultLaunchConfiguration(resources);
        } else if (configurations.size() == 1) {
            conf = configurations.get(0);
        } else {
            conf = this.chooseConfig(configurations);
            if (conf == null) {
                return;
            }
        }
        if (conf != null) {
            DebugUITools.launch((ILaunchConfiguration)conf, (String)mode);
            return;
        }
        this.fileNotFound();
    }
}

