/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.actions.resources;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.MessageConsole;
import org.python.pydev.consoles.MessageConsoles;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.runners.UniversalRunner;
import org.python.pydev.ui.actions.resources.PyResourceAction;

public class Py2To3
extends PyResourceAction
implements IObjectActionDelegate {
    public static final String RUN_2_TO_3_CODE = "from lib2to3.main import main\nimport sys\nimport os\n\nsys.exit(main('lib2to3.fixes'))\n";
    PythonNature natureUsed;
    List<String> parameters;
    List<IContainer> refresh;

    protected boolean confirmRun() {
        InputDialog d;
        int retCode;
        this.clearRunInput();
        PythonNature nature = null;
        Iterator iterator = this.selectedResources.iterator();
        while (iterator.hasNext()) {
            IResource c = (IResource)iterator.next();
            PythonNature n2 = PythonNature.getPythonNature(c);
            if (n2 == null) continue;
            if (nature == null) {
                nature = n2;
                continue;
            }
            if (n2 == nature) continue;
            MessageBox message = new MessageBox(PyAction.getShell(), 33);
            message.setText("Multiple python natures");
            message.setMessage("This action can only be applied in one project at a time.");
            message.open();
            return false;
        }
        if (nature == null) {
            MessageBox message = new MessageBox(PyAction.getShell(), 33);
            message.setText("No nature found");
            message.setMessage("This action can only be applied in a project that is configured as a Pydev project.");
            message.open();
            return false;
        }
        UniversalRunner.AbstractRunner runner = UniversalRunner.getRunner(nature);
        Tuple<String, String> tup = runner.runCodeAndGetOutput(RUN_2_TO_3_CODE, new String[]{"--help"}, null, (IProgressMonitor)new NullProgressMonitor());
        if (((String)tup.o1).indexOf("ImportError") != -1 || ((String)tup.o2).indexOf("ImportError") != -1) {
            MessageBox message = new MessageBox(PyAction.getShell(), 33);
            message.setText("Unable to run 2to3");
            message.setMessage("Unable to run 2to3. Details: \n" + (String)tup.o1 + "\n" + (String)tup.o2 + "\n\nNotes: check if lib2to3 is properly installed in your Python install.");
            message.open();
            return false;
        }
        String msg = "Please enter the parameters to be passed for 2to3.py\n\n" + (String)tup.o1 + "\n\n" + "E.g.: \n" + "Leave empty for preview\n" + "-w to apply with backup\n" + "-w -n to apply without backup.";
        if (tup.o2 != null && ((String)tup.o2).length() > 0) {
            msg = String.valueOf(msg) + "\n";
            msg = String.valueOf(msg) + (String)tup.o2;
        }
        if ((retCode = (d = new InputDialog(PyAction.getShell(), "Parameters for 2to3.py", msg, "", null){

            protected Control createDialogArea(Composite parent) {
                return super.createDialogArea(parent);
            }
        }).open()) != 0) {
            return false;
        }
        MessageConsole console = MessageConsoles.getConsole("2To3", "icons/python_16x16.png");
        console.clearConsole();
        this.parameters = StringUtils.split((String)d.getValue(), (String)" ");
        this.natureUsed = nature;
        return true;
    }

    protected void afterRun(int resourcesAffected) {
        Iterator<IContainer> iterator = this.refresh.iterator();
        while (iterator.hasNext()) {
            IContainer c = iterator.next();
            try {
                c.refreshLocal(2, null);
            }
            catch (CoreException e) {
                PydevPlugin.log(e);
            }
        }
        this.clearRunInput();
    }

    private void clearRunInput() {
        this.natureUsed = null;
        this.refresh = null;
        this.parameters = null;
    }

    protected int doActionOnResource(IResource next, IProgressMonitor monitor) {
        this.refresh = new ArrayList<IContainer>();
        UniversalRunner.AbstractRunner runner = UniversalRunner.getRunner(this.natureUsed);
        if (next instanceof IContainer) {
            this.refresh.add((IContainer)next);
        } else {
            this.refresh.add(next.getParent());
        }
        String dir = next.getLocation().toOSString();
        File workingDir = new File(dir);
        if (!workingDir.exists()) {
            PydevPlugin.log("Received file that does not exist for 2to3: " + workingDir);
            return 0;
        }
        if (!workingDir.isDirectory() && !(workingDir = workingDir.getParentFile()).isDirectory()) {
            PydevPlugin.log("Unable to find working dir for 2to3. Found invalid: " + workingDir);
            return 0;
        }
        ArrayList<String> parametersWithResource = new ArrayList<String>(this.parameters);
        parametersWithResource.add(0, dir);
        Tuple<String, String> tup = runner.runCodeAndGetOutput(RUN_2_TO_3_CODE, parametersWithResource.toArray(new String[0]), workingDir, monitor);
        IOConsoleOutputStream out = MessageConsoles.getConsoleOutputStream("2To3", "icons/python_16x16.png");
        try {
            out.write((String)tup.o1);
            out.write("\n");
            out.write((String)tup.o2);
        }
        catch (IOException e) {
            PydevPlugin.log(e);
        }
        return 1;
    }
}

