/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator;

import java.io.File;
import java.util.List;
import java.util.zip.ZipFile;
import org.eclipse.swt.graphics.Image;
import org.python.pydev.core.bundle.ImageCache;
import org.python.pydev.core.structure.TreeNode;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.navigator.LabelAndImage;
import org.python.pydev.navigator.PythonpathZipChildTreeNode;
import org.python.pydev.navigator.ZipStructure;
import org.python.pydev.navigator.elements.ISortedElement;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonpathTreeNode
extends TreeNode<LabelAndImage>
implements ISortedElement {
    public final File file;
    private boolean calculated = false;
    private boolean isDir;
    private boolean isPackage;
    private File[] dirFiles;
    private ZipFile zipFile;

    public PythonpathTreeNode(TreeNode<LabelAndImage> parent, File file) {
        this(parent, file, null, false);
    }

    public PythonpathTreeNode(TreeNode<LabelAndImage> parent, File file, Image icon, boolean isPythonpathRoot) {
        super(parent, (Object)new LabelAndImage(PythonpathTreeNode.getLabel(file, isPythonpathRoot), icon));
        this.file = file;
        this.isDir = file.isDirectory();
        if (this.isDir) {
            this.dirFiles = file.listFiles();
            if (isPythonpathRoot) {
                this.isPackage = true;
            } else if (parent instanceof PythonpathTreeNode && ((PythonpathTreeNode)parent).isPackage) {
                File[] fileArray = this.dirFiles;
                int n = this.dirFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file2 = fileArray[n2];
                    if (PythonPathHelper.isValidInitFile(file2.getName())) {
                        this.isPackage = true;
                        break;
                    }
                    ++n2;
                }
            }
        } else if (file.isFile() && FileTypesPreferencesPage.isValidZipFile(file.getName())) {
            try {
                this.zipFile = new ZipFile(file);
            }
            catch (Exception exception) {}
        }
        if (icon == null) {
            ImageCache imageCache = PydevPlugin.getImageCache();
            ((LabelAndImage)((Object)this.getData())).o2 = this.isDir ? (this.isPackage ? imageCache.get("icons/package_obj.gif") : imageCache.get("icons/folder.gif")) : (PythonPathHelper.isValidSourceFile(file.getName()) ? imageCache.get("icons/python_file.gif") : imageCache.get("icons/file.gif"));
        }
    }

    private static String getLabel(File file, boolean isPythonpathRoot) {
        if (isPythonpathRoot) {
            return file.getAbsolutePath();
        }
        return file.getName();
    }

    public boolean hasChildren() {
        return this.isDir && this.dirFiles != null && this.dirFiles.length > 0 || !this.isDir && this.zipFile != null;
    }

    @Override
    public int getRank() {
        return this.isDir ? 1 : 3;
    }

    public synchronized List<TreeNode<LabelAndImage>> getChildren() {
        block2: {
            block3: {
                if (this.calculated) break block2;
                this.calculated = true;
                if (!this.isDir || this.dirFiles == null) break block3;
                File[] fileArray = this.dirFiles;
                int n = this.dirFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    new PythonpathTreeNode(this, file);
                    ++n2;
                }
                break block2;
            }
            if (this.isDir || this.zipFile == null) break block2;
            ZipStructure zipStructure = new ZipStructure(this.file, this.zipFile);
            for (String content : zipStructure.contents("")) {
                new PythonpathZipChildTreeNode(this, zipStructure, content, null, true);
            }
        }
        return super.getChildren();
    }
}

