/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.docutils;

import com.rc.retroweaver.runtime.Autobox;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.cache.Cache;
import org.python.pydev.core.cache.LRUCache;
import org.python.pydev.core.docutils.NoPeerAvailableException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStringBuffer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    public static final Object EMPTY = "";
    public static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']'};
    private static Cache<Integer, String> widthToSpaceString = new LRUCache<Integer, String>(8);

    public static String format(String str, Object ... args) {
        FastStringBuffer buffer = new FastStringBuffer(str.length() + 16 * args.length);
        int j = 0;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '%' && i + 1 < str.length()) {
                char nextC = str.charAt(i + 1);
                if (nextC == 's') {
                    buffer.appendObject(args[j]);
                    ++j;
                    ++i;
                } else if (nextC == '%') {
                    buffer.append('%');
                    ++j;
                    ++i;
                }
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static int countPercS(String str) {
        int j = 0;
        int len = str.length();
        int i = 0;
        while (i < len) {
            char nextC;
            char c = str.charAt(i);
            if (c == '%' && i + 1 < len && (nextC = str.charAt(i + 1)) == 's') {
                ++j;
                ++i;
            }
            ++i;
        }
        return j;
    }

    public static String rightTrim(String input) {
        int len = input.length();
        int st = 0;
        int off = 0;
        char[] val = input.toCharArray();
        while (st < len && val[off + len - 1] <= ' ') {
            --len;
        }
        return input.substring(0, len);
    }

    public static String leftTrim(String input) {
        int len = input.length();
        int off = 0;
        char[] val = input.toCharArray();
        while (off < len && val[off] <= ' ') {
            ++off;
        }
        return input.substring(off, len);
    }

    public static String stripExtension(String input) {
        return StringUtils.stripFromRigthCharOnwards(input, '.');
    }

    public static int rFind(String input, char ch) {
        int len = input.length();
        int st = 0;
        int off = 0;
        char[] val = input.toCharArray();
        while (st < len && val[off + len - 1] != ch) {
            --len;
        }
        return --len;
    }

    private static String stripFromRigthCharOnwards(String input, char ch) {
        int len = StringUtils.rFind(input, ch);
        if (len == -1) {
            return input;
        }
        return input.substring(0, len);
    }

    public static String stripFromLastSlash(String input) {
        return StringUtils.stripFromRigthCharOnwards(input, '/');
    }

    public static String rightTrim(String input, char charToTrim) {
        int len = input.length();
        int st = 0;
        int off = 0;
        char[] val = input.toCharArray();
        while (st < len && val[off + len - 1] == charToTrim) {
            --len;
        }
        return input.substring(0, len);
    }

    public static String leftAndRightTrim(String input, char charToTrim) {
        return StringUtils.rightTrim(StringUtils.leftTrim(input, charToTrim), charToTrim);
    }

    public static String leftTrim(String input, char charToTrim) {
        int len = input.length();
        int off = 0;
        char[] val = input.toCharArray();
        while (off < len && val[off] == charToTrim) {
            ++off;
        }
        return input.substring(off, len);
    }

    public static String replaceAllSlashes(String string) {
        int len = string.length();
        char c = '\u0000';
        int i = 0;
        while (i < len) {
            c = string.charAt(i);
            if (c == '\\') {
                char[] ds = string.toCharArray();
                ds[i] = 47;
                int j = i;
                while (j < len) {
                    if (ds[j] == '\\') {
                        ds[j] = 47;
                    }
                    ++j;
                }
                return new String(ds);
            }
            ++i;
        }
        return string;
    }

    public static List<String> splitInLines(String string) {
        ArrayList<String> ret = new ArrayList<String>();
        int len = string.length();
        FastStringBuffer buf = new FastStringBuffer();
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            buf.append(c);
            if (c == '\r') {
                if (i < len - 1 && string.charAt(i + 1) == '\n') {
                    ++i;
                    buf.append('\n');
                }
                ret.add(buf.toString());
                buf.clear();
            }
            if (c == '\n') {
                ret.add(buf.toString());
                buf.clear();
            }
            ++i;
        }
        if (buf.length() != 0) {
            ret.add(buf.toString());
        }
        return ret;
    }

    public static boolean isSingleWord(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isJavaIdentifierStart(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static String replaceAll(String string, String replace, String with) {
        FastStringBuffer ret = new FastStringBuffer(string, 16);
        return ret.replaceAll(replace, with).toString();
    }

    public static String fixWhitespaceColumnsToLeftFromDocstring(String docString, String indentationToAdd) {
        char c;
        FastStringBuffer buf = new FastStringBuffer();
        List<String> splitted = StringUtils.splitInLines(docString);
        int i = 0;
        while (i < splitted.size()) {
            String initialString = splitted.get(i);
            if (i == 0) {
                buf.append(initialString);
            } else {
                String string = StringUtils.leftTrim(initialString);
                buf.append(indentationToAdd);
                if (string.length() > 0) {
                    buf.append(string);
                } else {
                    int length = initialString.length();
                    if (length > 0) {
                        char c2;
                        if (length > 1 && ((c2 = initialString.charAt(length - 2)) == '\n' || c2 == '\r')) {
                            buf.append(c2);
                        }
                        if ((c2 = initialString.charAt(length - 1)) == '\n' || c2 == '\r') {
                            buf.append(c2);
                        }
                    }
                }
            }
            ++i;
        }
        if (buf.length() > 0 && ((c = buf.lastChar()) == '\r' || c == '\n')) {
            buf.append(indentationToAdd);
        }
        return buf.toString();
    }

    public static String removeWhitespaceColumnsToLeft(String hoverInfo) {
        FastStringBuffer buf = new FastStringBuffer();
        int firstCharPosition = Integer.MAX_VALUE;
        List<String> splitted = StringUtils.splitInLines(hoverInfo);
        for (String line : splitted) {
            if (line.trim().length() <= 0) continue;
            int found = PySelection.getFirstCharPosition(line);
            firstCharPosition = Math.min(found, firstCharPosition);
        }
        if (firstCharPosition != Integer.MAX_VALUE) {
            for (String line : splitted) {
                if (line.length() <= firstCharPosition) continue;
                buf.append(line.substring(firstCharPosition));
            }
            return buf.toString();
        }
        return hoverInfo;
    }

    public static String removeWhitespaceColumnsToLeftAndApplyIndent(String code, String indent, boolean indentCommentLinesAt0Pos) {
        FastStringBuffer buf = new FastStringBuffer();
        int firstCharPosition = Integer.MAX_VALUE;
        List<String> splitted = StringUtils.splitInLines(code);
        for (String line : splitted) {
            if (!indentCommentLinesAt0Pos && line.startsWith("#") || line.trim().length() <= 0) continue;
            int found = PySelection.getFirstCharPosition(line);
            firstCharPosition = Math.min(found, firstCharPosition);
        }
        if (firstCharPosition != Integer.MAX_VALUE) {
            for (String line : splitted) {
                if (indentCommentLinesAt0Pos || !line.startsWith("#")) {
                    buf.append(indent);
                    if (line.length() > firstCharPosition) {
                        buf.append(line.substring(firstCharPosition));
                        continue;
                    }
                    buf.append(line);
                    continue;
                }
                buf.append(line);
            }
            return buf.toString();
        }
        return code;
    }

    public static String extractTextFromHTML(String html) {
        try {
            HTMLEditorKit kit = new HTMLEditorKit();
            Document doc = ((EditorKit)kit).createDefaultDocument();
            doc.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
            StringReader rd = new StringReader(html);
            ((EditorKit)kit).read(rd, doc, 0);
            return doc.getText(0, doc.getLength());
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static List<String> split(String string, String toSplit) {
        if (toSplit.length() == 1) {
            return StringUtils.split(string, toSplit.charAt(0));
        }
        ArrayList<String> ret = new ArrayList<String>();
        if (toSplit.length() == 0) {
            ret.add(string);
            return ret;
        }
        int len = string.length();
        int last = 0;
        char c = '\u0000';
        int i = 0;
        while (i < len) {
            c = string.charAt(i);
            if (c == toSplit.charAt(0) && StringUtils.matches(string, toSplit, i)) {
                if (last != i) {
                    ret.add(string.substring(last, i));
                }
                last = i + toSplit.length();
                i += toSplit.length() - 1;
            }
            ++i;
        }
        if (last < len) {
            ret.add(string.substring(last, len));
        }
        return ret;
    }

    private static boolean matches(String string, String toSplit, int i) {
        if (string.length() - i >= toSplit.length()) {
            int j = 0;
            while (j < toSplit.length()) {
                if (string.charAt(i + j) != toSplit.charAt(j)) {
                    return false;
                }
                ++j;
            }
            return true;
        }
        return false;
    }

    public static List<String> split(String string, char toSplit) {
        ArrayList<String> ret = new ArrayList<String>();
        int len = string.length();
        int last = 0;
        char c = '\u0000';
        int i = 0;
        while (i < len) {
            c = string.charAt(i);
            if (c == toSplit) {
                if (last != i) {
                    ret.add(string.substring(last, i));
                }
                while (c == toSplit && i < len - 1) {
                    c = string.charAt(++i);
                }
                last = i;
            }
            ++i;
        }
        if (c != toSplit) {
            if (last == 0 && len > 0) {
                ret.add(string);
            } else if (last < len) {
                ret.add(string.substring(last, len));
            }
        }
        return ret;
    }

    public static List<String> split(String string, char ... toSplit) {
        ArrayList<String> ret = new ArrayList<String>();
        int len = string.length();
        int last = 0;
        char c = '\u0000';
        int i = 0;
        while (i < len) {
            c = string.charAt(i);
            if (StringUtils.contains(c, toSplit)) {
                if (last != i) {
                    ret.add(string.substring(last, i));
                }
                while (StringUtils.contains(c, toSplit) && i < len - 1) {
                    c = string.charAt(++i);
                }
                last = i;
            }
            ++i;
        }
        if (!StringUtils.contains(c, toSplit)) {
            if (last == 0 && len > 0) {
                ret.add(string);
            } else if (last < len) {
                ret.add(string.substring(last, len));
            }
        }
        return ret;
    }

    public static List<String> splitAndRemoveEmptyTrimmed(String string, char c) {
        List<String> split = StringUtils.split(string, c);
        int i = split.size() - 1;
        while (i >= 0) {
            if (split.get(i).trim().length() == 0) {
                split.remove(i);
            }
            --i;
        }
        return split;
    }

    private static boolean contains(char c, char[] toSplit) {
        char[] cArray = toSplit;
        int n = toSplit.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (c == ch) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Tuple<String, String> splitOnFirst(String fullRep, char toSplit) {
        int i = fullRep.indexOf(toSplit);
        if (i != -1) {
            return new Tuple<String, String>(fullRep.substring(0, i), fullRep.substring(i + 1));
        }
        return new Tuple<String, String>(fullRep, "");
    }

    public static Tuple<String, String> splitOnFirst(String fullRep, String toSplit) {
        int i = fullRep.indexOf(toSplit);
        if (i != -1) {
            return new Tuple<String, String>(fullRep.substring(0, i), fullRep.substring(i + toSplit.length()));
        }
        return new Tuple<String, String>(fullRep, "");
    }

    public static List<String> dotSplit(String string) {
        return StringUtils.splitAndRemoveEmptyTrimmed(string, '.');
    }

    public static String join(String delimiter, Object ... splitted) {
        String[] newSplitted = new String[splitted.length];
        int i = 0;
        while (i < splitted.length) {
            Object s = splitted[i];
            newSplitted[i] = s == null ? "null" : s.toString();
            ++i;
        }
        return StringUtils.join(delimiter, newSplitted);
    }

    public static String join(String delimiter, String[] splitted) {
        FastStringBuffer buf = new FastStringBuffer(splitted.length * 100);
        String[] stringArray = splitted;
        int n = splitted.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (buf.length() > 0) {
                buf.append(delimiter);
            }
            buf.append(string);
            ++n2;
        }
        return buf.toString();
    }

    public static String join(String delimiter, String[] splitted, int startAtSegment, int endAtSegment) {
        FastStringBuffer buf = new FastStringBuffer(splitted.length * 100);
        int i = startAtSegment;
        while (i < splitted.length && i < endAtSegment) {
            if (buf.length() > 0) {
                buf.append(delimiter);
            }
            buf.append(splitted[i]);
            ++i;
        }
        return buf.toString();
    }

    public static String join(String delimiter, List<String> splitted) {
        FastStringBuffer buf = new FastStringBuffer(splitted.size() * 100);
        for (String string : splitted) {
            if (buf.length() > 0) {
                buf.append(delimiter);
            }
            buf.append(string);
        }
        return buf.toString();
    }

    public static char[] addChar(char[] c, char toAdd) {
        char[] c1 = new char[c.length + 1];
        System.arraycopy(c, 0, c1, 0, c.length);
        c1[c.length] = toAdd;
        return c1;
    }

    public static String[] addString(String[] c, String toAdd) {
        String[] c1 = new String[c.length + 1];
        System.arraycopy(c, 0, c1, 0, c.length);
        c1[c.length] = toAdd;
        return c1;
    }

    public static String replaceNewLines(String message, String string) {
        message = message.replaceAll("\r\n", string);
        message = message.replaceAll("\r", string);
        message = message.replaceAll("\n", string);
        return message;
    }

    public static String removeNewLineChars(String message) {
        return message.replaceAll("\r", "").replaceAll("\n", "");
    }

    public static String asStyleLowercaseUnderscores(String string) {
        FastStringBuffer buf = new FastStringBuffer(string.length() * 2);
        char[] charArray = string.toCharArray();
        boolean lastUpper = false;
        char[] cArray = charArray;
        int n = charArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isUpperCase(c)) {
                if (!lastUpper && buf.length() > 0 && buf.lastChar() != '_') {
                    buf.append('_');
                }
                buf.append(Character.toLowerCase(c));
                lastUpper = true;
            } else {
                buf.append(c);
                lastUpper = false;
            }
            ++n2;
        }
        return buf.toString();
    }

    public static boolean isAllUpper(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isLetter(c) && !Character.isUpperCase(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static String asStyleCamelCaseFirstLower(String string) {
        if (StringUtils.isAllUpper(string)) {
            string = string.toLowerCase();
        }
        FastStringBuffer buf = new FastStringBuffer(string.length());
        char[] charArray = string.toCharArray();
        boolean first = true;
        int nextUpper = 0;
        char[] cArray = charArray;
        int n = charArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (first) {
                if (c == '_') {
                    buf.append(c);
                } else {
                    buf.append(Character.toLowerCase(c));
                    first = false;
                }
            } else if (c == '_') {
                ++nextUpper;
            } else {
                if (nextUpper > 0) {
                    c = Character.toUpperCase(c);
                    nextUpper = 0;
                }
                buf.append(c);
            }
            ++n2;
        }
        if (nextUpper > 0) {
            buf.appendN('_', nextUpper);
        }
        return buf.toString();
    }

    public static String asStyleCamelCaseFirstUpper(String string) {
        if ((string = StringUtils.asStyleCamelCaseFirstLower(string)).length() > 0) {
            return new StringBuffer(String.valueOf(Character.toUpperCase(string.charAt(0)))).append(string.substring(1)).toString();
        }
        return string;
    }

    public static boolean endsWith(FastStringBuffer str, char c) {
        if (str.length() == 0) {
            return false;
        }
        return str.charAt(str.length() - 1) == c;
    }

    public static boolean endsWith(String str, char c) {
        if (str.length() == 0) {
            return false;
        }
        return str.charAt(str.length() - 1) == c;
    }

    public static boolean endsWith(StringBuffer str, char c) {
        if (str.length() == 0) {
            return false;
        }
        return str.charAt(str.length() - 1) == c;
    }

    public static boolean isWord(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < str.length()) {
            if (!Character.isJavaIdentifierPart(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static char getPeer(char c) {
        switch (c) {
            case '{': {
                return '}';
            }
            case '}': {
                return '{';
            }
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '[': {
                return ']';
            }
            case ']': {
                return '[';
            }
        }
        throw new NoPeerAvailableException(new StringBuffer("Unable to find peer for :").append(c).toString());
    }

    public static boolean isOpeningPeer(char lastChar) {
        return lastChar == '(' || lastChar == '[' || lastChar == '{';
    }

    public static boolean isClosingPeer(char lastChar) {
        return lastChar == ')' || lastChar == ']' || lastChar == '}';
    }

    public static boolean hasOpeningBracket(String trimmedLine) {
        return trimmedLine.indexOf(123) != -1 || trimmedLine.indexOf(40) != -1 || trimmedLine.indexOf(91) != -1;
    }

    public static boolean hasClosingBracket(String trimmedLine) {
        return trimmedLine.indexOf(125) != -1 || trimmedLine.indexOf(41) != -1 || trimmedLine.indexOf(93) != -1;
    }

    public static String createSpaceString(int width) {
        String existing = widthToSpaceString.getObj(Autobox.valueOf((int)width));
        if (existing != null) {
            return existing;
        }
        FastStringBuffer buf = new FastStringBuffer(width);
        buf.appendN(' ', width);
        String newStr = buf.toString();
        widthToSpaceString.add(Autobox.valueOf((int)width), newStr);
        return newStr;
    }

    public static int count(String name, char c) {
        int count = 0;
        int len = name.length();
        int i = 0;
        while (i < len) {
            if (name.charAt(i) == c) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static String urlEncodeKeyValuePair(String key, String value) {
        String result = null;
        try {
            result = new StringBuffer(String.valueOf(URLEncoder.encode(key, "UTF-8"))).append("=").append(URLEncoder.encode(value, "UTF-8")).toString();
        }
        catch (UnsupportedEncodingException e) {
            Log.log(e);
        }
        return result;
    }

    public static boolean containsWhitespace(String name) {
        int i = 0;
        while (i < name.length()) {
            if (Character.isWhitespace(name.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

