/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.wizards.rename;

import com.python.pydev.analysis.scopeanalysis.ScopeAnalyzerVisitor;
import com.python.pydev.refactoring.refactorer.RefactorerFindReferences;
import com.python.pydev.refactoring.wizards.IRefactorRenameProcess;
import com.rc.retroweaver.runtime.Autobox;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.python.pydev.core.IModule;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.visitors.scope.ASTEntry;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRenameRefactorProcess
implements IRefactorRenameProcess {
    protected RefactoringRequest request;
    protected Definition definition;
    protected HashSet<ASTEntry> docOccurrences = new HashSet();
    protected Map<Tuple<String, IFile>, HashSet<ASTEntry>> fileOccurrences = new HashMap<Tuple<String, IFile>, HashSet<ASTEntry>>();

    public AbstractRenameRefactorProcess() {
    }

    public AbstractRenameRefactorProcess(Definition definition) {
        this.definition = definition;
    }

    protected void addOccurrences(RefactoringRequest request, List<ASTEntry> oc) {
        this.docOccurrences.addAll(oc);
    }

    protected void addOccurrences(List<ASTEntry> oc, IFile file, String modName) {
        Tuple key = new Tuple((Object)modName, (Object)file);
        Set existent = this.fileOccurrences.get(key);
        if (existent == null) {
            this.fileOccurrences.put((Tuple<String, IFile>)key, new HashSet<ASTEntry>(oc));
        } else {
            existent.addAll(oc);
        }
    }

    public static int getOffset(IDocument doc, ASTEntry entry) {
        exprType value;
        ClassDef def;
        SimpleNode node = entry.node;
        if (node instanceof ClassDef) {
            def = (ClassDef)node;
            node = def.name;
        }
        if (node instanceof FunctionDef) {
            def = (FunctionDef)node;
            node = def.name;
        }
        if (node instanceof Attribute && (value = ((Attribute)node).value) instanceof Call) {
            Call c = (Call)value;
            node = c.func;
        }
        int beginLine = node.beginLine;
        int beginCol = node.beginColumn;
        int offset = PySelection.getAbsoluteCursorOffset((IDocument)doc, (int)(beginLine - 1), (int)(beginCol - 1));
        return offset;
    }

    public static List<ASTEntry> sortOccurrences(List<ASTEntry> occurrences) {
        occurrences = new ArrayList<ASTEntry>(occurrences);
        Collections.sort(occurrences, new Comparator<ASTEntry>(){

            @Override
            public int compare(ASTEntry o1, ASTEntry o2) {
                int o2Found;
                int o1Found = (Integer)o1.getAdditionalInfo("AST_ENTRY_FOUND_LOCATION", (Object)Autobox.valueOf((int)0));
                if (o1Found == (o2Found = ((Integer)o2.getAdditionalInfo("AST_ENTRY_FOUND_LOCATION", (Object)Autobox.valueOf((int)0))).intValue())) {
                    return 0;
                }
                if (o1Found < o2Found) {
                    return -1;
                }
                return 1;
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.compare((ASTEntry)object, (ASTEntry)object2);
            }
        });
        return occurrences;
    }

    @Override
    public void findReferencesToRename(RefactoringRequest request, RefactoringStatus status) {
        this.request = request;
        if (((Boolean)request.getAdditionalInfo("findReferencesOnlyOnLocalScope", (Object)Autobox.valueOf((boolean)false))).booleanValue()) {
            this.findReferencesToRenameOnLocalScope(request, status);
        } else {
            this.findReferencesToRenameOnWorkspace(request, status);
        }
        if (!this.occurrencesValid(status)) {
            return;
        }
    }

    protected void findReferencesToRenameOnLocalScope(RefactoringRequest request, RefactoringStatus status) {
        throw new RuntimeException(new StringBuffer("Not implemented search on local scope:").append(this.getClass().getName()).toString());
    }

    protected void findReferencesToRenameOnWorkspace(RefactoringRequest request, RefactoringStatus status) {
        throw new RuntimeException(new StringBuffer("Not implemented search on workspace:").append(this.getClass().getName()).toString());
    }

    protected boolean occurrencesValid(RefactoringStatus status) {
        if (this.docOccurrences.size() == 0) {
            status.addFatalError(new StringBuffer("No occurrences found for:").append(this.request.initialName).toString());
            return false;
        }
        return true;
    }

    @Override
    public HashSet<ASTEntry> getOccurrences() {
        return this.docOccurrences;
    }

    @Override
    public Map<Tuple<String, IFile>, HashSet<ASTEntry>> getOccurrencesInOtherFiles() {
        return this.fileOccurrences;
    }

    protected List<ASTEntry> getOccurrencesWithScopeAnalyzer(RefactoringRequest request) {
        List<Object> entryOccurrences = new ArrayList<ASTEntry>();
        IModule module = request.getModule();
        try {
            ScopeAnalyzerVisitor visitor = new ScopeAnalyzerVisitor(request.nature, request.moduleName, module, (IProgressMonitor)new NullProgressMonitor(), request.ps);
            request.getAST().accept((VisitorIF)visitor);
            entryOccurrences = visitor.getEntryOccurrences();
        }
        catch (BadLocationException badLocationException) {
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return entryOccurrences;
    }

    protected List<IFile> findFilesWithPossibleReferences(RefactoringRequest request) {
        return new RefactorerFindReferences().findPossibleReferences(request);
    }
}

