/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.swt;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.swt.SWTGraphics2D;
import edu.umd.cs.piccolox.swt.SWTShapeManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class PSWTPath
extends PNode {
    public static final String PROPERTY_SHAPE = "shape";
    private static final double BOUNDS_TOLERANCE = 0.01;
    private static final Rectangle2D.Float TEMP_RECTANGLE = new Rectangle2D.Float();
    private static final Ellipse2D.Float TEMP_ELLIPSE = new Ellipse2D.Float();
    private static final PAffineTransform TEMP_TRANSFORM = new PAffineTransform();
    private static final Color DEFAULT_STROKE_PAINT = Color.black;
    private static final BasicStroke BASIC_STROKE = new BasicStroke();
    private static final float PEN_WIDTH = 1.0f;
    private Paint strokePaint = DEFAULT_STROKE_PAINT;
    boolean updatingBoundsFromPath;
    Shape origShape;
    Shape shape;
    PAffineTransform internalXForm;
    AffineTransform inverseXForm;
    double[] shapePts;

    public static PSWTPath createRectangle(float x, float y, float width, float height) {
        TEMP_RECTANGLE.setFrame(x, y, width, height);
        PSWTPath result = new PSWTPath(TEMP_RECTANGLE);
        result.setPaint(Color.white);
        return result;
    }

    public static PSWTPath createEllipse(float x, float y, float width, float height) {
        TEMP_ELLIPSE.setFrame(x, y, width, height);
        PSWTPath result = new PSWTPath(TEMP_ELLIPSE);
        result.setPaint(Color.white);
        return result;
    }

    public static PSWTPath createPolyline(Point2D[] points) {
        PSWTPath result = new PSWTPath();
        result.setPathToPolyline(points);
        result.setPaint(Color.white);
        return result;
    }

    public static PSWTPath createPolyline(float[] xp, float[] yp) {
        PSWTPath result = new PSWTPath();
        result.setPathToPolyline(xp, yp);
        result.setPaint(Color.white);
        return result;
    }

    public PSWTPath() {
    }

    public PSWTPath(Shape aShape) {
        this();
        this.setShape(aShape);
    }

    public Paint getStrokePaint() {
        return this.strokePaint;
    }

    public void setStrokeColor(Paint aPaint) {
        Paint old = this.strokePaint;
        this.strokePaint = aPaint;
        this.invalidatePaint();
        this.firePropertyChange(65536, "strokePaint", old, this.strokePaint);
    }

    protected void internalUpdateBounds(double x, double y, double width, double height) {
        if (this.updatingBoundsFromPath) {
            return;
        }
        if (this.origShape == null) {
            return;
        }
        Rectangle2D pathBounds = this.origShape.getBounds2D();
        if (Math.abs(x - pathBounds.getX()) / x < 0.01 && Math.abs(y - pathBounds.getY()) / y < 0.01 && Math.abs(width - pathBounds.getWidth()) / width < 0.01 && Math.abs(height - pathBounds.getHeight()) / height < 0.01) {
            return;
        }
        if (this.internalXForm == null) {
            this.internalXForm = new PAffineTransform();
        }
        this.internalXForm.setToIdentity();
        this.internalXForm.translate(x, y);
        this.internalXForm.scale(width / pathBounds.getWidth(), height / pathBounds.getHeight());
        this.internalXForm.translate(-pathBounds.getX(), -pathBounds.getY());
        try {
            this.inverseXForm = this.internalXForm.createInverse();
        }
        catch (Exception exception) {}
    }

    public boolean intersects(Rectangle2D aBounds) {
        if (super.intersects(aBounds)) {
            if (this.internalXForm != null) {
                aBounds = new PBounds(aBounds);
                this.internalXForm.inverseTransform(aBounds, aBounds);
            }
            if (this.getPaint() != null && this.shape.intersects(aBounds)) {
                return true;
            }
            if (this.strokePaint != null) {
                return BASIC_STROKE.createStrokedShape(this.shape).intersects(aBounds);
            }
        }
        return false;
    }

    public void updateBoundsFromPath() {
        this.updatingBoundsFromPath = true;
        if (this.origShape == null) {
            this.resetBounds();
        } else {
            Rectangle2D b = this.origShape.getBounds2D();
            super.setBounds(b.getX() - 1.0, b.getY() - 1.0, b.getWidth() + 2.0, b.getHeight() + 2.0);
        }
        this.updatingBoundsFromPath = false;
    }

    protected void paint(PPaintContext paintContext) {
        double lineWidth;
        Paint p = this.getPaint();
        SWTGraphics2D g2 = (SWTGraphics2D)paintContext.getGraphics();
        if (this.internalXForm != null) {
            g2.transform(this.internalXForm);
        }
        if (p != null) {
            g2.setBackground((Color)p);
            lineWidth = g2.getTransformedLineWidth();
            if (this.shape instanceof Rectangle2D) {
                g2.fillRect(this.shapePts[0] + lineWidth / 2.0, this.shapePts[1] + lineWidth / 2.0, this.shapePts[2] - lineWidth, this.shapePts[3] - lineWidth);
            } else if (this.shape instanceof Ellipse2D) {
                g2.fillOval(this.shapePts[0] + lineWidth / 2.0, this.shapePts[1] + lineWidth / 2.0, this.shapePts[2] - lineWidth, this.shapePts[3] - lineWidth);
            } else if (this.shape instanceof Arc2D) {
                g2.fillArc(this.shapePts[0] + lineWidth / 2.0, this.shapePts[1] + lineWidth / 2.0, this.shapePts[2] - lineWidth, this.shapePts[3] - lineWidth, this.shapePts[4], this.shapePts[5]);
            } else if (this.shape instanceof RoundRectangle2D) {
                g2.fillRoundRect(this.shapePts[0] + lineWidth / 2.0, this.shapePts[1] + lineWidth / 2.0, this.shapePts[2] - lineWidth, this.shapePts[3] - lineWidth, this.shapePts[4], this.shapePts[5]);
            } else {
                g2.fillPolygon(this.shapePts);
            }
        }
        if (this.strokePaint != null) {
            g2.setColor((Color)this.strokePaint);
            lineWidth = g2.getTransformedLineWidth();
            if (this.shape instanceof Rectangle2D) {
                g2.drawRect(this.shapePts[0] + lineWidth / 2.0, this.shapePts[1] + lineWidth / 2.0, this.shapePts[2] - lineWidth, this.shapePts[3] - lineWidth);
            } else if (this.shape instanceof Ellipse2D) {
                g2.drawOval(this.shapePts[0] + lineWidth / 2.0, this.shapePts[1] + lineWidth / 2.0, this.shapePts[2] - lineWidth, this.shapePts[3] - lineWidth);
            } else if (this.shape instanceof Arc2D) {
                g2.drawArc(this.shapePts[0] + lineWidth / 2.0, this.shapePts[1] + lineWidth / 2.0, this.shapePts[2] - lineWidth, this.shapePts[3] - lineWidth, this.shapePts[4], this.shapePts[5]);
            } else if (this.shape instanceof RoundRectangle2D) {
                g2.drawRoundRect(this.shapePts[0] + lineWidth / 2.0, this.shapePts[1] + lineWidth / 2.0, this.shapePts[2] - lineWidth, this.shapePts[3] - lineWidth, this.shapePts[4], this.shapePts[5]);
            } else {
                g2.drawPolyline(this.shapePts);
            }
        }
        if (this.inverseXForm != null) {
            g2.transform(this.inverseXForm);
        }
    }

    public void setShape(Shape aShape) {
        this.origShape = this.shape = this.cloneShape(aShape);
        this.updateShapePoints(aShape);
        this.firePropertyChange(262144, "path", null, this.shape);
        this.updateBoundsFromPath();
        this.invalidatePaint();
    }

    public void updateShapePoints(Shape aShape) {
        if (aShape instanceof Rectangle2D) {
            if (this.shapePts == null || this.shapePts.length < 4) {
                this.shapePts = new double[4];
            }
            this.shapePts[0] = ((Rectangle2D)this.shape).getX();
            this.shapePts[1] = ((Rectangle2D)this.shape).getY();
            this.shapePts[2] = ((Rectangle2D)this.shape).getWidth();
            this.shapePts[3] = ((Rectangle2D)this.shape).getHeight();
        } else if (aShape instanceof Ellipse2D) {
            if (this.shapePts == null || this.shapePts.length < 4) {
                this.shapePts = new double[4];
            }
            this.shapePts[0] = ((Ellipse2D)this.shape).getX();
            this.shapePts[1] = ((Ellipse2D)this.shape).getY();
            this.shapePts[2] = ((Ellipse2D)this.shape).getWidth();
            this.shapePts[3] = ((Ellipse2D)this.shape).getHeight();
        } else if (aShape instanceof Arc2D) {
            if (this.shapePts == null || this.shapePts.length < 6) {
                this.shapePts = new double[6];
            }
            this.shapePts[0] = ((Arc2D)this.shape).getX();
            this.shapePts[1] = ((Arc2D)this.shape).getY();
            this.shapePts[2] = ((Arc2D)this.shape).getWidth();
            this.shapePts[3] = ((Arc2D)this.shape).getHeight();
            this.shapePts[4] = ((Arc2D)this.shape).getAngleStart();
            this.shapePts[5] = ((Arc2D)this.shape).getAngleExtent();
        } else if (aShape instanceof RoundRectangle2D) {
            if (this.shapePts == null || this.shapePts.length < 6) {
                this.shapePts = new double[6];
            }
            this.shapePts[0] = ((RoundRectangle2D)this.shape).getX();
            this.shapePts[1] = ((RoundRectangle2D)this.shape).getY();
            this.shapePts[2] = ((RoundRectangle2D)this.shape).getWidth();
            this.shapePts[3] = ((RoundRectangle2D)this.shape).getHeight();
            this.shapePts[4] = ((RoundRectangle2D)this.shape).getArcWidth();
            this.shapePts[5] = ((RoundRectangle2D)this.shape).getArcHeight();
        } else {
            this.shapePts = SWTShapeManager.shapeToPolyline(this.shape);
        }
    }

    public Shape cloneShape(Shape aShape) {
        if (aShape instanceof Rectangle2D) {
            return new PBounds((Rectangle2D)aShape);
        }
        if (aShape instanceof Ellipse2D) {
            Ellipse2D e2 = (Ellipse2D)aShape;
            return new Ellipse2D.Double(e2.getX(), e2.getY(), e2.getWidth(), e2.getHeight());
        }
        if (aShape instanceof Arc2D) {
            Arc2D a2 = (Arc2D)aShape;
            return new Arc2D.Double(a2.getX(), a2.getY(), a2.getWidth(), a2.getHeight(), a2.getAngleStart(), a2.getAngleExtent(), a2.getArcType());
        }
        if (aShape instanceof RoundRectangle2D) {
            RoundRectangle2D r2 = (RoundRectangle2D)aShape;
            return new RoundRectangle2D.Double(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight(), r2.getArcWidth(), r2.getArcHeight());
        }
        if (aShape instanceof GeneralPath) {
            GeneralPath aPath = new GeneralPath();
            aPath.append(aShape, false);
            return aPath;
        }
        new Exception().printStackTrace();
        GeneralPath aPath = new GeneralPath();
        aPath.append(aShape, false);
        return aPath;
    }

    public void setPathToRectangle(float x, float y, float width, float height) {
        TEMP_RECTANGLE.setFrame(x, y, width, height);
        this.setShape(TEMP_RECTANGLE);
    }

    public void setPathToEllipse(float x, float y, float width, float height) {
        TEMP_ELLIPSE.setFrame(x, y, width, height);
        this.setShape(TEMP_ELLIPSE);
    }

    public void setPathToPolyline(Point2D[] points) {
        GeneralPath path = new GeneralPath();
        path.reset();
        path.moveTo((float)points[0].getX(), (float)points[0].getY());
        int i = 1;
        while (i < points.length) {
            path.lineTo((float)points[i].getX(), (float)points[i].getY());
            ++i;
        }
        this.setShape(path);
    }

    public void setPathToPolyline(float[] xp, float[] yp) {
        GeneralPath path = new GeneralPath();
        path.reset();
        path.moveTo(xp[0], yp[0]);
        int i = 1;
        while (i < xp.length) {
            path.lineTo(xp[i], yp[i]);
            ++i;
        }
        this.setShape(path);
    }

    protected String paramString() {
        StringBuffer result = new StringBuffer();
        result.append("path=" + (this.shape == null ? "null" : this.shape.toString()));
        result.append(",strokePaint=" + (this.strokePaint == null ? "null" : this.strokePaint.toString()));
        result.append(',');
        result.append(super.paramString());
        return result.toString();
    }

    public Point2D getCenter() {
        PBounds bounds2 = this.getBounds();
        return new Point2D.Double(bounds2.x + bounds2.width / 2.0, bounds2.y + bounds2.height / 2.0);
    }
}

