/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class PStyledText
extends PNode {
    protected static FontRenderContext SWING_FRC = new FontRenderContext(null, true, false);
    protected static Line2D paintLine = new Line2D.Double();
    protected Document document;
    protected transient ArrayList stringContents;
    protected transient LineInfo[] lines;
    protected boolean editing;
    protected Insets insets = new Insets(0, 0, 0, 0);
    protected boolean constrainHeightToTextHeight = true;
    protected boolean constrainWidthToTextWidth = true;

    public void setConstrainWidthToTextWidth(boolean constrainWidthToTextWidth) {
        this.constrainWidthToTextWidth = constrainWidthToTextWidth;
        this.recomputeLayout();
    }

    public void setConstrainHeightToTextHeight(boolean constrainHeightToTextHeight) {
        this.constrainHeightToTextHeight = constrainHeightToTextHeight;
        this.recomputeLayout();
    }

    public boolean getConstrainWidthToTextWidth() {
        return this.constrainWidthToTextWidth;
    }

    public boolean getConstrainHeightToTextHeight() {
        return this.constrainHeightToTextHeight;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
        this.syncWithDocument();
    }

    public void syncWithDocument() {
        ArrayList<RunInfo> pEnds = null;
        int pos = 0;
        try {
            this.stringContents = new ArrayList();
            pEnds = new ArrayList<RunInfo>();
            String s = this.document.getText(0, this.document.getLength());
            StringTokenizer tokenizer = new StringTokenizer(s, "\n", true);
            boolean lastNewLine = true;
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.equals("\n")) {
                    if (lastNewLine) {
                        this.stringContents.add(new AttributedString(" "));
                        pEnds.add(new RunInfo(pos, pos + 1));
                        ++pos;
                        lastNewLine = true;
                    } else {
                        ++pos;
                        lastNewLine = true;
                    }
                } else if (token.equals("")) {
                    this.stringContents.add(new AttributedString(" "));
                    pEnds.add(new RunInfo(pos, pos));
                    lastNewLine = false;
                } else {
                    this.stringContents.add(new AttributedString(token));
                    pEnds.add(new RunInfo(pos, pos + token.length()));
                    pos += token.length();
                    lastNewLine = false;
                }
                ++i;
            }
            if (lastNewLine) {
                this.stringContents.add(new AttributedString(" "));
                pEnds.add(new RunInfo(pos, pos + 1));
                lastNewLine = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StyleContext style = StyleContext.getDefaultStyleContext();
        RunInfo pEnd = null;
        int i = 0;
        while (i < this.stringContents.size()) {
            boolean strikethrough;
            boolean underline;
            Color background;
            Font font;
            Color foreground;
            AttributeSet attributes;
            pEnd = (RunInfo)pEnds.get(i);
            pos = pEnd.runStart;
            Element curElement = null;
            Element rootElement = this.document.getDefaultRootElement();
            if (pEnd.runStart != pEnd.runLimit) {
                while (pos < pEnd.runLimit) {
                    curElement = rootElement;
                    while (!curElement.isLeaf()) {
                        curElement = curElement.getElement(curElement.getElementIndex(pos));
                    }
                    attributes = curElement.getAttributes();
                    foreground = style.getForeground(attributes);
                    ((AttributedString)this.stringContents.get(i)).addAttribute(TextAttribute.FOREGROUND, foreground, Math.max(0, curElement.getStartOffset() - pEnd.runStart), Math.min(pEnd.runLimit - pEnd.runStart, curElement.getEndOffset() - pEnd.runStart));
                    Font font2 = font = attributes.isDefined(StyleConstants.FontSize) || attributes.isDefined(StyleConstants.FontFamily) ? style.getFont(attributes) : null;
                    if (font == null) {
                        if (this.document instanceof DefaultStyledDocument) {
                            font = style.getFont(((DefaultStyledDocument)this.document).getCharacterElement(pos).getAttributes());
                            if (font == null) {
                                font = style.getFont(((DefaultStyledDocument)this.document).getParagraphElement(pos).getAttributes());
                            }
                            if (font == null) {
                                font = style.getFont(rootElement.getAttributes());
                            }
                        } else {
                            font = style.getFont(rootElement.getAttributes());
                        }
                    }
                    if (font != null) {
                        ((AttributedString)this.stringContents.get(i)).addAttribute(TextAttribute.FONT, font, Math.max(0, curElement.getStartOffset() - pEnd.runStart), Math.min(pEnd.runLimit - pEnd.runStart, curElement.getEndOffset() - pEnd.runStart));
                    }
                    Color color = background = attributes.isDefined(StyleConstants.Background) ? style.getBackground(attributes) : null;
                    if (background != null) {
                        ((AttributedString)this.stringContents.get(i)).addAttribute(TextAttribute.BACKGROUND, background, Math.max(0, curElement.getStartOffset() - pEnd.runStart), Math.min(pEnd.runLimit - pEnd.runStart, curElement.getEndOffset() - pEnd.runStart));
                    }
                    if (underline = StyleConstants.isUnderline(attributes)) {
                        ((AttributedString)this.stringContents.get(i)).addAttribute(TextAttribute.UNDERLINE, Boolean.TRUE, Math.max(0, curElement.getStartOffset() - pEnd.runStart), Math.min(pEnd.runLimit - pEnd.runStart, curElement.getEndOffset() - pEnd.runStart));
                    }
                    if (strikethrough = StyleConstants.isStrikeThrough(attributes)) {
                        ((AttributedString)this.stringContents.get(i)).addAttribute(TextAttribute.STRIKETHROUGH, Boolean.TRUE, Math.max(0, curElement.getStartOffset() - pEnd.runStart), Math.min(pEnd.runLimit - pEnd.runStart, curElement.getEndOffset() - pEnd.runStart));
                    }
                    pos = curElement.getEndOffset();
                }
            } else {
                curElement = rootElement;
                while (!curElement.isLeaf()) {
                    curElement = curElement.getElement(curElement.getElementIndex(pos));
                }
                attributes = curElement.getAttributes();
                foreground = style.getForeground(attributes);
                ((AttributedString)this.stringContents.get(i)).addAttribute(TextAttribute.FOREGROUND, foreground, Math.max(0, curElement.getStartOffset() - pEnd.runStart), Math.min(pEnd.runLimit - pEnd.runStart, curElement.getEndOffset() - pEnd.runStart));
                Font font3 = font = attributes.isDefined(StyleConstants.FontSize) || attributes.isDefined(StyleConstants.FontFamily) ? style.getFont(attributes) : null;
                if (font == null) {
                    if (this.document instanceof DefaultStyledDocument) {
                        font = style.getFont(((DefaultStyledDocument)this.document).getCharacterElement(pos).getAttributes());
                        if (font == null) {
                            font = style.getFont(((DefaultStyledDocument)this.document).getParagraphElement(pos).getAttributes());
                        }
                        if (font == null) {
                            font = style.getFont(rootElement.getAttributes());
                        }
                    } else {
                        font = style.getFont(rootElement.getAttributes());
                    }
                }
                if (font != null) {
                    ((AttributedString)this.stringContents.get(i)).addAttribute(TextAttribute.FONT, font, Math.max(0, curElement.getStartOffset() - pEnd.runStart), Math.min(pEnd.runLimit - pEnd.runStart, curElement.getEndOffset() - pEnd.runStart));
                }
                Color color = background = attributes.isDefined(StyleConstants.Background) ? style.getBackground(attributes) : null;
                if (background != null) {
                    ((AttributedString)this.stringContents.get(i)).addAttribute(TextAttribute.BACKGROUND, background, Math.max(0, curElement.getStartOffset() - pEnd.runStart), Math.min(pEnd.runLimit - pEnd.runStart, curElement.getEndOffset() - pEnd.runStart));
                }
                if (underline = StyleConstants.isUnderline(attributes)) {
                    ((AttributedString)this.stringContents.get(i)).addAttribute(TextAttribute.UNDERLINE, Boolean.TRUE, Math.max(0, curElement.getStartOffset() - pEnd.runStart), Math.min(pEnd.runLimit - pEnd.runStart, curElement.getEndOffset() - pEnd.runStart));
                }
                if (strikethrough = StyleConstants.isStrikeThrough(attributes)) {
                    ((AttributedString)this.stringContents.get(i)).addAttribute(TextAttribute.STRIKETHROUGH, Boolean.TRUE, Math.max(0, curElement.getStartOffset() - pEnd.runStart), Math.min(pEnd.runLimit - pEnd.runStart, curElement.getEndOffset() - pEnd.runStart));
                }
            }
            ++i;
        }
        this.recomputeLayout();
    }

    public void recomputeLayout() {
        if (this.stringContents == null) {
            return;
        }
        ArrayList<LineInfo> linesList = new ArrayList<LineInfo>();
        double textWidth = 0.0;
        double textHeight = 0.0;
        int i = 0;
        while (i < this.stringContents.size()) {
            AttributedString ats = (AttributedString)this.stringContents.get(i);
            AttributedCharacterIterator itr = ats.getIterator();
            ArrayList<Integer> breakList = null;
            LineBreakMeasurer measurer = new LineBreakMeasurer(itr, SWING_FRC);
            breakList = new ArrayList<Integer>();
            while (measurer.getPosition() < itr.getEndIndex()) {
                if (this.constrainWidthToTextWidth) {
                    measurer.nextLayout(Float.MAX_VALUE);
                } else {
                    measurer.nextLayout((float)Math.ceil(this.getWidth() - (double)this.insets.left - (double)this.insets.right));
                }
                breakList.add(new Integer(measurer.getPosition()));
            }
            measurer = new LineBreakMeasurer(itr, PPaintContext.RENDER_QUALITY_HIGH_FRC);
            LineInfo lineInfo = null;
            boolean newLine = true;
            double lineWidth = 0.0;
            while (measurer.getPosition() < itr.getEndIndex()) {
                int lineEnd;
                TextLayout aTextLayout = null;
                if (newLine) {
                    newLine = false;
                    double lineHeight = lineInfo == null ? 0.0 : lineInfo.maxAscent + lineInfo.maxDescent + lineInfo.leading;
                    textHeight += lineHeight;
                    textWidth = Math.max(textWidth, lineWidth);
                    lineInfo = new LineInfo();
                    linesList.add(lineInfo);
                }
                if ((lineEnd = ((Integer)breakList.get(0)).intValue()) <= itr.getRunLimit()) {
                    breakList.remove(0);
                    newLine = true;
                }
                aTextLayout = measurer.nextLayout(Float.MAX_VALUE, Math.min(lineEnd, itr.getRunLimit()), false);
                SegmentInfo sInfo = new SegmentInfo();
                sInfo.font = (Font)itr.getAttribute(TextAttribute.FONT);
                sInfo.foreground = (Color)itr.getAttribute(TextAttribute.FOREGROUND);
                sInfo.background = (Color)itr.getAttribute(TextAttribute.BACKGROUND);
                sInfo.underline = (Boolean)itr.getAttribute(TextAttribute.UNDERLINE);
                sInfo.layout = aTextLayout;
                FontMetrics metrics = StyleContext.getDefaultStyleContext().getFontMetrics((Font)itr.getAttribute(TextAttribute.FONT));
                lineInfo.maxAscent = Math.max(lineInfo.maxAscent, (double)metrics.getMaxAscent());
                lineInfo.maxDescent = Math.max(lineInfo.maxDescent, (double)metrics.getMaxDescent());
                lineInfo.leading = Math.max(lineInfo.leading, (double)metrics.getLeading());
                lineInfo.segments.add(sInfo);
                itr.setIndex(measurer.getPosition());
                lineWidth += (double)aTextLayout.getAdvance();
            }
            double lineHeight = lineInfo == null ? 0.0 : lineInfo.maxAscent + lineInfo.maxDescent + lineInfo.leading;
            textHeight += lineHeight;
            textWidth = Math.max(textWidth, lineWidth);
            ++i;
        }
        this.lines = linesList.toArray(new LineInfo[0]);
        if (this.constrainWidthToTextWidth || this.constrainHeightToTextHeight) {
            double newWidth = this.getWidth();
            double newHeight = this.getHeight();
            if (this.constrainWidthToTextWidth) {
                newWidth = textWidth + (double)this.insets.left + (double)this.insets.right;
            }
            if (this.constrainHeightToTextHeight) {
                newHeight = Math.max(textHeight, this.getInitialFontHeight()) + (double)this.insets.top + (double)this.insets.bottom;
            }
            super.setBounds(this.getX(), this.getY(), newWidth, newHeight);
        }
    }

    public double getInitialFontHeight() {
        Element rootElement;
        Element curElement = rootElement = this.document.getDefaultRootElement();
        while (!curElement.isLeaf()) {
            curElement = curElement.getElement(curElement.getElementIndex(0));
        }
        StyleContext context = StyleContext.getDefaultStyleContext();
        Font font = context.getFont(curElement.getAttributes());
        FontMetrics curFM = context.getFontMetrics(font);
        return curFM.getMaxAscent() + curFM.getMaxDescent() + curFM.getLeading();
    }

    protected void paint(PPaintContext paintContext) {
        float x = (float)(this.getX() + (double)this.insets.left);
        float y = (float)(this.getY() + (double)this.insets.top);
        float bottomY = (float)(this.getY() + this.getHeight() - (double)this.insets.bottom);
        if (this.lines == null || this.lines.length == 0) {
            return;
        }
        Graphics2D g2 = paintContext.getGraphics();
        if (this.getPaint() != null) {
            g2.setPaint(this.getPaint());
            g2.fill(this.getBoundsReference());
        }
        int i = 0;
        while (i < this.lines.length) {
            y = (float)((double)y + this.lines[i].maxAscent);
            float curX = x;
            if (bottomY < y) {
                return;
            }
            int j = 0;
            while (j < this.lines[i].segments.size()) {
                SegmentInfo sInfo = (SegmentInfo)this.lines[i].segments.get(j);
                float width = sInfo.layout.getAdvance();
                if (sInfo.background != null) {
                    g2.setPaint(sInfo.background);
                    g2.fill(new Rectangle2D.Double(curX, (double)y - this.lines[i].maxAscent, width, this.lines[i].maxAscent + this.lines[i].maxDescent + this.lines[i].leading));
                }
                if (sInfo.font != null) {
                    g2.setFont(sInfo.font);
                }
                g2.setPaint(sInfo.foreground);
                sInfo.layout.draw(g2, curX, y);
                if (sInfo.underline != null) {
                    paintLine.setLine(x, (double)y + this.lines[i].maxDescent / 2.0, x + width, (double)y + this.lines[i].maxDescent / 2.0);
                    g2.draw(paintLine);
                }
                curX += width;
                ++j;
            }
            y = (float)((double)y + (this.lines[i].maxDescent + this.lines[i].leading));
            ++i;
        }
    }

    public void fullPaint(PPaintContext paintContext) {
        if (!this.editing) {
            super.fullPaint(paintContext);
        }
    }

    public void setEditing(boolean editing) {
        this.editing = editing;
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void setInsets(Insets insets) {
        if (insets != null) {
            this.insets.left = insets.left;
            this.insets.right = insets.right;
            this.insets.top = insets.top;
            this.insets.bottom = insets.bottom;
            this.recomputeLayout();
        }
    }

    public Insets getInsets() {
        return (Insets)this.insets.clone();
    }

    public boolean setBounds(double x, double y, double w, double h) {
        if (this.document == null || !super.setBounds(x, y, w, h)) {
            return false;
        }
        this.recomputeLayout();
        return true;
    }

    protected static class LineInfo {
        public List segments = new ArrayList();
        public double maxAscent;
        public double maxDescent;
        public double leading;
    }

    protected static class MetricsRunInfo
    extends RunInfo {
        public FontMetrics metrics;
    }

    protected static class RunInfo {
        public int runStart;
        public int runLimit;

        public RunInfo() {
        }

        public RunInfo(int runStart, int runLimit) {
            this.runStart = runStart;
            this.runLimit = runLimit;
        }
    }

    protected static class SegmentInfo {
        public TextLayout layout;
        public Font font;
        public Color foreground;
        public Color background;
        public Boolean underline;
    }
}

