/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ast.factory;

import java.util.ArrayList;
import java.util.List;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.Expr;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.NameTokType;
import org.python.pydev.parser.jython.ast.argumentsType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.refactoring.ast.adapters.AdapterPrefs;
import org.python.pydev.refactoring.ast.visitors.NodeHelper;

public class PyAstFactory {
    NodeHelper nodeHelper;

    public PyAstFactory(AdapterPrefs adapterPrefs) {
        this.nodeHelper = new NodeHelper(adapterPrefs);
    }

    public FunctionDef createFunctionDef(String name) {
        FunctionDef functionDef = new FunctionDef((NameTokType)new NameTok(name, 2), null, null, null, null);
        return functionDef;
    }

    public FunctionDef createSetterFunctionDef(String accessorName, String attributeName) {
        NameTok functionName = new NameTok(accessorName, 2);
        argumentsType args = this.createArguments(true, "value");
        stmtType[] body = this.createSetterBody(attributeName);
        return new FunctionDef((NameTokType)functionName, args, body, null, null);
    }

    public argumentsType createArguments(boolean addSelf, String ... simpleParams) {
        ArrayList<Name> params = new ArrayList<Name>();
        if (addSelf) {
            params.add(new Name("self", 6, true));
        }
        String[] stringArray = simpleParams;
        int n = simpleParams.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            params.add(new Name(s, 6, false));
            ++n2;
        }
        return new argumentsType(params.toArray(new exprType[params.size()]), null, null, null, null, null, null, null, null, null);
    }

    private stmtType[] createSetterBody(String attributeName) {
        Name self = new Name("self", 1, true);
        NameTok name = new NameTok(this.nodeHelper.getPrivateAttr(attributeName), 8);
        Attribute attribute = new Attribute((exprType)self, (NameTokType)name, 2);
        Name value = new Name("value", 1, false);
        Assign assign = new Assign(new exprType[]{attribute}, (exprType)value);
        return new stmtType[]{assign};
    }

    public Call createCall(String call, String ... params) {
        if (call.indexOf(".") != -1) {
            ArrayList<Name> lst = new ArrayList<Name>();
            String[] stringArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                lst.add(new Name(p, 6, false));
                ++n2;
            }
            return new Call((exprType)this.createAttribute(call), (exprType[])lst.toArray(new Name[lst.size()]), null, null, null);
        }
        throw new RuntimeException("Unhandled.");
    }

    public Attribute createAttribute(String attribute) {
        List splitted = StringUtils.split((String)attribute, (char)'.');
        if (splitted.size() != 2) {
            throw new RuntimeException("Only handling attributes with 1 dot for now.");
        }
        return new Attribute((exprType)new Name((String)splitted.get(0), 1, false), (NameTokType)new NameTok((String)splitted.get(1), 8), 1);
    }

    public Assign createAssign(exprType ... targetsAndVal) {
        exprType[] targets = new exprType[targetsAndVal.length - 1];
        System.arraycopy(targetsAndVal, 0, targets, 0, targets.length);
        exprType value = targetsAndVal[targetsAndVal.length - 1];
        return new Assign(targets, value);
    }

    public void setBody(FunctionDef functionDef, Object ... body) {
        ArrayList<Object> newBody = new ArrayList<Object>();
        Object[] objectArray = body;
        int n = body.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof exprType) {
                newBody.add(new Expr((exprType)o));
            } else if (o instanceof stmtType) {
                newBody.add((stmtType)o);
            } else {
                throw new RuntimeException("Unhandled: " + o);
            }
            ++n2;
        }
        functionDef.body = newBody.toArray(new stmtType[newBody.size()]);
    }
}

