/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ui.pages;

import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.python.pydev.refactoring.codegenerator.constructorfield.ConstructorFieldRefactoring;
import org.python.pydev.refactoring.codegenerator.constructorfield.ConstructorFieldRequestProcessor;
import org.python.pydev.refactoring.core.model.OffsetStrategyModel;
import org.python.pydev.refactoring.core.model.OffsetStrategyProvider;
import org.python.pydev.refactoring.core.model.constructorfield.ClassFieldTreeProvider;
import org.python.pydev.refactoring.messages.Messages;
import org.python.pydev.refactoring.ui.core.TreeLabelProvider;

public class ConstructorFieldPage
extends UserInputWizardPage {
    public static final String PAGE_NAME = "ConstructorFieldPage";
    private final OffsetStrategyProvider strategyProvider;
    private Composite mainComp = null;
    private Composite buttonComp = null;
    private Button selectAll = null;
    private Button deselectAll = null;
    private CLabel cLabel = null;
    private Composite treeComp = null;
    private Composite comboComp = null;
    private ComboViewer methodInsertionComb = null;
    private CLabel methodInsertionLbl = null;
    private ContainerCheckedTreeViewer treeViewer = null;
    private ClassFieldTreeProvider classProvider;
    private ILabelProvider labelProvider;

    public ConstructorFieldPage(ClassFieldTreeProvider provider) {
        super(PAGE_NAME);
        this.classProvider = provider;
        this.labelProvider = new TreeLabelProvider();
        this.strategyProvider = new OffsetStrategyProvider(7);
    }

    private Composite createMainComp(Composite parent) {
        GridData gridData12 = new GridData();
        gridData12.horizontalSpan = 2;
        GridData gridData11 = new GridData();
        gridData11.horizontalSpan = 2;
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        this.mainComp = new Composite(parent, 0);
        this.mainComp.setLayoutData((Object)gridData);
        this.cLabel = new CLabel(this.mainComp, 0);
        this.cLabel.setText(Messages.constructorFieldSelect);
        this.cLabel.setLayoutData((Object)gridData11);
        this.createTreeComp();
        this.createButtonComp();
        this.mainComp.setLayout((Layout)gridLayout2);
        this.createComboComp();
        return this.mainComp;
    }

    private void createButtonComp() {
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 2;
        gridData3.verticalAlignment = 1;
        GridData gridData2 = new GridData();
        gridData2.widthHint = 80;
        GridData gridData1 = new GridData();
        gridData1.widthHint = 80;
        this.buttonComp = new Composite(this.mainComp, 0);
        this.buttonComp.setLayout((Layout)new GridLayout());
        this.buttonComp.setLayoutData((Object)gridData3);
        this.selectAll = new Button(this.buttonComp, 0);
        this.selectAll.setText(Messages.wizardSelectAll);
        this.selectAll.setLayoutData((Object)gridData2);
        this.selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConstructorFieldPage.this.treeViewer.setAllChecked(true);
                ConstructorFieldPage.this.getRequestProcessor().setCheckedElements(ConstructorFieldPage.this.treeViewer.getCheckedElements());
                ConstructorFieldPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.deselectAll = new Button(this.buttonComp, 0);
        this.deselectAll.setText(Messages.wizardDeselectAll);
        this.deselectAll.setLayoutData((Object)gridData1);
        this.deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConstructorFieldPage.this.treeViewer.setAllChecked(false);
                ConstructorFieldPage.this.getRequestProcessor().setCheckedElements(ConstructorFieldPage.this.treeViewer.getCheckedElements());
                ConstructorFieldPage.this.getWizard().getContainer().updateButtons();
            }
        });
    }

    private void createTreeComp() {
        GridData gridData5 = new GridData();
        gridData5.horizontalAlignment = 4;
        gridData5.grabExcessHorizontalSpace = true;
        gridData5.grabExcessVerticalSpace = true;
        gridData5.verticalAlignment = 4;
        this.treeComp = new Composite(this.mainComp, 0);
        this.treeComp.setLayout((Layout)new FillLayout());
        this.treeComp.setLayoutData((Object)gridData5);
        this.createTreeViewer(this.treeComp);
    }

    private void createComboComp() {
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 512;
        GridData gridData7 = new GridData();
        gridData7.horizontalSpan = 2;
        gridData7.verticalAlignment = 2;
        gridData7.grabExcessHorizontalSpace = true;
        gridData7.horizontalAlignment = 4;
        this.comboComp = new Composite(this.mainComp, 0);
        this.comboComp.setLayoutData((Object)gridData7);
        this.comboComp.setLayout((Layout)fillLayout);
        this.methodInsertionLbl = new CLabel(this.comboComp, 0);
        this.methodInsertionLbl.setText(Messages.offsetStrategyInsertionPointMethod);
        this.methodInsertionComb = this.createComboViewer(this.comboComp);
        this.methodInsertionComb.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (!sel.isEmpty()) {
                    OffsetStrategyModel elem = (OffsetStrategyModel)((Object)sel.getFirstElement());
                    ConstructorFieldPage.this.getRequestProcessor().setMethodDestination(elem.getStrategy());
                }
            }
        });
        this.getRequestProcessor().setMethodDestination(this.strategyProvider.get(0).getStrategy());
        this.methodInsertionComb.getCombo().select(0);
    }

    private void createTreeViewer(Composite treeComp) {
        this.treeViewer = new ContainerCheckedTreeViewer(treeComp);
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ConstructorFieldPage.this.getRequestProcessor().setCheckedElements(ConstructorFieldPage.this.treeViewer.getCheckedElements());
                ConstructorFieldPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.treeViewer.setContentProvider((IContentProvider)this.classProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.setAutoExpandLevel(2);
        this.treeViewer.setInput((Object)"");
        this.treeViewer.setSelection((ISelection)new StructuredSelection(this.treeViewer.getExpandedElements()[0]));
    }

    public void createControl(Composite composite) {
        Composite main = this.createMainComp(composite);
        main.pack();
        this.setControl((Control)main);
    }

    private ComboViewer createComboViewer(Composite comboComp) {
        ComboViewer v = new ComboViewer(comboComp);
        v.setContentProvider((IContentProvider)this.strategyProvider);
        v.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        v.setInput((Object)"");
        return v;
    }

    private ConstructorFieldRequestProcessor getRequestProcessor() {
        return this.getConstructorFieldRefactoring().getRequestProcesor();
    }

    public ConstructorFieldRefactoring getConstructorFieldRefactoring() {
        return (ConstructorFieldRefactoring)this.getRefactoring();
    }

    public boolean canFlipToNextPage() {
        return this.treeViewer.getCheckedElements().length > 0;
    }
}

