/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole;

import java.util.List;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.ui.console.IConsoleFactory;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.Tuple4;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.newconsole.PydevConsole;
import org.python.pydev.debug.newconsole.PydevConsoleCommunication;
import org.python.pydev.debug.newconsole.PydevConsoleInterpreter;
import org.python.pydev.debug.newconsole.env.IProcessFactory;
import org.python.pydev.debug.newconsole.env.UserCanceledException;
import org.python.pydev.dltk.console.ui.ScriptConsole;
import org.python.pydev.dltk.console.ui.ScriptConsoleManager;
import org.python.pydev.plugin.PydevPlugin;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PydevConsoleFactory
implements IConsoleFactory {
    public void openConsole() {
        this.createConsole();
    }

    public PydevConsole createConsole() {
        try {
            return this.createConsole(PydevConsoleFactory.createDefaultPydevInterpreter(), null);
        }
        catch (Exception e) {
            PydevPlugin.log((Throwable)e);
            return null;
        }
    }

    public PydevConsole createConsole(PydevConsoleInterpreter interpreter, String additionalInitialComands) {
        ScriptConsoleManager manager = ScriptConsoleManager.getInstance();
        try {
            if (interpreter != null) {
                PydevConsole console = new PydevConsole(interpreter, additionalInitialComands);
                manager.add((ScriptConsole)console, true);
                return console;
            }
        }
        catch (Exception e) {
            PydevPlugin.log((Throwable)e);
        }
        return null;
    }

    public static PydevConsoleInterpreter createDefaultPydevInterpreter() throws Exception, UserCanceledException {
        IProcessFactory iprocessFactory = new IProcessFactory();
        Tuple4<Launch, Process, Integer, IInterpreterInfo> launchAndProcess = iprocessFactory.createInteractiveLaunch();
        if (launchAndProcess == null) {
            return null;
        }
        return PydevConsoleFactory.createPydevInterpreter((ILaunch)launchAndProcess.o1, (Process)launchAndProcess.o2, (Integer)launchAndProcess.o3, (IInterpreterInfo)launchAndProcess.o4, iprocessFactory.getNaturesUsed());
    }

    public static PydevConsoleInterpreter createPydevInterpreter(final ILaunch launch, Process process, Integer clientPort, IInterpreterInfo interpreterInfo, List<IPythonNature> natures) throws Exception {
        if (launch == null) {
            return null;
        }
        PydevConsoleInterpreter consoleInterpreter = new PydevConsoleInterpreter();
        int port = Integer.parseInt(launch.getAttribute("INTERACTIVE_LAUNCH_PORT"));
        consoleInterpreter.setConsoleCommunication(new PydevConsoleCommunication(port, process, clientPort));
        consoleInterpreter.setNaturesUsed(natures);
        consoleInterpreter.setInterpreterInfo(interpreterInfo);
        PydevDebugPlugin.getDefault().addConsoleLaunch(launch);
        consoleInterpreter.addCloseOperation(new Runnable(){

            public void run() {
                PydevDebugPlugin.getDefault().removeConsoleLaunch(launch);
            }
        });
        return consoleInterpreter;
    }
}

