/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.tabnanny;

import com.python.pydev.analysis.IAnalysisPreferences;
import com.python.pydev.analysis.messages.IMessage;
import com.python.pydev.analysis.messages.Message;
import com.python.pydev.analysis.tabnanny.TabNannyDocIterator;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.python.pydev.core.IIndentPrefs;
import org.python.pydev.core.Tuple3;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.plugin.PydevPlugin;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabNanny {
    public static List<IMessage> analyzeDoc(IDocument doc, IAnalysisPreferences analysisPrefs, String moduleName, IIndentPrefs indentPrefs, IProgressMonitor monitor) {
        char errorChar;
        String errorMsg;
        ArrayList<Tuple3<String, Integer, Boolean>> errorsAre;
        ArrayList<IMessage> ret = new ArrayList<IMessage>();
        if (analysisPrefs.getSeverityForType(12) == 0) {
            return ret;
        }
        ArrayList<Tuple3<String, Integer, Boolean>> foundTabs = new ArrayList<Tuple3<String, Integer, Boolean>>();
        ArrayList<Tuple3<String, Integer, Boolean>> foundSpaces = new ArrayList<Tuple3<String, Integer, Boolean>>();
        TabNannyDocIterator it = new TabNannyDocIterator(doc);
        while (it.hasNext()) {
            Tuple3<String, Integer, Boolean> indentation = it.next();
            if (((String)indentation.o1).indexOf(9) != -1) {
                foundTabs.add(indentation);
            }
            if (((String)indentation.o1).indexOf(32) != -1) {
                foundSpaces.add(indentation);
            }
            if (!monitor.isCanceled()) continue;
            return ret;
        }
        int spacesFoundSize = foundSpaces.size();
        int tabsFoundSize = foundTabs.size();
        if (spacesFoundSize == 0 && tabsFoundSize == 0) {
            return ret;
        }
        boolean markTabsAsError = spacesFoundSize == tabsFoundSize ? indentPrefs.getUseSpaces() : tabsFoundSize <= spacesFoundSize;
        if (markTabsAsError) {
            ArrayList<Tuple3<String, Integer, Boolean>> validsAre = foundSpaces;
            errorsAre = foundTabs;
            errorMsg = "Mixed Indentation: Tab found";
            errorChar = '\t';
            TabNanny.createBadIndentForSpacesMessages(doc, analysisPrefs, indentPrefs, ret, validsAre, monitor);
        } else {
            ArrayList<Tuple3<String, Integer, Boolean>> validsAre = foundTabs;
            errorsAre = foundSpaces;
            errorMsg = "Mixed Indentation: Spaces found";
            errorChar = ' ';
        }
        TabNanny.createMixedErrorMessages(doc, analysisPrefs, ret, errorsAre, errorMsg, errorChar, monitor);
        return ret;
    }

    private static void createBadIndentForSpacesMessages(IDocument doc, IAnalysisPreferences analysisPrefs, IIndentPrefs indentPrefs, ArrayList<IMessage> ret, List<Tuple3<String, Integer, Boolean>> validsAre, IProgressMonitor monitor) {
        int tabWidth = indentPrefs.getTabWidth();
        FastStringBuffer buffer = new FastStringBuffer();
        for (Tuple3<String, Integer, Boolean> indentation : validsAre) {
            int lenFound;
            int extraChars;
            String indentStr;
            if (monitor.isCanceled()) {
                return;
            }
            if (!((Boolean)indentation.o3).booleanValue() || (indentStr = (String)indentation.o1).indexOf("\t") != -1 || (extraChars = (lenFound = indentStr.length()) % tabWidth) == 0) continue;
            Integer offset = (Integer)indentation.o2;
            int startLine = PySelection.getLineOfOffset((IDocument)doc, (int)offset) + 1;
            int startCol = 1;
            int endCol = startCol + lenFound;
            buffer.clear();
            ret.add(new Message(12, buffer.append("Bad Indentation (").append(lenFound).append(" spaces)").toString(), startLine, startLine, startCol, endCol, analysisPrefs));
        }
    }

    private static void createMixedErrorMessages(IDocument doc, IAnalysisPreferences analysisPrefs, ArrayList<IMessage> ret, List<Tuple3<String, Integer, Boolean>> errorsAre, String errorMsg, char errorChar, IProgressMonitor monitor) {
        for (Tuple3<String, Integer, Boolean> indentation : errorsAre) {
            if (monitor.isCanceled()) {
                return;
            }
            Integer offset = (Integer)indentation.o2;
            int startLine = PySelection.getLineOfOffset((IDocument)doc, (int)offset) + 1;
            try {
                IRegion region = doc.getLineInformationOfOffset(offset.intValue());
                int startCol = offset - region.getOffset() + 1;
                String indentationString = (String)indentation.o1;
                int charIndex = indentationString.indexOf(errorChar);
                int endCol = startCol += charIndex;
                int indentationStringLen = indentationString.length();
                while (endCol <= indentationStringLen) {
                    if (indentationString.charAt(endCol - 1) != errorChar) break;
                    ++endCol;
                }
                ret.add(new Message(12, errorMsg, startLine, startLine, startCol, endCol, analysisPrefs));
            }
            catch (BadLocationException e) {
                PydevPlugin.log((Throwable)e);
            }
        }
    }
}

