/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.additionalinfo;

import com.python.pydev.analysis.AnalysisPlugin;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalDependencyInfo;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalInterpreterInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalSystemInterpreterInfo;
import com.python.pydev.analysis.additionalinfo.IInfo;
import java.io.File;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.python.pydev.core.DeltaSaver;
import org.python.pydev.core.ICallback;
import org.python.pydev.core.IDeltaProcessor;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdditionalProjectInterpreterInfo
extends AbstractAdditionalDependencyInfo
implements IDeltaProcessor<Object> {
    private IProject project;
    private static Map<String, AbstractAdditionalDependencyInfo> additionalNatureInfo = new HashMap<String, AbstractAdditionalDependencyInfo>();
    protected DeltaSaver<Object> deltaSaver;
    public static final int MAXIMUN_NUMBER_OF_DELTAS = 100;

    public IProject getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void add(IInfo info, boolean generateDelta, int doOn) {
        Object object = this.lock;
        synchronized (object) {
            super.add(info, generateDelta, doOn);
            if (generateDelta) {
                this.deltaSaver.addInsertCommand((Object)info);
                this.checkDeltaSize();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInfoFromModule(String moduleName, boolean generateDelta) {
        Object object = this.lock;
        synchronized (object) {
            super.removeInfoFromModule(moduleName, generateDelta);
            if (generateDelta) {
                this.deltaSaver.addDeleteCommand((Object)moduleName);
                this.checkDeltaSize();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void restoreSavedInfo(Object o) throws MisconfigurationException {
        Object object = this.lock;
        synchronized (object) {
            super.restoreSavedInfo(o);
            if (this.deltaSaver.availableDeltas() > 0) {
                this.deltaSaver.processDeltas((IDeltaProcessor)this);
            }
        }
    }

    @Override
    protected File getPersistingFolder() {
        try {
            Assert.isNotNull((Object)this.project);
            return AnalysisPlugin.getStorageDirForProject(this.project);
        }
        catch (NullPointerException e) {
            PydevPlugin.log((int)4, (String)"Error getting persisting folder", (Throwable)e, (boolean)false);
            return new File(".");
        }
    }

    protected DeltaSaver<Object> createDeltaSaver() {
        return new DeltaSaver(this.getPersistingFolder(), "projectinfodelta", (ICallback)new ICallback<Object, ObjectInputStream>(){

            public Object call(ObjectInputStream arg) {
                try {
                    return arg.readObject();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public /* synthetic */ Object call(Object object) {
                return this.call((ObjectInputStream)object);
            }
        });
    }

    public void processUpdate(Object data) {
        throw new RuntimeException("There is no update generation, only add.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDelete(Object data) {
        Object object = this.lock;
        synchronized (object) {
            this.removeInfoFromModule((String)data, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processInsert(Object data) {
        Object object = this.lock;
        synchronized (object) {
            IInfo info = (IInfo)data;
            if (info.getPath() == null || info.getPath().length() == 0) {
                this.add(info, false, 1);
            } else {
                this.add(info, false, 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endProcessing() {
        Object object = this.lock;
        synchronized (object) {
            this.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDeltaSize() {
        Object object = this.lock;
        synchronized (object) {
            if (this.deltaSaver.availableDeltas() > 100) {
                this.save();
                this.deltaSaver.clearAll();
            }
        }
    }

    public AdditionalProjectInterpreterInfo(IProject project) throws MisconfigurationException {
        super(false);
        this.project = project;
        this.init();
        this.deltaSaver = this.createDeltaSaver();
    }

    @Override
    protected File getPersistingLocation() {
        return new File(this.getPersistingFolder(), "AdditionalProjectInterpreterInfo.pydevinfo");
    }

    @Override
    protected void setAsDefaultInfo() {
        AdditionalProjectInterpreterInfo.setAdditionalInfoForProject(this.project, this);
    }

    public static void saveAdditionalInfoForProject(IPythonNature nature) throws MisconfigurationException {
        AbstractAdditionalDependencyInfo info = AdditionalProjectInterpreterInfo.getAdditionalInfoForProject(nature);
        info.save();
    }

    public static List<AbstractAdditionalInterpreterInfo> getAdditionalInfo(IPythonNature nature) throws MisconfigurationException {
        return AdditionalProjectInterpreterInfo.getAdditionalInfo(nature, true, false);
    }

    public static List<AbstractAdditionalInterpreterInfo> getAdditionalInfo(IPythonNature nature, boolean addSystemInfo, boolean addReferencingProjects) throws MisconfigurationException {
        return (List)AdditionalProjectInterpreterInfo.getAdditionalInfoAndNature((IPythonNature)nature, (boolean)addSystemInfo, (boolean)addReferencingProjects).o1;
    }

    public static Tuple<List<AbstractAdditionalInterpreterInfo>, List<IPythonNature>> getAdditionalInfoAndNature(IPythonNature nature, boolean addSystemInfo, boolean addReferencingProjects) throws MisconfigurationException {
        ArrayList<AbstractAdditionalInterpreterInfo> ret = new ArrayList<AbstractAdditionalInterpreterInfo>();
        ArrayList<Object> natures = new ArrayList<Object>();
        IProject project = nature.getProject();
        if (addSystemInfo) {
            AbstractAdditionalInterpreterInfo systemInfo;
            try {
                systemInfo = AdditionalSystemInterpreterInfo.getAdditionalSystemInfo(PydevPlugin.getInterpreterManager((IPythonNature)nature), nature.getProjectInterpreter().getExecutableOrJar());
            }
            catch (MisconfigurationException e) {
                throw e;
            }
            catch (PythonNatureWithoutProjectException e) {
                throw new RuntimeException(e);
            }
            ret.add(systemInfo);
        }
        if (project != null) {
            AbstractAdditionalDependencyInfo additionalInfoForProject = AdditionalProjectInterpreterInfo.getAdditionalInfoForProject(nature);
            if (additionalInfoForProject != null) {
                ret.add(additionalInfoForProject);
                natures.add(nature);
            }
            try {
                IProject[] referencedProjects;
                IProject[] iProjectArray = referencedProjects = project.getReferencedProjects();
                int n = referencedProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject refProject = iProjectArray[n2];
                    additionalInfoForProject = AdditionalProjectInterpreterInfo.getAdditionalInfoForProject((IPythonNature)PythonNature.getPythonNature((IProject)refProject));
                    if (additionalInfoForProject != null) {
                        ret.add(additionalInfoForProject);
                        natures.add(PythonNature.getPythonNature((IProject)refProject));
                    }
                    ++n2;
                }
                if (addReferencingProjects) {
                    IProject[] referencingProjects;
                    IProject[] iProjectArray2 = referencingProjects = project.getReferencingProjects();
                    int n3 = referencingProjects.length;
                    n = 0;
                    while (n < n3) {
                        IProject refProject = iProjectArray2[n];
                        additionalInfoForProject = AdditionalProjectInterpreterInfo.getAdditionalInfoForProject((IPythonNature)PythonNature.getPythonNature((IProject)refProject));
                        if (additionalInfoForProject != null) {
                            ret.add(additionalInfoForProject);
                            natures.add(PythonNature.getPythonNature((IProject)refProject));
                        }
                        ++n;
                    }
                }
            }
            catch (CoreException e) {
                PydevPlugin.log((Throwable)e);
            }
        }
        return new Tuple(ret, natures);
    }

    public static AbstractAdditionalDependencyInfo getAdditionalInfoForProject(IPythonNature nature) throws MisconfigurationException {
        if (nature == null) {
            return null;
        }
        IProject project = nature.getProject();
        if (project == null) {
            return null;
        }
        String name = REF.getValidProjectName((IProject)project);
        AbstractAdditionalDependencyInfo info = additionalNatureInfo.get(name);
        if (info == null) {
            info = new AdditionalProjectInterpreterInfo(project);
            additionalNatureInfo.put(name, info);
        }
        return info;
    }

    public static void setAdditionalInfoForProject(IProject project, AbstractAdditionalDependencyInfo info) {
        additionalNatureInfo.put(REF.getValidProjectName((IProject)project), info);
    }

    public static boolean loadAdditionalInfoForProject(IPythonNature nature) throws MisconfigurationException {
        AbstractAdditionalDependencyInfo info = AdditionalProjectInterpreterInfo.getAdditionalInfoForProject(nature);
        return info.load();
    }

    public static List<IInfo> getTokensEqualTo(String qualifier, IPythonNature nature, int getWhat) throws MisconfigurationException {
        ArrayList<IInfo> ret = new ArrayList<IInfo>();
        List<AbstractAdditionalInterpreterInfo> additionalInfo = AdditionalProjectInterpreterInfo.getAdditionalInfo(nature);
        for (AbstractAdditionalInterpreterInfo info : additionalInfo) {
            ret.addAll(info.getTokensEqualTo(qualifier, getWhat));
        }
        return ret;
    }

    public static List<IInfo> getTokensStartingWith(String qualifier, IPythonNature nature, int getWhat) throws MisconfigurationException {
        ArrayList<IInfo> ret = new ArrayList<IInfo>();
        List<AbstractAdditionalInterpreterInfo> additionalInfo = AdditionalProjectInterpreterInfo.getAdditionalInfo(nature);
        for (AbstractAdditionalInterpreterInfo info : additionalInfo) {
            ret.addAll(info.getTokensStartingWith(qualifier, getWhat));
        }
        return ret;
    }

    public static List<AbstractAdditionalDependencyInfo> getAdditionalInfoForProjectAndReferencing(IPythonNature nature) throws MisconfigurationException {
        IProject[] referencingProjects;
        ArrayList<AbstractAdditionalDependencyInfo> ret = new ArrayList<AbstractAdditionalDependencyInfo>();
        ret.add(AdditionalProjectInterpreterInfo.getAdditionalInfoForProject(nature));
        IProject project = nature.getProject();
        IProject[] iProjectArray = referencingProjects = project.getReferencingProjects();
        int n = referencingProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            AbstractAdditionalDependencyInfo info2 = AdditionalProjectInterpreterInfo.getAdditionalInfoForProject((IPythonNature)PythonNature.getPythonNature((IProject)p));
            if (info2 != null) {
                ret.add(info2);
            }
            ++n2;
        }
        return ret;
    }
}

