/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.outline;

import com.rc.retroweaver.runtime.ClassLiteral;
import java.net.MalformedURLException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.python.pydev.core.bundle.ImageCache;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.outline.IOutlineModel;
import org.python.pydev.outline.OutlineHideCommentsAction;
import org.python.pydev.outline.OutlineHideFieldsAction;
import org.python.pydev.outline.OutlineHideImportsAction;
import org.python.pydev.outline.OutlineHideMagicObjectsAction;
import org.python.pydev.outline.OutlineHideNonPublicMembersAction;
import org.python.pydev.outline.OutlineHideStaticMethodsAction;
import org.python.pydev.outline.OutlineLinkWithEditorAction;
import org.python.pydev.outline.OutlineSortByNameAction;
import org.python.pydev.outline.ParsedContentProvider;
import org.python.pydev.outline.ParsedItem;
import org.python.pydev.outline.ParsedLabelProvider;
import org.python.pydev.outline.ParsedModel;
import org.python.pydev.parser.ErrorDescription;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.plugin.PydevPlugin;

public class PyOutlinePage
extends ContentOutlinePage
implements IShowInTarget,
IAdaptable {
    PyEdit editorView;
    IDocument document;
    IOutlineModel model;
    ImageCache imageCache;
    ISelectionChangedListener selectionListener;
    private OutlineLinkWithEditorAction linkWithEditor;
    private int linkLevel = 1;
    private Object lock = new Object();

    public PyOutlinePage(PyEdit editorView) {
        this.editorView = editorView;
        this.imageCache = new ImageCache(PydevPlugin.getDefault().getBundle().getEntry("/"));
    }

    public void dispose() {
        if (this.model != null) {
            this.model.dispose();
            this.model = null;
        }
        if (this.selectionListener != null) {
            this.removeSelectionChangedListener(this.selectionListener);
        }
        if (this.imageCache != null) {
            this.imageCache.dispose();
        }
        if (this.linkWithEditor != null) {
            this.linkWithEditor.dispose();
            this.linkWithEditor = null;
        }
        super.dispose();
    }

    private void createParsedOutline() {
        TreeViewer tree = this.getTreeViewer();
        IDocumentProvider provider = this.editorView.getDocumentProvider();
        this.document = provider.getDocument((Object)this.editorView.getEditorInput());
        this.model = this.getParsedModel();
        tree.setAutoExpandLevel(-1);
        tree.setContentProvider((IContentProvider)new ParsedContentProvider());
        tree.setLabelProvider((IBaseLabelProvider)new ParsedLabelProvider(this.imageCache));
        tree.setInput((Object)this.model.getRoot());
    }

    public ParsedModel getParsedModel() {
        return new ParsedModel(this, this.editorView);
    }

    public boolean isDisposed() {
        return this.getTreeViewer().getTree().isDisposed();
    }

    /*
     * Unable to fully structure code
     */
    public void refreshItems(Object[] items) {
        block14: {
            try {
                block15: {
                    this.unlinkAll();
                    viewer = this.getTreeViewer();
                    if (viewer == null) break block14;
                    treeWidget = viewer.getTree();
                    if (this.isDisposed()) {
                        return;
                    }
                    bar = treeWidget.getVerticalBar();
                    barPosition = 0;
                    if (bar != null) {
                        barPosition = bar.getSelection();
                    }
                    if (items != null) break block15;
                    if (this.isDisposed()) {
                        return;
                    }
                    viewer.refresh();
                    ** GOTO lbl26
                }
                if (this.isDisposed()) {
                    return;
                }
                try {
                    i = 0;
                    while (i < items.length) {
                        viewer.refresh(items[i]);
                        ++i;
                    }
lbl26:
                    // 2 sources

                    if (barPosition != 0) {
                        bar.setSelection(Math.min(bar.getMaximum(), barPosition));
                    }
                }
                catch (Throwable e) {
                    PydevPlugin.log(e);
                }
            }
            finally {
                this.relinkAll();
            }
        }
    }

    public void updateItems(Object[] items) {
        try {
            this.unlinkAll();
            if (this.isDisposed()) {
                return;
            }
            TreeViewer tree = this.getTreeViewer();
            if (tree != null) {
                tree.update(items, null);
            }
        }
        finally {
            this.relinkAll();
        }
    }

    IPreferenceStore getStore() {
        return PydevPlugin.getDefault().getPreferenceStore();
    }

    public TreeViewer getTreeViewer() {
        return super.getTreeViewer();
    }

    private void createActions() {
        this.linkWithEditor = new OutlineLinkWithEditorAction(this, this.imageCache);
        Action collapseAll = new Action("Collapse all", 1){

            public void run() {
                PyOutlinePage.this.getTreeViewer().collapseAll();
            }
        };
        Action expandAll = new Action("Expand all", 1){

            public void run() {
                PyOutlinePage.this.getTreeViewer().expandAll();
            }
        };
        try {
            collapseAll.setImageDescriptor(this.imageCache.getDescriptor("icons/collapseall.gif"));
            expandAll.setImageDescriptor(this.imageCache.getDescriptor("icons/expand.gif"));
        }
        catch (MalformedURLException e) {
            PydevPlugin.log("Missing Icon", e);
        }
        IActionBars actionBars = this.getSite().getActionBars();
        IToolBarManager toolbarManager = actionBars.getToolBarManager();
        toolbarManager.add((IAction)new OutlineSortByNameAction(this, this.imageCache));
        toolbarManager.add((IAction)collapseAll);
        toolbarManager.add((IAction)expandAll);
        IMenuManager menuManager = actionBars.getMenuManager();
        menuManager.add((IAction)this.linkWithEditor);
        menuManager.add((IAction)new OutlineHideCommentsAction(this, this.imageCache));
        menuManager.add((IAction)new OutlineHideImportsAction(this, this.imageCache));
        menuManager.add((IAction)new OutlineHideMagicObjectsAction(this, this.imageCache));
        menuManager.add((IAction)new OutlineHideFieldsAction(this, this.imageCache));
        menuManager.add((IAction)new OutlineHideNonPublicMembersAction(this, this.imageCache));
        menuManager.add((IAction)new OutlineHideStaticMethodsAction(this, this.imageCache));
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        try {
            this.createParsedOutline();
            this.selectionListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (PyOutlinePage.this.linkWithEditor == null) {
                        return;
                    }
                    try {
                        ParsedItem firstElement;
                        ErrorDescription errorDesc;
                        PyOutlinePage.this.unlinkAll();
                        StructuredSelection sel = (StructuredSelection)event.getSelection();
                        boolean alreadySelected = false;
                        if (sel.size() == 1 && (errorDesc = (firstElement = (ParsedItem)sel.getFirstElement()).getErrorDesc()) != null && errorDesc.message != null) {
                            int len = errorDesc.errorEnd - errorDesc.errorStart;
                            PyOutlinePage.this.editorView.setSelection(errorDesc.errorStart, len);
                            alreadySelected = true;
                        }
                        if (!alreadySelected) {
                            SimpleNode[] node = PyOutlinePage.this.model.getSelectionPosition(sel);
                            PyOutlinePage.this.editorView.revealModelNodes(node);
                        }
                    }
                    finally {
                        PyOutlinePage.this.relinkAll();
                    }
                }
            };
            this.addSelectionChangedListener(this.selectionListener);
            this.createActions();
            TreeViewer treeViewer = this.getTreeViewer();
            treeViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            Tree tree = treeViewer.getTree();
            tree.addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                    PyOutlinePage.this.tryToMakeSelection();
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                    PyOutlinePage.this.tryToMakeSelection();
                }
            });
            tree.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                    if (e.keyCode == 0x1000001 || e.keyCode == 0x1000002) {
                        PyOutlinePage.this.tryToMakeSelection();
                    }
                }
            });
        }
        catch (Throwable e) {
            PydevPlugin.log(e);
        }
    }

    public boolean show(ShowInContext context) {
        this.linkWithEditor.doLinkOutlinePosition(this.editorView, this, new PySelection((ITextEditor)this.editorView));
        return true;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ClassLiteral.getClass((String)"org/eclipse/ui/part/IShowInTarget")) {
            return this;
        }
        return null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlinkAll() {
        Object object = this.lock;
        synchronized (object) {
            --this.linkLevel;
            if (this.linkLevel == 0) {
                this.removeSelectionChangedListener(this.selectionListener);
                if (this.linkWithEditor != null) {
                    this.linkWithEditor.unlink();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void relinkAll() {
        Object object = this.lock;
        synchronized (object) {
            ++this.linkLevel;
            if (this.linkLevel == 1) {
                this.addSelectionChangedListener(this.selectionListener);
                if (this.linkWithEditor != null) {
                    this.linkWithEditor.relink();
                }
            } else if (this.linkLevel > 1) {
                throw new RuntimeException("Error: relinking without unlinking 1st");
            }
        }
    }

    private SelectionChangedEvent createSelectionEvent() {
        IStructuredSelection s;
        SelectionChangedEvent event = null;
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection && (s = (IStructuredSelection)selection).iterator().hasNext()) {
            event = new SelectionChangedEvent((ISelectionProvider)this.getTreeViewer(), selection);
        }
        return event;
    }

    private void tryToMakeSelection() {
        SelectionChangedEvent event = this.createSelectionEvent();
        if (event != null) {
            this.selectionChanged(event);
        }
    }
}

