/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codefolding;

import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.ui.IPropertyListener;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.codefolding.FoldingEntry;
import org.python.pydev.editor.codefolding.PyProjectionAnnotation;
import org.python.pydev.editor.model.IModelListener;
import org.python.pydev.parser.ErrorDescription;
import org.python.pydev.parser.jython.ISpecialStr;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.For;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.If;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.TryExcept;
import org.python.pydev.parser.jython.ast.TryFinally;
import org.python.pydev.parser.jython.ast.While;
import org.python.pydev.parser.jython.ast.With;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.parser.jython.ast.excepthandlerType;
import org.python.pydev.parser.jython.ast.suiteType;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.parser.visitors.scope.ASTEntryWithChildren;
import org.python.pydev.parser.visitors.scope.CodeFoldingVisitor;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.preferences.PydevPrefs;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeFoldingSetter
implements IModelListener,
IPropertyListener {
    private PyEdit editor;
    private static Preferences testingPrefs;

    public CodeFoldingSetter(PyEdit editor) {
        this.editor = editor;
    }

    @Override
    public synchronized void modelChanged(final SimpleNode root2) {
        ProjectionAnnotationModel model = (ProjectionAnnotationModel)this.editor.getAdapter(ClassLiteral.getClass((String)"org/eclipse/jface/text/source/projection/ProjectionAnnotationModel"));
        if (model == null) {
            Thread t = new Thread(){

                public void run() {
                    ProjectionAnnotationModel modelT = null;
                    int i = 0;
                    while (i < 10 && modelT == null) {
                        try {
                            1.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        modelT = (ProjectionAnnotationModel)CodeFoldingSetter.this.editor.getAdapter(ClassLiteral.getClass((String)"org/eclipse/jface/text/source/projection/ProjectionAnnotationModel"));
                        if (modelT != null) {
                            CodeFoldingSetter.this.addMarksToModel(root2, modelT);
                            break;
                        }
                        ++i;
                    }
                }
            };
            t.setPriority(1);
            t.setName("CodeFolding - get annotation model");
            t.start();
        } else {
            this.addMarksToModel(root2, model);
        }
    }

    private synchronized void addMarksToModel(SimpleNode root2, ProjectionAnnotationModel model) {
        try {
            if (model != null) {
                ArrayList<PyProjectionAnnotation> existing = new ArrayList<PyProjectionAnnotation>();
                Iterator iter = model.getAnnotationIterator();
                while (iter != null && iter.hasNext()) {
                    PyProjectionAnnotation element = (PyProjectionAnnotation)((Object)iter.next());
                    existing.add(element);
                }
                IDocument doc = this.editor.getDocument();
                if (doc != null) {
                    List<FoldingEntry> marks = CodeFoldingSetter.getMarks(doc, root2);
                    Map<ProjectionAnnotation, Position> annotationsToAdd = this.getAnnotationsToAdd(marks, model, existing);
                    model.replaceAnnotations(existing.toArray(new Annotation[existing.size()]), annotationsToAdd);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Map<ProjectionAnnotation, Position> getAnnotationsToAdd(List<FoldingEntry> nodes, ProjectionAnnotationModel model, List<PyProjectionAnnotation> existing) {
        HashMap<ProjectionAnnotation, Position> annotationsToAdd = new HashMap<ProjectionAnnotation, Position>();
        try {
            for (FoldingEntry element : nodes) {
                Tuple<ProjectionAnnotation, Position> tup;
                if (element.startLine >= element.endLine - 1 || (tup = this.getAnnotationToAdd(element, element.startLine, element.endLine, model, existing)) == null) continue;
                annotationsToAdd.put((ProjectionAnnotation)tup.o1, (Position)tup.o2);
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (NullPointerException nullPointerException) {}
        return annotationsToAdd;
    }

    private Tuple<ProjectionAnnotation, Position> getAnnotationToAdd(FoldingEntry node, int start, int end, ProjectionAnnotationModel model, List<PyProjectionAnnotation> existing) throws BadLocationException {
        try {
            int offset;
            IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
            int endOffset = offset = document.getLineOffset(start);
            try {
                endOffset = document.getLineOffset(end);
            }
            catch (Exception exception) {
                IRegion lineInformation = document.getLineInformation(end);
                endOffset = lineInformation.getOffset() + lineInformation.getLength();
            }
            Position position = new Position(offset, endOffset - offset);
            return this.getAnnotationToAdd(position, node, model, existing);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private Tuple<ProjectionAnnotation, Position> getAnnotationToAdd(Position position, FoldingEntry node, ProjectionAnnotationModel model, List<PyProjectionAnnotation> existing) {
        for (PyProjectionAnnotation element : existing) {
            Position existingPosition = model.getPosition((Annotation)element);
            if (!existingPosition.equals((Object)position)) continue;
            existing.remove((Object)element);
            return null;
        }
        return new Tuple((Object)new PyProjectionAnnotation(node.getAstEntry()), (Object)position);
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == -999) {
            this.modelChanged(this.editor.getAST());
        }
    }

    public static List<FoldingEntry> getMarks(IDocument doc, SimpleNode ast) {
        ArrayList<FoldingEntry> ret = new ArrayList<FoldingEntry>();
        CodeFoldingVisitor visitor = CodeFoldingVisitor.create((SimpleNode)ast);
        ArrayList<Class> elementList = new ArrayList<Class>();
        Preferences prefs = CodeFoldingSetter.getPreferences();
        if (prefs.getBoolean("FOLD_IMPORTS")) {
            elementList.add(ClassLiteral.getClass((String)"org/python/pydev/parser/jython/ast/Import"));
            elementList.add(ClassLiteral.getClass((String)"org/python/pydev/parser/jython/ast/ImportFrom"));
        }
        if (prefs.getBoolean("FOLD_CLASSDEF")) {
            elementList.add(ClassLiteral.getClass((String)"org/python/pydev/parser/jython/ast/ClassDef"));
        }
        if (prefs.getBoolean("FOLD_FUNCTIONDEF")) {
            elementList.add(ClassLiteral.getClass((String)"org/python/pydev/parser/jython/ast/FunctionDef"));
        }
        if (prefs.getBoolean("FOLD_STRINGS")) {
            elementList.add(ClassLiteral.getClass((String)"org/python/pydev/parser/jython/ast/Str"));
        }
        if (prefs.getBoolean("FOLD_WHILE")) {
            elementList.add(ClassLiteral.getClass((String)"org/python/pydev/parser/jython/ast/While"));
        }
        if (prefs.getBoolean("FOLD_IF")) {
            elementList.add(ClassLiteral.getClass((String)"org/python/pydev/parser/jython/ast/If"));
        }
        if (prefs.getBoolean("FOLD_FOR")) {
            elementList.add(ClassLiteral.getClass((String)"org/python/pydev/parser/jython/ast/For"));
        }
        if (prefs.getBoolean("FOLD_WITH")) {
            elementList.add(ClassLiteral.getClass((String)"org/python/pydev/parser/jython/ast/With"));
        }
        if (prefs.getBoolean("FOLD_TRY")) {
            elementList.add(ClassLiteral.getClass((String)"org/python/pydev/parser/jython/ast/TryExcept"));
            elementList.add(ClassLiteral.getClass((String)"org/python/pydev/parser/jython/ast/TryFinally"));
        }
        List nodes = visitor.getAsList(elementList.toArray(new Class[elementList.size()]));
        for (ASTEntry entry : nodes) {
            CodeFoldingSetter.createFoldingEntries((ASTEntryWithChildren)entry, ret);
        }
        if (prefs.getBoolean("FOLD_COMMENTS")) {
            PySelection.DocIterator it = new PySelection.DocIterator(true, new PySelection(doc, 0));
            while (it.hasNext()) {
                String string = it.next();
                if (!string.trim().startsWith("#")) continue;
                int l = it.getCurrentLine() - 1;
                CodeFoldingSetter.addFoldingEntry(ret, new FoldingEntry(3, l, l + 1, new ASTEntry(null, (SimpleNode)new commentType(string))));
            }
        }
        Collections.sort(ret, new Comparator<FoldingEntry>(){

            @Override
            public int compare(FoldingEntry o1, FoldingEntry o2) {
                if (o1.startLine < o2.startLine) {
                    return -1;
                }
                if (o1.startLine > o2.startLine) {
                    return 1;
                }
                return 0;
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.compare((FoldingEntry)object, (FoldingEntry)object2);
            }
        });
        return ret;
    }

    private static void createFoldingEntries(ASTEntryWithChildren entry, List<FoldingEntry> ret) {
        FoldingEntry foldingEntry = null;
        if (entry.node instanceof Import || entry.node instanceof ImportFrom) {
            foldingEntry = new FoldingEntry(1, entry.node.beginLine - 1, entry.endLine, (ASTEntry)entry);
        } else if (entry.node instanceof ClassDef) {
            ClassDef def = (ClassDef)entry.node;
            foldingEntry = new FoldingEntry(2, def.name.beginLine - 1, entry.endLine, (ASTEntry)entry);
        } else if (entry.node instanceof FunctionDef) {
            FunctionDef def = (FunctionDef)entry.node;
            foldingEntry = new FoldingEntry(2, def.name.beginLine - 1, entry.endLine, (ASTEntry)entry);
        } else if (entry.node instanceof TryExcept) {
            foldingEntry = new FoldingEntry(7, entry.node.beginLine - 1, entry.endLine, (ASTEntry)entry);
            TryExcept tryStmt = (TryExcept)entry.node;
            if (tryStmt.handlers != null) {
                excepthandlerType[] excepthandlerTypeArray = tryStmt.handlers;
                int n = tryStmt.handlers.length;
                int n2 = 0;
                while (n2 < n) {
                    excepthandlerType except = excepthandlerTypeArray[n2];
                    foldingEntry = CodeFoldingSetter.checkExcept(entry, ret, foldingEntry, entry.endLine, except);
                    ++n2;
                }
            }
            if (tryStmt.orelse != null) {
                foldingEntry = CodeFoldingSetter.checkOrElse(entry, ret, foldingEntry, entry.endLine, tryStmt.orelse);
            }
        } else if (entry.node instanceof TryFinally) {
            TryFinally tryStmt = (TryFinally)entry.node;
            if (!(tryStmt.body == null || tryStmt.body.length <= 0 || tryStmt.body[0] instanceof TryExcept && tryStmt.body[0].beginLine == tryStmt.beginLine)) {
                foldingEntry = new FoldingEntry(8, entry.node.beginLine - 1, entry.endLine, (ASTEntry)entry);
            }
            if (tryStmt.finalbody != null) {
                if (foldingEntry != null) {
                    foldingEntry = CodeFoldingSetter.checkFinally(entry, ret, foldingEntry, entry.endLine, tryStmt.finalbody, true);
                } else {
                    foldingEntry = new FoldingEntry(8, entry.node.beginLine - 1, entry.endLine, (ASTEntry)entry);
                    foldingEntry = CodeFoldingSetter.checkFinally(entry, ret, foldingEntry, entry.endLine, tryStmt.finalbody, false);
                }
            }
        } else if (entry.node instanceof With) {
            foldingEntry = new FoldingEntry(5, entry.node.beginLine - 1, entry.endLine, (ASTEntry)entry);
        } else if (entry.node instanceof While) {
            foldingEntry = new FoldingEntry(5, entry.node.beginLine - 1, entry.endLine, (ASTEntry)entry);
            foldingEntry = CodeFoldingSetter.checkOrElse(entry, ret, foldingEntry, entry.endLine, ((While)entry.node).orelse);
        } else if (entry.node instanceof For) {
            foldingEntry = new FoldingEntry(5, entry.node.beginLine - 1, entry.endLine, (ASTEntry)entry);
            foldingEntry = CodeFoldingSetter.checkOrElse(entry, ret, foldingEntry, entry.endLine, ((For)entry.node).orelse);
        } else if (entry.node instanceof If) {
            foldingEntry = new FoldingEntry(5, entry.node.beginLine - 1, entry.endLine, (ASTEntry)entry);
        } else if (entry.node instanceof Str && entry.node.beginLine != entry.endLine) {
            foldingEntry = new FoldingEntry(4, entry.node.beginLine - 1, entry.endLine, (ASTEntry)entry);
        }
        if (foldingEntry != null) {
            CodeFoldingSetter.addFoldingEntry(ret, foldingEntry);
        }
    }

    private static FoldingEntry checkOrElse(ASTEntryWithChildren entry, List<FoldingEntry> ret, FoldingEntry foldingEntry, int blockEndLine, suiteType orelse) {
        return CodeFoldingSetter.checkOrElseSuite(entry, ret, foldingEntry, blockEndLine, (SimpleNode)orelse, 6, "else", true);
    }

    private static FoldingEntry checkFinally(ASTEntryWithChildren entry, List<FoldingEntry> ret, FoldingEntry foldingEntry, int blockEndLine, suiteType orelse, boolean addPrevious) {
        return CodeFoldingSetter.checkOrElseSuite(entry, ret, foldingEntry, blockEndLine, (SimpleNode)orelse, 8, "finally", addPrevious);
    }

    private static FoldingEntry checkExcept(ASTEntryWithChildren entry, List<FoldingEntry> ret, FoldingEntry foldingEntry, int blockEndLine, excepthandlerType orelse) {
        return CodeFoldingSetter.checkOrElseSuite(entry, ret, foldingEntry, blockEndLine, (SimpleNode)orelse, 7, "except", true);
    }

    private static FoldingEntry checkOrElseSuite(ASTEntryWithChildren entry, List<FoldingEntry> ret, FoldingEntry foldingEntry, int blockEndLine, SimpleNode orelse, int type, String specialToken, boolean addPrevious) {
        if (orelse != null && orelse.specialsBefore != null) {
            for (Object o : orelse.specialsBefore) {
                ISpecialStr specialStr;
                if (!(o instanceof ISpecialStr) || !(specialStr = (ISpecialStr)o).toString().equals(specialToken)) continue;
                foldingEntry.endLine = specialStr.getBeginLine() - 1;
                if (addPrevious) {
                    CodeFoldingSetter.addFoldingEntry(ret, foldingEntry);
                }
                foldingEntry = new FoldingEntry(type, specialStr.getBeginLine() - 1, blockEndLine, (ASTEntry)entry);
            }
        }
        return foldingEntry;
    }

    public static Preferences getPreferences() {
        if (testingPrefs == null) {
            return PydevPrefs.getPreferences();
        }
        if (PydevPlugin.getDefault() != null) {
            throw new RuntimeException("Should only get here in tests!");
        }
        return testingPrefs;
    }

    public static void setPreferences(Preferences prefs) {
        testingPrefs = prefs;
    }

    private static void addFoldingEntry(List<FoldingEntry> ret, FoldingEntry foldingEntry) {
        if (ret.size() > 0 && (foldingEntry.type == 3 || foldingEntry.type == 1)) {
            FoldingEntry prev = ret.get(ret.size() - 1);
            if (prev.type == foldingEntry.type && prev.startLine < foldingEntry.startLine && prev.endLine == foldingEntry.startLine) {
                prev.endLine = foldingEntry.endLine;
            } else {
                ret.add(foldingEntry);
            }
        } else {
            ret.add(foldingEntry);
        }
    }

    @Override
    public void errorChanged(ErrorDescription errorDesc) {
    }
}

