/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.ICallback;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionRequest;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.ILocalScope;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.core.structure.FastStack;
import org.python.pydev.editor.codecompletion.AbstractPyCodeCompletion;
import org.python.pydev.editor.codecompletion.CompletionRequest;
import org.python.pydev.editor.codecompletion.IPyDevCompletionParticipant;
import org.python.pydev.editor.codecompletion.PyCodeCompletionPreferencesPage;
import org.python.pydev.editor.codecompletion.PyStringCodeCompletion;
import org.python.pydev.editor.codecompletion.revisited.AbstractASTManager;
import org.python.pydev.editor.codecompletion.revisited.AssignAnalysis;
import org.python.pydev.editor.codecompletion.revisited.CompletionState;
import org.python.pydev.editor.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.editor.codecompletion.revisited.modules.CompiledModule;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.editor.codecompletion.revisited.visitors.FindScopeVisitor;
import org.python.pydev.editor.codecompletion.shell.AbstractShell;
import org.python.pydev.logging.DebugSettings;
import org.python.pydev.parser.PyParser;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.plugin.PydevPlugin;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyCodeCompletion
extends AbstractPyCodeCompletion {
    public static ICallback<Object, CompletionRecursionException> onCompletionRecursionException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getCodeCompletionProposals(ITextViewer viewer, CompletionRequest request) throws CoreException, BadLocationException, IOException, MisconfigurationException, PythonNatureWithoutProjectException {
        ArrayList<ICompletionProposal> ret;
        block20: {
            if (request.getPySelection().getCursorLineContents().trim().startsWith("#")) {
                return new PyStringCodeCompletion().getCodeCompletionProposals(viewer, request);
            }
            if (DebugSettings.DEBUG_CODE_COMPLETION) {
                Log.toLogFile((Object)this, (String)"Starting getCodeCompletionProposals");
                Log.addLogLevel();
                Log.toLogFile((Object)this, (String)new StringBuffer("Request:").append(request).toString());
            }
            ret = new ArrayList<ICompletionProposal>();
            if (!this.isValidCompletionContext(request)) {
                request.showTemplates = false;
                return ret;
            }
            try {
                IPythonNature pythonNature = request.nature;
                this.checkPythonNature(pythonNature);
                ICodeCompletionASTManager astManager = pythonNature.getAstManager();
                if (astManager == null) {
                    return ret;
                }
                ArrayList<Object> tokensList = new ArrayList<Object>();
                this.lazyStartShell(request);
                String trimmed = request.activationToken.replace('.', ' ').trim();
                ICodeCompletionASTManager.ImportInfo importsTipper = this.getImportsTipperStr(request);
                int line = request.doc.getLineOfOffset(request.documentOffset);
                IRegion region = request.doc.getLineInformation(line);
                CompletionState state = new CompletionState(line, request.documentOffset - region.getOffset(), null, request.nature, request.qualifier);
                state.setIsInCalltip(request.isInCalltip);
                boolean importsTip = false;
                if (importsTipper.importsTipperStr.length() != 0) {
                    request.isInCalltip = false;
                    importsTip = this.doImportCompletion(request, astManager, tokensList, importsTipper);
                } else if (trimmed.length() > 0 && request.activationToken.indexOf(46) != -1) {
                    this.doTokenCompletion(request, astManager, tokensList, trimmed, state);
                } else {
                    this.doGlobalsCompletion(request, astManager, tokensList, state);
                }
                HashMap<String, IToken> alreadyChecked = new HashMap<String, IToken>();
                String lowerCaseQual = request.qualifier.toLowerCase();
                if (lowerCaseQual.length() >= PyCodeCompletionPreferencesPage.getArgumentsDeepAnalysisNChars()) {
                    state.pushFindResolveImportMemoryCtx();
                    try {
                        ListIterator it = tokensList.listIterator();
                        while (it.hasNext()) {
                            Object o = it.next();
                            if (!(o instanceof IToken)) continue;
                            it.remove();
                            IToken initialToken = (IToken)o;
                            IToken token = initialToken;
                            String strRep = token.getRepresentation();
                            IToken prev = (IToken)alreadyChecked.get(strRep);
                            if (prev != null && prev.getArgs().length() != 0 || !strRep.toLowerCase().startsWith(lowerCaseQual)) continue;
                            while (token.isImportFrom() && token.getArgs().length() <= 0) {
                                ICompletionState s = state.getCopyForResolveImportWithActTok(token.getRepresentation());
                                s.checkFindResolveImportMemory(token);
                                IToken token2 = astManager.resolveImport(s, token);
                                if (token2 == null || initialToken == token2) break;
                                String args = token2.getArgs();
                                if (args.length() > 0) {
                                    initialToken.setArgs(args);
                                    initialToken.setDocStr(token2.getDocStr());
                                    if (!(initialToken instanceof SourceToken) || !(token2 instanceof SourceToken)) break;
                                    SourceToken initialSourceToken = (SourceToken)initialToken;
                                    SourceToken token2SourceToken = (SourceToken)token2;
                                    initialSourceToken.setAst(token2SourceToken.getAst());
                                    break;
                                }
                                if (token2 == null || token2.equals(token) && token2.getArgs().equals(token.getArgs()) && token2.getParentPackage().equals(token.getParentPackage())) break;
                                token = token2;
                            }
                            alreadyChecked.put(strRep, initialToken);
                        }
                    }
                    finally {
                        state.popFindResolveImportMemoryCtx();
                    }
                }
                tokensList.addAll(alreadyChecked.values());
                this.changeItokenToCompletionPropostal(viewer, request, ret, tokensList, importsTip, state);
            }
            catch (CompletionRecursionException e) {
                if (onCompletionRecursionException != null) {
                    onCompletionRecursionException.call((Object)e);
                }
                if (!DebugSettings.DEBUG_CODE_COMPLETION) break block20;
                Log.toLogFile((Exception)((Object)e));
            }
        }
        if (DebugSettings.DEBUG_CODE_COMPLETION) {
            Log.remLogLevel();
            Log.toLogFile((Object)this, (String)new StringBuffer("Finished completion. Returned:").append(ret.size()).append(" completions.\r\n").toString());
        }
        return ret;
    }

    private boolean isValidCompletionContext(CompletionRequest request) {
        PySelection ps = request.getPySelection();
        return ps.isInDeclarationLine() == PySelection.DECLARATION_NONE;
    }

    private void doGlobalsCompletion(CompletionRequest request, ICodeCompletionASTManager astManager, List<Object> tokensList, ICompletionState state) throws CompletionRecursionException, MisconfigurationException {
        state.setActivationToken(request.activationToken);
        if (DebugSettings.DEBUG_CODE_COMPLETION) {
            Log.toLogFile((Object)this, (String)"astManager.getCompletionsForToken");
            Log.addLogLevel();
        }
        IToken[] comps = astManager.getCompletionsForToken(request.editorFile, request.doc, state);
        if (DebugSettings.DEBUG_CODE_COMPLETION) {
            Log.remLogLevel();
            Log.toLogFile((Object)this, (String)"END astManager.getCompletionsForToken");
        }
        tokensList.addAll(Arrays.asList(comps));
        tokensList.addAll(this.getGlobalsFromParticipants(request, state));
    }

    private void doTokenCompletion(CompletionRequest request, ICodeCompletionASTManager astManager, List<Object> tokensList, String trimmed, ICompletionState state) throws CompletionRecursionException, MisconfigurationException {
        if (request.activationToken.endsWith(".")) {
            request.activationToken = request.activationToken.substring(0, request.activationToken.length() - 1);
        }
        String initialActivationToken = request.activationToken;
        int parI = request.activationToken.indexOf(40);
        if (parI != -1) {
            request.activationToken = request.activationToken.substring(0, parI);
        }
        char[] toks = new char[]{'.', ' '};
        ArrayList completions = new ArrayList();
        boolean lookInGlobals = true;
        if (trimmed.equals("self") || FullRepIterable.getFirstPart((String)trimmed, (char[])toks).equals("self")) {
            lookInGlobals = !PyCodeCompletion.getSelfOrClsCompletions(request, tokensList, state, false, true, "self");
        } else if (trimmed.equals("cls") || FullRepIterable.getFirstPart((String)trimmed, (char[])toks).equals("cls")) {
            boolean bl = lookInGlobals = !PyCodeCompletion.getSelfOrClsCompletions(request, tokensList, state, false, true, "cls");
        }
        if (lookInGlobals) {
            state.setActivationToken(initialActivationToken);
            IToken[] comps = astManager.getCompletionsForToken(request.editorFile, request.doc, state);
            tokensList.addAll(Arrays.asList(comps));
        }
        tokensList.addAll(completions);
    }

    private boolean doImportCompletion(CompletionRequest request, ICodeCompletionASTManager astManager, List<Object> tokensList, ICodeCompletionASTManager.ImportInfo importsTipper) throws CompletionRecursionException {
        boolean importsTip = true;
        importsTipper.importsTipperStr = importsTipper.importsTipperStr.trim();
        IToken[] imports = astManager.getCompletionsForImport(importsTipper, (ICompletionRequest)request, false);
        tokensList.addAll(Arrays.asList(imports));
        return importsTip;
    }

    private void checkPythonNature(IPythonNature pythonNature) {
        if (pythonNature == null) {
            throw new RuntimeException("Unable to get python nature.");
        }
    }

    private void lazyStartShell(CompletionRequest request) throws IOException, CoreException, MisconfigurationException, PythonNatureWithoutProjectException {
        if (DebugSettings.DEBUG_CODE_COMPLETION) {
            Log.toLogFile((Object)this, (String)"AbstractShell.getServerShell");
        }
        if (CompiledModule.COMPILED_MODULES_ENABLED) {
            AbstractShell.getServerShell(request.nature, 1);
        }
        if (DebugSettings.DEBUG_CODE_COMPLETION) {
            Log.toLogFile((Object)this, (String)"END AbstractShell.getServerShell");
        }
    }

    private Collection<Object> getGlobalsFromParticipants(CompletionRequest request, ICompletionState state) throws MisconfigurationException {
        ArrayList<Object> ret = new ArrayList<Object>();
        List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_completion");
        for (IPyDevCompletionParticipant participant : participants) {
            ret.addAll(participant.getGlobalCompletions(request, state));
        }
        return ret;
    }

    public static boolean getSelfOrClsCompletions(CompletionRequest request, List theList, ICompletionState state, boolean getOnlySupers, boolean checkIfInCorrectScope, String lookForRep) throws MisconfigurationException {
        SimpleNode s = (SimpleNode)PyParser.reparseDocument((PyParser.ParserInfo)new PyParser.ParserInfo((IDocument)request.doc, (boolean)true, (IGrammarVersionProvider)request.nature, (int)state.getLine())).o1;
        if (s != null) {
            FindScopeVisitor visitor;
            block7: {
                visitor = new FindScopeVisitor(state.getLine(), 0);
                s.accept((VisitorIF)visitor);
                if (!checkIfInCorrectScope) break block7;
                boolean scopeCorrect = false;
                FastStack scopeStack = visitor.scope.getScopeStack();
                Iterator it = scopeStack.topDownIterator();
                while (!scopeCorrect && it.hasNext()) {
                    String rep;
                    SimpleNode node = (SimpleNode)it.next();
                    if (!(node instanceof FunctionDef)) continue;
                    FunctionDef funcDef = (FunctionDef)node;
                    if (funcDef.args == null || funcDef.args.args == null || funcDef.args.args.length <= 0 || (rep = NodeUtils.getRepresentationString((SimpleNode)funcDef.args.args[0])) == null || !rep.equals("self") && !rep.equals("cls")) continue;
                    scopeCorrect = true;
                }
                if (scopeCorrect) break block7;
                return false;
            }
            try {
                if (lookForRep.equals("self")) {
                    state.setLookingFor(1);
                } else {
                    state.setLookingFor(3);
                }
                PyCodeCompletion.getSelfOrClsCompletions(visitor.scope, request, theList, state, getOnlySupers);
            }
            catch (Exception e1) {
                PydevPlugin.log(e1);
            }
            return true;
        }
        return false;
    }

    public static void getSelfOrClsCompletions(ILocalScope scope, CompletionRequest request, List theList, ICompletionState state, boolean getOnlySupers) throws BadLocationException, MisconfigurationException {
        for (SimpleNode node : scope) {
            String resolveModule;
            if (!(node instanceof ClassDef)) continue;
            ClassDef d = (ClassDef)node;
            if (getOnlySupers) {
                ArrayList<IToken> gottenComps = new ArrayList<IToken>();
                int i = 0;
                while (i < d.bases.length) {
                    if (d.bases[i] instanceof Name) {
                        Name n = (Name)d.bases[i];
                        state.setActivationToken(n.id);
                        try {
                            IToken[] completions = request.nature.getAstManager().getCompletionsForToken(request.editorFile, request.doc, state);
                            gottenComps.addAll(Arrays.asList(completions));
                        }
                        catch (CompletionRecursionException completionRecursionException) {}
                    }
                    ++i;
                }
                theList.addAll(gottenComps);
                continue;
            }
            String trimmed = request.activationToken.replace('.', ' ').trim();
            String[] actTokStrs = trimmed.split(" ");
            if (actTokStrs.length == 0 || !actTokStrs[0].equals("self") && !actTokStrs[0].equals("cls")) {
                throw new AssertionError((Object)"We need to have at least one token (self or cls) for doing completions in the class.");
            }
            if (actTokStrs.length == 1) {
                state.setActivationToken(NodeUtils.getNameFromNameTok((NameTok)((NameTok)d.name)));
                try {
                    theList.addAll(Arrays.asList(request.nature.getAstManager().getCompletionsForToken(request.editorFile, request.doc, state)));
                }
                catch (CompletionRecursionException completionRecursionException) {}
                continue;
            }
            int line = request.doc.getLineOfOffset(request.documentOffset);
            IRegion region = request.doc.getLineInformationOfOffset(request.documentOffset);
            int col = request.documentOffset - region.getOffset();
            String modName = "";
            File requestFile = request.editorFile;
            if (request.editorFile != null && (resolveModule = request.nature.resolveModule(requestFile)) != null) {
                modName = resolveModule;
            }
            AbstractModule module = AbstractModule.createModuleFromDoc(modName, requestFile, request.doc, request.nature, line);
            AbstractASTManager astMan = (AbstractASTManager)request.nature.getAstManager();
            theList.addAll(new AssignAnalysis().getAssignCompletions((ICodeCompletionASTManager)astMan, (IModule)module, (ICompletionState)new CompletionState((int)line, (int)col, (String)request.activationToken, (IPythonNature)request.nature, (String)request.qualifier)).completions);
        }
    }
}

