/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.python.pydev.editor.IPySyntaxHighlightingAndCodeCompletionEditor;
import org.python.pydev.editor.PyEditConfigurationWithoutEditor;
import org.python.pydev.editor.codecompletion.PyCodeCompletionPreferencesPage;
import org.python.pydev.editor.codecompletion.PythonCompletionProcessor;
import org.python.pydev.editor.codecompletion.PythonStringCompletionProcessor;
import org.python.pydev.editor.correctionassist.PyCorrectionAssistant;
import org.python.pydev.editor.correctionassist.PythonCorrectionProcessor;
import org.python.pydev.editor.hover.PyAnnotationHover;
import org.python.pydev.editor.hover.PyTextHover;
import org.python.pydev.editor.simpleassist.SimpleAssistProcessor;
import org.python.pydev.ui.ColorCache;

public class PyEditConfiguration
extends PyEditConfigurationWithoutEditor {
    private IPySyntaxHighlightingAndCodeCompletionEditor edit;

    private void setEdit(IPySyntaxHighlightingAndCodeCompletionEditor edit) {
        this.edit = edit;
    }

    private IPySyntaxHighlightingAndCodeCompletionEditor getEdit() {
        return this.edit;
    }

    public PyEditConfiguration(ColorCache colorManager, IPySyntaxHighlightingAndCodeCompletionEditor edit, IPreferenceStore preferenceStore) {
        super(colorManager, preferenceStore);
        this.setEdit(edit);
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new PyAnnotationHover(sourceViewer);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new PyTextHover(sourceViewer, contentType);
    }

    protected Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put("org.python.pydev.editor.PythonEditor", this.edit);
        return targets;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        SimpleAssistProcessor processor = new SimpleAssistProcessor(this.edit, new PythonCompletionProcessor(this.edit, this.pyContentAssistant), this.pyContentAssistant);
        PythonStringCompletionProcessor stringProcessor = new PythonStringCompletionProcessor(this.edit, this.pyContentAssistant);
        this.pyContentAssistant.setRestoreCompletionProposalSize(this.getSettings("pydev_completion_proposal_size"));
        this.pyContentAssistant.setContentAssistProcessor(stringProcessor, "__python_singleline_string1");
        this.pyContentAssistant.setContentAssistProcessor(stringProcessor, "__python_singleline_string2");
        this.pyContentAssistant.setContentAssistProcessor(stringProcessor, "__python_multiline_string1");
        this.pyContentAssistant.setContentAssistProcessor(stringProcessor, "__python_multiline_string2");
        this.pyContentAssistant.setContentAssistProcessor(stringProcessor, "__python_comment");
        this.pyContentAssistant.setContentAssistProcessor(processor, "__dftl_partition_content_type");
        this.pyContentAssistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        this.pyContentAssistant.enableAutoActivation(true);
        this.pyContentAssistant.setDocumentPartitioning("__PYTHON_PARTITION_TYPE");
        this.pyContentAssistant.setAutoActivationDelay(PyCodeCompletionPreferencesPage.getAutocompleteDelay());
        return this.pyContentAssistant;
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        PyCorrectionAssistant assistant = new PyCorrectionAssistant();
        PythonCorrectionProcessor processor = new PythonCorrectionProcessor(this.getEdit());
        assistant.setQuickAssistProcessor(processor);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return assistant;
    }
}

