/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.templates;

import org.eclipse.core.runtime.CoreException;
import org.epic.perleditor.templates.TemplatePosition;

public final class TemplateBuffer {
    private String fString;
    private TemplatePosition[] fVariables;

    public TemplateBuffer(String string, TemplatePosition[] variables) throws CoreException {
        this.setContent(string, variables);
    }

    public final void setContent(String string, TemplatePosition[] variables) throws CoreException {
        this.fString = string;
        this.fVariables = variables;
    }

    public final String getString() {
        return this.fString;
    }

    public final TemplatePosition[] getVariables() {
        return this.fVariables;
    }

    public void indent(String indentChars) {
        int j = 0;
        int indentLen = indentChars.length();
        if (indentLen == 0) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        int k = 0;
        while (true) {
            int i;
            if ((i = this.skipToNextLine(j)) == -1) {
                buf.append(this.fString.substring(j));
                this.fString = buf.toString();
                return;
            }
            buf.append(this.fString.substring(j, i));
            buf.append(indentChars);
            this.indentVars(i + indentLen * k, indentLen);
            j = i;
            ++k;
        }
    }

    private void indentVars(int fromOffset, int delta) {
        int i = 0;
        while (i < this.fVariables.length) {
            int[] offsets = this.fVariables[i].getOffsets();
            int j = 0;
            while (j < offsets.length) {
                if (offsets[j] >= fromOffset) {
                    int n = j;
                    offsets[n] = offsets[n] + delta;
                }
                ++j;
            }
            this.fVariables[i].setOffsets(offsets);
            ++i;
        }
    }

    private int skipToNextLine(int fromOffset) {
        int i = fromOffset;
        while (i < this.fString.length()) {
            char c = this.fString.charAt(i);
            if (c == '\r') {
                if (i < this.fString.length() - 1 && this.fString.charAt(i + 1) == '\n') {
                    return i + 2;
                }
                return i + 1;
            }
            if (c == '\n') {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }
}

