/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.epic.core.util.WidgetUtils;
import org.epic.perleditor.PerlEditorPlugin;

public class PerlCriticPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String DEFAULT_LOCATION = "/usr/bin/perlcritic";
    private static final String[] LEVELS;
    private Combo[] comboButtons = new Combo[5];
    private Text customText;
    private Button enabledButton;
    private List errors = new ArrayList(5);
    private Button useCustomButton;
    private Button useDefaultButton;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.epic.perleditor.preferences.PerlCriticPreferencePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        LEVELS = new String[]{"Info", "Warning", "Error"};
    }

    public static int getMarkerSeverity(int severity) {
        if (!($assertionsDisabled || severity > 0 && severity <= 5)) {
            throw new AssertionError((Object)("unknown severity " + severity));
        }
        String prefName = "sourceCriticLevel" + severity;
        String level = PerlEditorPlugin.getDefault().getPreferenceStore().getString(prefName);
        int markerLevel = "error".equalsIgnoreCase(level) ? 2 : ("warning".equalsIgnoreCase(level) || "".equals(level) ? 1 : 0);
        return markerLevel;
    }

    public static String getPerlCritic() {
        return PerlEditorPlugin.getDefault().getPreferenceStore().getString("sourceCriticLocation");
    }

    public static boolean isPerlCriticEnabled() {
        return PerlEditorPlugin.getDefault().getPreferenceStore().getBoolean("sourceCriticEnabled");
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(PerlEditorPlugin.getDefault().getPreferenceStore());
    }

    public boolean performOk() {
        this.storeBoolean("sourceCriticEnabled", this.enabledButton.getSelection());
        this.storeBoolean("sourceCriticDefaultLocation", this.useDefaultButton.getSelection());
        String location = this.customText.getText().equals("") ? DEFAULT_LOCATION : this.customText.getText();
        this.storeString("sourceCriticLocation", location);
        int i = 0;
        while (i < this.comboButtons.length) {
            String prefName = "sourceCriticLevel" + (i + 1);
            this.storeString(prefName, this.comboButtons[i].getText());
            ++i;
        }
        return super.performOk();
    }

    protected Control createContents(Composite parent) {
        Composite composite = this.createComposite(parent, 1);
        this.enabledButton = WidgetUtils.createButton(composite, "Enable Critic", 16416);
        this.enabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PerlCriticPreferencePage.this.validateEnabled();
                PerlCriticPreferencePage.this.toggleCriticEnabled(PerlCriticPreferencePage.this.enabledButton.getSelection());
            }
        });
        Composite locations = WidgetUtils.createGroup(composite, 768);
        this.useDefaultButton = WidgetUtils.createButton(locations, "Default location (/usr/bin/perlcritic)", 16400);
        this.useDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PerlCriticPreferencePage.this.validateLocation(PerlCriticPreferencePage.DEFAULT_LOCATION);
            }
        });
        this.useCustomButton = WidgetUtils.createButton(locations, "Custom location", 16400);
        this.useCustomButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PerlCriticPreferencePage.this.customText.setText(PerlCriticPreferencePage.this.loadString("sourceCriticLocation", PerlCriticPreferencePage.DEFAULT_LOCATION));
                PerlCriticPreferencePage.this.customText.setEnabled(PerlCriticPreferencePage.this.useCustomButton.getSelection());
                PerlCriticPreferencePage.this.validateLocation(PerlCriticPreferencePage.this.customText.getText());
            }
        });
        this.customText = WidgetUtils.createText(locations, "Path to perlcritic");
        this.customText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PerlCriticPreferencePage.this.validateLocation(PerlCriticPreferencePage.this.customText.getText());
            }
        });
        WidgetUtils.createLabel(composite, "Severity Marker Settings");
        Composite markerStyles = WidgetUtils.createGroup(composite, 768);
        int i = 0;
        while (i < this.comboButtons.length) {
            Composite c = WidgetUtils.createComposite(markerStyles, 2);
            WidgetUtils.createLabel(c, "Level " + (i + 1));
            this.comboButtons[i] = new Combo(c, 8);
            this.comboButtons[i].setItems(LEVELS);
            ++i;
        }
        this.loadPreferences();
        this.toggleCriticEnabled(this.enabledButton.getSelection());
        return composite;
    }

    protected void performDefaults() {
        this.enabledButton.setSelection(false);
        this.useDefaultButton.setSelection(true);
        this.useCustomButton.setSelection(false);
        this.customText.setText("");
        int i = 0;
        while (i < this.comboButtons.length) {
            this.comboButtons[i].setText("Warning");
            ++i;
        }
        this.toggleCriticEnabled(false);
        super.performDefaults();
    }

    protected void removeErrorMessage(String message) {
        this.errors.remove(message);
        if (this.errors.isEmpty()) {
            this.addErrorMessage(null);
        } else {
            this.addErrorMessage((String)this.errors.get(this.errors.size() - 1));
        }
    }

    private void addErrorMessage(String message) {
        this.errors.remove(message);
        this.errors.add(message);
        this.setErrorMessage(message);
        this.setValid(message == null);
    }

    private Composite createComposite(Composite parent, int numCols) {
        return WidgetUtils.createComposite(parent, numCols);
    }

    private boolean loadBoolean(String name) {
        return this.getPreferenceStore().getBoolean(name);
    }

    private void loadPreferences() {
        this.enabledButton.setSelection(this.loadBoolean("sourceCriticEnabled"));
        boolean useDefault = this.loadBoolean("sourceCriticDefaultLocation");
        this.useDefaultButton.setSelection(useDefault);
        this.useCustomButton.setSelection(!useDefault);
        this.customText.setText(this.loadString("sourceCriticLocation", DEFAULT_LOCATION));
        int i = 0;
        while (i < this.comboButtons.length) {
            String text = this.loadString("sourceCriticLevel" + (i + 1), "Warning");
            this.comboButtons[i].setText(text);
            ++i;
        }
    }

    private String loadString(String name, String backup) {
        String value = this.getPreferenceStore().getString(name);
        return "".equals(value) ? backup : value;
    }

    private void storeBoolean(String name, boolean value) {
        this.getPreferenceStore().setValue(name, value);
    }

    private void storeString(String name, String value) {
        this.getPreferenceStore().setValue(name, value);
    }

    private void toggleCriticEnabled(boolean enabled) {
        System.setProperty("sourceCriticEnabled", Boolean.toString(enabled));
        this.useDefaultButton.setEnabled(enabled);
        this.useCustomButton.setEnabled(enabled);
        this.customText.setEnabled(enabled && !this.useDefaultButton.getSelection());
        int i = 0;
        while (i < this.comboButtons.length) {
            this.comboButtons[i].setEnabled(enabled);
            ++i;
        }
    }

    private void validateEnabled() {
        if (!this.enabledButton.getSelection()) {
            this.removeErrorMessage("Invalid perl critic location");
            return;
        }
        String location = DEFAULT_LOCATION;
        if (!this.useDefaultButton.getSelection()) {
            location = this.customText.getText();
        }
        this.validateLocation(location);
    }

    private void validateLocation(String location) {
        if (!this.enabledButton.getSelection()) {
            return;
        }
        if ("".equals(location)) {
            if (!this.useDefaultButton.getSelection()) {
                this.addErrorMessage("Enter path to critic executable");
            }
            return;
        }
        this.removeErrorMessage("Enter path to critic executable");
        if (!new File(location).isFile()) {
            this.addErrorMessage("Invalid perl critic location");
        } else {
            this.removeErrorMessage("Invalid perl critic location");
        }
    }
}

