/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.editors.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorDescriptor;
import org.epic.core.Constants;
import org.epic.core.util.PerlExecutor;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.editors.util.MarkerUtil;
import org.epic.perleditor.editors.util.PerlValidatorBase;

public class PerlValidator
extends PerlValidatorBase {
    private static PerlValidator instance;

    private PerlValidator() {
        super(PerlEditorPlugin.getDefault().getLog(), new PerlExecutor(true));
    }

    public static synchronized PerlValidator instance() {
        if (instance == null) {
            instance = new PerlValidator();
        }
        return instance;
    }

    public synchronized boolean validate(IResource resource) throws CoreException, IOException {
        IEditorDescriptor defaultEditorDescriptor = PerlEditorPlugin.getDefault().getWorkbench().getEditorRegistry().getDefaultEditor(resource.getFullPath().toString());
        if (defaultEditorDescriptor == null) {
            return false;
        }
        if (!defaultEditorDescriptor.getId().equals("org.epic.perleditor.editors.PerlEditor") || resource.getFileExtension().equals("epl")) {
            return false;
        }
        if (!resource.exists()) {
            return false;
        }
        this.validate(resource, this.readSourceFile(resource));
        return true;
    }

    protected void addMarker(IResource resource, Map attributes) {
        new MarkerUtil(resource).addMarker(attributes, Constants.PROBLEM_MARKER);
    }

    protected void clearAllUsedMarkers(IResource resource) {
        new MarkerUtil(resource).clearAllUsedFlags(Constants.PROBLEM_MARKER);
    }

    protected IResource getErrorResource(PerlValidatorBase.ParsedErrorLine line, IResource resource) {
        IResource ret = super.getErrorResource(line, resource);
        if (ret != null) {
            return ret;
        }
        IPath projectRoot = resource.getProject().getLocation();
        String projectRootPath = projectRoot.toOSString();
        String errorResourcePath = line.getPath();
        if (!errorResourcePath.startsWith(projectRootPath)) {
            return resource;
        }
        errorResourcePath = errorResourcePath.substring(projectRootPath.length());
        IResource errorResource = resource.getProject().findMember((IPath)new Path(errorResourcePath));
        return errorResource != null ? errorResource : resource;
    }

    protected List getPerlArgs() {
        List args = super.getPerlArgs();
        if (PerlEditorPlugin.getDefault().getBooleanPreference("SHOW_WARNINGS")) {
            args.add("-w");
        }
        if (PerlEditorPlugin.getDefault().getBooleanPreference("USE_TAINT_MODE")) {
            args.add("-T");
        }
        return args;
    }

    protected boolean isProblemMarkerPresent(PerlValidatorBase.ParsedErrorLine line, IResource resource) {
        return new MarkerUtil(resource).isMarkerPresent(Constants.PROBLEM_MARKER, line.getLineNumber(), line.getMessage(), true);
    }

    protected void removeUnusedMarkers(IResource resource) {
        MarkerUtil util = new MarkerUtil(resource);
        util.removeObsoleteProblemMarkers();
        util.removeUnusedMarkers(Constants.PROBLEM_MARKER);
    }

    protected boolean shouldUnderlineError(IResource resource, int lineNr) {
        List markers = MarkerUtil.getMarkersForLine(resource, lineNr);
        Iterator i = markers.iterator();
        while (i.hasNext()) {
            IMarker marker = (IMarker)i.next();
            try {
                Integer severity = (Integer)marker.getAttribute("severity");
                if (severity == null || severity != 2) continue;
                return false;
            }
            catch (CoreException coreException) {}
        }
        return true;
    }
}

