/*
 * Decompiled with CFR 0.152.
 */
package org.epic.core.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.epic.core.PerlCore;
import org.epic.core.PerlProject;
import org.epic.core.util.CommandLineTokenizer;
import org.epic.core.util.CygwinMount;
import org.epic.perleditor.PerlEditorPlugin;

public class PerlExecutableUtilities {
    private static final Pattern CYGWIN_PATH_TRANSLATION = Pattern.compile("^([a-z]):(.*)$");

    private PerlExecutableUtilities() {
    }

    public static List getPerlCommandLine() {
        String perlExe = PerlEditorPlugin.getDefault().getPerlExecutable();
        try {
            IStringVariableManager varMgr = VariablesPlugin.getDefault().getStringVariableManager();
            perlExe = varMgr.performStringSubstitution(perlExe);
        }
        catch (CoreException e) {
            PerlEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, PerlEditorPlugin.getPluginId(), 0, "Variable substitution failed for Perl executable. The literal value \"" + perlExe + "\" will be used. " + "Check Perl executable in EPIC Preferences.", (Throwable)e));
        }
        return new ArrayList(CommandLineTokenizer.tokenize(perlExe));
    }

    public static List getPerlCommandLine(ITextEditor textEditor) {
        IProject project = ((IFileEditorInput)textEditor.getEditorInput()).getFile().getProject();
        return PerlExecutableUtilities.getPerlCommandLine(PerlCore.create(project));
    }

    public static List getPerlCommandLine(PerlProject project) {
        List commandLine = PerlExecutableUtilities.getPerlCommandLine();
        commandLine.addAll(PerlExecutableUtilities.getPerlIncArgs(project));
        return commandLine;
    }

    public static List getPerlIncArgs(PerlProject project) {
        boolean cygwin = PerlExecutableUtilities.isCygwinInterpreter();
        ArrayList<String> args = new ArrayList<String>();
        Iterator i = project.getIncPath().iterator();
        while (i.hasNext()) {
            String path = ((File)i.next()).getAbsolutePath();
            path = path.replace('\\', '/');
            if (cygwin) {
                path = PerlExecutableUtilities.translatePathForCygwin(path);
            }
            args.add("-I" + path);
        }
        return args;
    }

    public static String getPerlInterpreterPath() {
        List commandLine = PerlExecutableUtilities.getPerlCommandLine();
        if (commandLine.isEmpty()) {
            return null;
        }
        return commandLine.get(0).toString().replace('\\', '/');
    }

    private static boolean isCygwinInterpreter() {
        String type = PerlEditorPlugin.getDefault().getPreferenceStore().getString("INTERPRETER_TYPE");
        return type.equals("Cygwin");
    }

    public static String resolveIncPath(String path) {
        path = path.replace('\\', '/');
        if (PerlExecutableUtilities.isCygwinInterpreter()) {
            path = PerlExecutableUtilities.translatePathForCygwin(path);
        }
        return path;
    }

    static String translatePathForCygwin(String path) {
        path = path.replace('\\', '/');
        Matcher m = CYGWIN_PATH_TRANSLATION.matcher(path = path.toLowerCase());
        if (m.matches()) {
            StringBuffer buf = new StringBuffer();
            buf.append(CygwinMount.drivePrefix());
            buf.append(m.group(1));
            buf.append(m.group(2));
            return buf.toString();
        }
        return path;
    }
}

